/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen;

import java.util.Iterator;
import java.util.LinkedList;
import org.jaxen.expr.DefaultXPathFactory;
import org.jaxen.expr.Expr;
import org.jaxen.expr.FilterExpr;
import org.jaxen.expr.FunctionCallExpr;
import org.jaxen.expr.LocationPath;
import org.jaxen.expr.Predicate;
import org.jaxen.expr.Predicated;
import org.jaxen.expr.Step;
import org.jaxen.expr.XPathExpr;
import org.jaxen.expr.XPathFactory;
import org.jaxen.saxpath.XPathHandler;

public class JaxenHandler
implements XPathHandler {
    private XPathFactory xpathFactory;
    private XPathExpr xpath;
    public boolean simplified;
    public LinkedList stack = new LinkedList();

    public JaxenHandler() {
        this.xpathFactory = new DefaultXPathFactory();
    }

    public void setXPathFactory(XPathFactory xPathFactory) {
        this.xpathFactory = xPathFactory;
    }

    public XPathFactory getXPathFactory() {
        return this.xpathFactory;
    }

    public XPathExpr getXPathExpr() {
        return this.getXPathExpr(true);
    }

    public XPathExpr getXPathExpr(boolean bl) {
        if (bl && !this.simplified) {
            this.xpath.simplify();
            this.simplified = true;
        }
        return this.xpath;
    }

    public void startXPath() {
        this.simplified = false;
        this.pushFrame();
    }

    public void endXPath() {
        this.xpath = this.getXPathFactory().createXPath((Expr)this.pop());
        this.popFrame();
    }

    public void startPathExpr() {
        this.pushFrame();
    }

    public void endPathExpr() {
        Object object;
        LocationPath locationPath;
        if (this.stackSize() == 2) {
            locationPath = (LocationPath)this.pop();
            object = (FilterExpr)this.pop();
        } else {
            object = this.pop();
            if (object instanceof LocationPath) {
                locationPath = (LocationPath)object;
                object = null;
            } else {
                locationPath = null;
                object = (FilterExpr)object;
            }
        }
        this.popFrame();
        JaxenHandler jaxenHandler = this;
        jaxenHandler.push(jaxenHandler.getXPathFactory().createPathExpr((FilterExpr)object, locationPath));
    }

    public void startAbsoluteLocationPath() {
        this.pushFrame();
        JaxenHandler jaxenHandler = this;
        jaxenHandler.push(jaxenHandler.getXPathFactory().createAbsoluteLocationPath());
    }

    public void endAbsoluteLocationPath() {
        this.endLocationPath();
    }

    public void startRelativeLocationPath() {
        this.pushFrame();
        JaxenHandler jaxenHandler = this;
        jaxenHandler.push(jaxenHandler.getXPathFactory().createRelativeLocationPath());
    }

    public void endRelativeLocationPath() {
        this.endLocationPath();
    }

    protected void endLocationPath() {
        LocationPath locationPath = (LocationPath)this.peekFrame().removeFirst();
        this.addSteps(locationPath, this.popFrame().iterator());
        this.push(locationPath);
    }

    protected void addSteps(LocationPath locationPath, Iterator iterator) {
        while (iterator.hasNext()) {
            locationPath.addStep((Step)iterator.next());
        }
    }

    public void startNameStep(int n2, String string, String string2) {
        this.pushFrame();
        JaxenHandler jaxenHandler = this;
        jaxenHandler.push(jaxenHandler.getXPathFactory().createNameStep(n2, string, string2));
    }

    public void endNameStep() {
        this.endStep();
    }

    public void startTextNodeStep(int n2) {
        this.pushFrame();
        JaxenHandler jaxenHandler = this;
        jaxenHandler.push(jaxenHandler.getXPathFactory().createTextNodeStep(n2));
    }

    public void endTextNodeStep() {
        this.endStep();
    }

    public void startCommentNodeStep(int n2) {
        this.pushFrame();
        JaxenHandler jaxenHandler = this;
        jaxenHandler.push(jaxenHandler.getXPathFactory().createCommentNodeStep(n2));
    }

    public void endCommentNodeStep() {
        this.endStep();
    }

    public void startAllNodeStep(int n2) {
        this.pushFrame();
        JaxenHandler jaxenHandler = this;
        jaxenHandler.push(jaxenHandler.getXPathFactory().createAllNodeStep(n2));
    }

    public void endAllNodeStep() {
        this.endStep();
    }

    public void startProcessingInstructionNodeStep(int n2, String string) {
        this.pushFrame();
        JaxenHandler jaxenHandler = this;
        jaxenHandler.push(jaxenHandler.getXPathFactory().createProcessingInstructionNodeStep(n2, string));
    }

    public void endProcessingInstructionNodeStep() {
        this.endStep();
    }

    protected void endStep() {
        Step step = (Step)this.peekFrame().removeFirst();
        this.addPredicates(step, this.popFrame().iterator());
        this.push(step);
    }

    public void startPredicate() {
        this.pushFrame();
    }

    public void endPredicate() {
        Predicate predicate = this.getXPathFactory().createPredicate((Expr)this.pop());
        this.popFrame();
        this.push(predicate);
    }

    public void startFilterExpr() {
        this.pushFrame();
    }

    public void endFilterExpr() {
        Expr expr = (Expr)this.peekFrame().removeFirst();
        expr = this.getXPathFactory().createFilterExpr(expr);
        Iterator iterator = this.popFrame().iterator();
        this.addPredicates((Predicated)((Object)expr), iterator);
        this.push(expr);
    }

    protected void addPredicates(Predicated predicated, Iterator iterator) {
        while (iterator.hasNext()) {
            predicated.addPredicate((Predicate)iterator.next());
        }
    }

    protected void returnExpr() {
        Expr expr = (Expr)this.pop();
        this.popFrame();
        this.push(expr);
    }

    public void startOrExpr() {
    }

    public void endOrExpr(boolean bl) {
        if (bl) {
            Expr expr = (Expr)this.pop();
            Expr expr2 = (Expr)this.pop();
            JaxenHandler jaxenHandler = this;
            jaxenHandler.push(jaxenHandler.getXPathFactory().createOrExpr(expr2, expr));
        }
    }

    public void startAndExpr() {
    }

    public void endAndExpr(boolean bl) {
        if (bl) {
            Expr expr = (Expr)this.pop();
            Expr expr2 = (Expr)this.pop();
            JaxenHandler jaxenHandler = this;
            jaxenHandler.push(jaxenHandler.getXPathFactory().createAndExpr(expr2, expr));
        }
    }

    public void startEqualityExpr() {
    }

    public void endEqualityExpr(int n2) {
        if (n2 != 0) {
            Expr expr = (Expr)this.pop();
            Expr expr2 = (Expr)this.pop();
            JaxenHandler jaxenHandler = this;
            jaxenHandler.push(jaxenHandler.getXPathFactory().createEqualityExpr(expr2, expr, n2));
        }
    }

    public void startRelationalExpr() {
    }

    public void endRelationalExpr(int n2) {
        if (n2 != 0) {
            Expr expr = (Expr)this.pop();
            Expr expr2 = (Expr)this.pop();
            JaxenHandler jaxenHandler = this;
            jaxenHandler.push(jaxenHandler.getXPathFactory().createRelationalExpr(expr2, expr, n2));
        }
    }

    public void startAdditiveExpr() {
    }

    public void endAdditiveExpr(int n2) {
        if (n2 != 0) {
            Expr expr = (Expr)this.pop();
            Expr expr2 = (Expr)this.pop();
            JaxenHandler jaxenHandler = this;
            jaxenHandler.push(jaxenHandler.getXPathFactory().createAdditiveExpr(expr2, expr, n2));
        }
    }

    public void startMultiplicativeExpr() {
    }

    public void endMultiplicativeExpr(int n2) {
        if (n2 != 0) {
            Expr expr = (Expr)this.pop();
            Expr expr2 = (Expr)this.pop();
            JaxenHandler jaxenHandler = this;
            jaxenHandler.push(jaxenHandler.getXPathFactory().createMultiplicativeExpr(expr2, expr, n2));
        }
    }

    public void startUnaryExpr() {
    }

    public void endUnaryExpr(int n2) {
        if (n2 != 0) {
            JaxenHandler jaxenHandler = this;
            jaxenHandler.push(jaxenHandler.getXPathFactory().createUnaryExpr((Expr)this.pop(), n2));
        }
    }

    public void startUnionExpr() {
    }

    public void endUnionExpr(boolean bl) {
        if (bl) {
            Expr expr = (Expr)this.pop();
            Expr expr2 = (Expr)this.pop();
            JaxenHandler jaxenHandler = this;
            jaxenHandler.push(jaxenHandler.getXPathFactory().createUnionExpr(expr2, expr));
        }
    }

    public void number(int n2) {
        JaxenHandler jaxenHandler = this;
        jaxenHandler.push(jaxenHandler.getXPathFactory().createNumberExpr(n2));
    }

    public void number(double d2) {
        JaxenHandler jaxenHandler = this;
        jaxenHandler.push(jaxenHandler.getXPathFactory().createNumberExpr(d2));
    }

    public void literal(String string) {
        JaxenHandler jaxenHandler = this;
        jaxenHandler.push(jaxenHandler.getXPathFactory().createLiteralExpr(string));
    }

    public void variableReference(String string, String string2) {
        JaxenHandler jaxenHandler = this;
        jaxenHandler.push(jaxenHandler.getXPathFactory().createVariableReferenceExpr(string, string2));
    }

    public void startFunction(String string, String string2) {
        this.pushFrame();
        JaxenHandler jaxenHandler = this;
        jaxenHandler.push(jaxenHandler.getXPathFactory().createFunctionCallExpr(string, string2));
    }

    public void endFunction() {
        FunctionCallExpr functionCallExpr = (FunctionCallExpr)this.peekFrame().removeFirst();
        this.addParameters(functionCallExpr, this.popFrame().iterator());
        this.push(functionCallExpr);
    }

    protected void addParameters(FunctionCallExpr functionCallExpr, Iterator iterator) {
        while (iterator.hasNext()) {
            functionCallExpr.addParameter((Expr)iterator.next());
        }
    }

    protected int stackSize() {
        return this.peekFrame().size();
    }

    protected void push(Object object) {
        this.peekFrame().addLast(object);
    }

    protected Object pop() {
        return this.peekFrame().removeLast();
    }

    protected boolean canPop() {
        return this.peekFrame().size() > 0;
    }

    protected void pushFrame() {
        this.stack.addLast(new LinkedList());
    }

    protected LinkedList popFrame() {
        return (LinkedList)this.stack.removeLast();
    }

    protected LinkedList peekFrame() {
        return (LinkedList)this.stack.getLast();
    }
}

