/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.dom;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jaxen.DefaultNavigator;
import org.jaxen.FunctionCallException;
import org.jaxen.JaxenConstants;
import org.jaxen.Navigator;
import org.jaxen.XPath;
import org.jaxen.dom.DOMXPath;
import org.jaxen.dom.DocumentNavigator$1;
import org.jaxen.dom.DocumentNavigator$2;
import org.jaxen.dom.DocumentNavigator$3;
import org.jaxen.dom.DocumentNavigator$4;
import org.jaxen.dom.DocumentNavigator$5;
import org.jaxen.dom.DocumentNavigator$6;
import org.jaxen.dom.DocumentNavigator$AttributeIterator;
import org.jaxen.dom.NamespaceNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.SAXException;

public class DocumentNavigator
extends DefaultNavigator {
    private static final long serialVersionUID = 8460943068889528115L;
    private static final DocumentNavigator SINGLETON = new DocumentNavigator();

    public static Navigator getInstance() {
        return SINGLETON;
    }

    public Iterator getChildAxisIterator(Object object) {
        Node node = (Node)object;
        if (node.getNodeType() == 1 || node.getNodeType() == 9) {
            return new DocumentNavigator$1(this, (Node)object);
        }
        return JaxenConstants.EMPTY_ITERATOR;
    }

    public Iterator getParentAxisIterator(Object object) {
        if ((object = (Node)object).getNodeType() == 2) {
            return new DocumentNavigator$2(this, (Node)object);
        }
        return new DocumentNavigator$3(this, (Node)object);
    }

    public Object getParentNode(Object object) {
        if ((object = (Node)object).getNodeType() == 2) {
            return ((Attr)object).getOwnerElement();
        }
        return object.getParentNode();
    }

    public Iterator getFollowingSiblingAxisIterator(Object object) {
        return new DocumentNavigator$4(this, (Node)object);
    }

    public Iterator getPrecedingSiblingAxisIterator(Object object) {
        return new DocumentNavigator$5(this, (Node)object);
    }

    public Iterator getFollowingAxisIterator(Object object) {
        return new DocumentNavigator$6(this, (Node)object);
    }

    public Iterator getAttributeAxisIterator(Object object) {
        if (this.isElement(object)) {
            return new DocumentNavigator$AttributeIterator((Node)object);
        }
        return JaxenConstants.EMPTY_ITERATOR;
    }

    public Iterator getNamespaceAxisIterator(Object object) {
        if (this.isElement(object)) {
            Node node;
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
            for (node = (Node)object; node != null; node = node.getParentNode()) {
                Object object2;
                Object object3;
                int n2;
                Object object4;
                Object object5 = node.getNamespaceURI();
                if (object5 != null && !"".equals(object5) && !hashMap.containsKey(object4 = node.getPrefix())) {
                    object5 = new NamespaceNode((Node)object, (String)object4, (String)object5);
                    hashMap.put(object4, object5);
                }
                if (!node.hasAttributes()) continue;
                object4 = node.getAttributes();
                int n3 = object4.getLength();
                for (n2 = 0; n2 < n3; ++n2) {
                    object3 = (Attr)object4.item(n2);
                    object2 = object3.getNamespaceURI();
                    if ("http://www.w3.org/2000/xmlns/".equals(object2) || object2 == null) continue;
                    object3 = object3.getPrefix();
                    object2 = new NamespaceNode((Node)object, (String)object3, (String)object2);
                    if (hashMap.containsKey(object3)) continue;
                    hashMap.put(object3, object2);
                }
                for (n2 = 0; n2 < n3; ++n2) {
                    object3 = (Attr)object4.item(n2);
                    object2 = object3.getNamespaceURI();
                    if (!"http://www.w3.org/2000/xmlns/".equals(object2) || hashMap.containsKey(object2 = ((NamespaceNode)(object3 = new NamespaceNode((Node)object, (Node)object3))).getNodeName())) continue;
                    hashMap.put(object2, object3);
                }
            }
            hashMap.put("xml", new NamespaceNode((Node)object, "xml", "http://www.w3.org/XML/1998/namespace"));
            node = (NamespaceNode)hashMap.get("");
            if (node != null && ((NamespaceNode)node).getNodeValue().length() == 0) {
                hashMap.remove("");
            }
            return hashMap.values().iterator();
        }
        return JaxenConstants.EMPTY_ITERATOR;
    }

    public XPath parseXPath(String string) {
        return new DOMXPath(string);
    }

    public Object getDocumentNode(Object object) {
        if (this.isDocument(object)) {
            return object;
        }
        return ((Node)object).getOwnerDocument();
    }

    public String getElementNamespaceUri(Object object) {
        try {
            object = (Node)object;
            if (object.getNodeType() == 1) {
                return object.getNamespaceURI();
            }
        }
        catch (ClassCastException classCastException) {}
        return null;
    }

    public String getElementName(Object object) {
        if (this.isElement(object)) {
            String string = ((Node)object).getLocalName();
            if (string == null) {
                string = ((Node)object).getNodeName();
            }
            return string;
        }
        return null;
    }

    public String getElementQName(Object object) {
        try {
            object = (Node)object;
            if (object.getNodeType() == 1) {
                return object.getNodeName();
            }
        }
        catch (ClassCastException classCastException) {}
        return null;
    }

    public String getAttributeNamespaceUri(Object object) {
        try {
            object = (Node)object;
            if (object.getNodeType() == 2) {
                return object.getNamespaceURI();
            }
        }
        catch (ClassCastException classCastException) {}
        return null;
    }

    public String getAttributeName(Object object) {
        if (this.isAttribute(object)) {
            String string = ((Node)object).getLocalName();
            if (string == null) {
                string = ((Node)object).getNodeName();
            }
            return string;
        }
        return null;
    }

    public String getAttributeQName(Object object) {
        try {
            object = (Node)object;
            if (object.getNodeType() == 2) {
                return object.getNodeName();
            }
        }
        catch (ClassCastException classCastException) {}
        return null;
    }

    public boolean isDocument(Object object) {
        return object instanceof Node && ((Node)object).getNodeType() == 9;
    }

    public boolean isNamespace(Object object) {
        return object instanceof NamespaceNode;
    }

    public boolean isElement(Object object) {
        return object instanceof Node && ((Node)object).getNodeType() == 1;
    }

    public boolean isAttribute(Object object) {
        return object instanceof Node && ((Node)object).getNodeType() == 2 && !"http://www.w3.org/2000/xmlns/".equals(((Node)object).getNamespaceURI());
    }

    public boolean isComment(Object object) {
        return object instanceof Node && ((Node)object).getNodeType() == 8;
    }

    public boolean isText(Object object) {
        if (object instanceof Node) {
            switch (((Node)object).getNodeType()) {
                case 3: 
                case 4: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public boolean isProcessingInstruction(Object object) {
        return object instanceof Node && ((Node)object).getNodeType() == 7;
    }

    public String getElementStringValue(Object object) {
        if (this.isElement(object)) {
            return this.getStringValue((Node)object, new StringBuffer()).toString();
        }
        return null;
    }

    private StringBuffer getStringValue(Node object, StringBuffer stringBuffer) {
        if (this.isText(object)) {
            stringBuffer.append(object.getNodeValue());
        } else {
            object = object.getChildNodes();
            int n2 = object.getLength();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.getStringValue(object.item(i2), stringBuffer);
            }
        }
        return stringBuffer;
    }

    public String getAttributeStringValue(Object object) {
        if (this.isAttribute(object)) {
            return ((Node)object).getNodeValue();
        }
        return null;
    }

    public String getTextStringValue(Object object) {
        if (this.isText(object)) {
            return ((Node)object).getNodeValue();
        }
        return null;
    }

    public String getCommentStringValue(Object object) {
        if (this.isComment(object)) {
            return ((Node)object).getNodeValue();
        }
        return null;
    }

    public String getNamespaceStringValue(Object object) {
        if (this.isNamespace(object)) {
            return ((NamespaceNode)object).getNodeValue();
        }
        return null;
    }

    public String getNamespacePrefix(Object object) {
        if (this.isNamespace(object)) {
            return ((NamespaceNode)object).getLocalName();
        }
        return null;
    }

    public String translateNamespacePrefixToUri(String string, Object object) {
        object = ((DefaultNavigator)this).getNamespaceAxisIterator(object);
        while (object.hasNext()) {
            NamespaceNode namespaceNode = (NamespaceNode)object.next();
            if (!string.equals(namespaceNode.getNodeName())) continue;
            return namespaceNode.getNodeValue();
        }
        return null;
    }

    public Object getDocument(String string) {
        try {
            Object object = DocumentBuilderFactory.newInstance();
            ((DocumentBuilderFactory)object).setNamespaceAware(true);
            object = ((DocumentBuilderFactory)object).newDocumentBuilder();
            return ((DocumentBuilder)object).parse(string);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new FunctionCallException("JAXP setup error in document() function: " + parserConfigurationException.getMessage(), parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new FunctionCallException("XML error in document() function: " + sAXException.getMessage(), sAXException);
        }
        catch (IOException iOException) {
            throw new FunctionCallException("I/O error in document() function: " + iOException.getMessage(), iOException);
        }
    }

    public String getProcessingInstructionTarget(Object object) {
        if (this.isProcessingInstruction(object)) {
            object = (ProcessingInstruction)object;
            return object.getTarget();
        }
        throw new ClassCastException(object + " is not a processing instruction");
    }

    public String getProcessingInstructionData(Object object) {
        if (this.isProcessingInstruction(object)) {
            object = (ProcessingInstruction)object;
            return object.getData();
        }
        throw new ClassCastException(object + " is not a processing instruction");
    }

    public Object getElementById(Object object, String string) {
        if ((object = (Document)((DefaultNavigator)this).getDocumentNode(object)) != null) {
            return object.getElementById(string);
        }
        return null;
    }
}

