/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.dom4j;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.CDATA;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.ProcessingInstruction;
import org.dom4j.QName;
import org.dom4j.Text;
import org.dom4j.io.SAXReader;
import org.dom4j.tree.AbstractNode;
import org.jaxen.DefaultNavigator;
import org.jaxen.FunctionCallException;
import org.jaxen.JaxenConstants;
import org.jaxen.NamedAccessNavigator;
import org.jaxen.Navigator;
import org.jaxen.XPath;
import org.jaxen.dom4j.DocumentNavigator$Singleton;
import org.jaxen.dom4j.Dom4jXPath;
import org.jaxen.util.SingleObjectIterator;

public class DocumentNavigator
extends DefaultNavigator
implements NamedAccessNavigator {
    private static final long serialVersionUID = 5582300797286535936L;
    private transient SAXReader reader;

    public static Navigator getInstance() {
        return DocumentNavigator$Singleton.access$000();
    }

    public boolean isElement(Object object) {
        return object instanceof Element;
    }

    public boolean isComment(Object object) {
        return object instanceof Comment;
    }

    public boolean isText(Object object) {
        return object instanceof Text || object instanceof CDATA;
    }

    public boolean isAttribute(Object object) {
        return object instanceof Attribute;
    }

    public boolean isProcessingInstruction(Object object) {
        return object instanceof ProcessingInstruction;
    }

    public boolean isDocument(Object object) {
        return object instanceof Document;
    }

    public boolean isNamespace(Object object) {
        return object instanceof Namespace;
    }

    public String getElementName(Object object) {
        object = (Element)object;
        return object.getName();
    }

    public String getElementNamespaceUri(Object object) {
        object = (Element)object;
        if ((object = object.getNamespaceURI()) == null) {
            return "";
        }
        return object;
    }

    public String getElementQName(Object object) {
        object = (Element)object;
        return object.getQualifiedName();
    }

    public String getAttributeName(Object object) {
        object = (Attribute)object;
        return object.getName();
    }

    public String getAttributeNamespaceUri(Object object) {
        object = (Attribute)object;
        if ((object = object.getNamespaceURI()) == null) {
            return "";
        }
        return object;
    }

    public String getAttributeQName(Object object) {
        object = (Attribute)object;
        return object.getQualifiedName();
    }

    public Iterator getChildAxisIterator(Object object) {
        Iterator<Node> iterator = null;
        if (object instanceof Branch) {
            object = (Branch)object;
            iterator = object.nodeIterator();
        }
        if (iterator != null) {
            return iterator;
        }
        return JaxenConstants.EMPTY_ITERATOR;
    }

    public Iterator getChildAxisIterator(Object object, String string, String string2, String string3) {
        if (object instanceof Element) {
            object = (Element)object;
            return object.elementIterator(QName.get(string, string2, string3));
        }
        if (object instanceof Document) {
            object = (Document)object;
            if ((object = object.getRootElement()) == null || !object.getName().equals(string)) {
                return JaxenConstants.EMPTY_ITERATOR;
            }
            if (string3 != null && !string3.equals(object.getNamespaceURI())) {
                return JaxenConstants.EMPTY_ITERATOR;
            }
            return new SingleObjectIterator(object);
        }
        return JaxenConstants.EMPTY_ITERATOR;
    }

    public Iterator getParentAxisIterator(Object object) {
        if (object instanceof Document) {
            return JaxenConstants.EMPTY_ITERATOR;
        }
        Branch branch = (object = (Node)object).getParent();
        if (branch == null) {
            branch = object.getDocument();
        }
        return new SingleObjectIterator(branch);
    }

    public Iterator getAttributeAxisIterator(Object object) {
        if (!(object instanceof Element)) {
            return JaxenConstants.EMPTY_ITERATOR;
        }
        object = (Element)object;
        return object.attributeIterator();
    }

    public Iterator getAttributeAxisIterator(Object object, String string, String string2, String string3) {
        if (object instanceof Element) {
            object = (Element)object;
            if ((object = object.attribute(QName.get(string, string2, string3))) == null) {
                return JaxenConstants.EMPTY_ITERATOR;
            }
            return new SingleObjectIterator(object);
        }
        return JaxenConstants.EMPTY_ITERATOR;
    }

    public Iterator getNamespaceAxisIterator(Object object) {
        if (!(object instanceof Element)) {
            return JaxenConstants.EMPTY_ITERATOR;
        }
        object = (Element)object;
        ArrayList<Node> arrayList = new ArrayList<Node>();
        HashSet<Object> hashSet = new HashSet<Object>();
        for (Object object2 = object; object2 != null; object2 = object2.getParent()) {
            Node node;
            Object object3 = new ArrayList<Namespace>(object2.declaredNamespaces());
            object3.add((Namespace)object2.getNamespace());
            Iterator<Attribute> iterator = object2.attributes().iterator();
            while (iterator.hasNext()) {
                node = iterator.next();
                object3.add((Namespace)node.getNamespace());
            }
            iterator = object3.iterator();
            while (iterator.hasNext()) {
                node = (Namespace)((Object)iterator.next());
                if (node == Namespace.NO_NAMESPACE || hashSet.contains(object3 = ((Namespace)node).getPrefix())) continue;
                hashSet.add(object3);
                arrayList.add(((AbstractNode)node).asXPathResult((Element)object));
            }
        }
        arrayList.add(Namespace.XML_NAMESPACE.asXPathResult((Element)object));
        return arrayList.iterator();
    }

    public Object getDocumentNode(Object object) {
        if (object instanceof Document) {
            return object;
        }
        if (object instanceof Node) {
            object = (Node)object;
            return object.getDocument();
        }
        return null;
    }

    public XPath parseXPath(String string) {
        return new Dom4jXPath(string);
    }

    public Object getParentNode(Object object) {
        if (object instanceof Node) {
            Node node = (Node)object;
            Branch branch = node.getParent();
            if (branch == null && (branch = node.getDocument()) == object) {
                return null;
            }
            return branch;
        }
        return null;
    }

    public String getTextStringValue(Object object) {
        return this.getNodeStringValue((Node)object);
    }

    public String getElementStringValue(Object object) {
        return this.getNodeStringValue((Node)object);
    }

    public String getAttributeStringValue(Object object) {
        return this.getNodeStringValue((Node)object);
    }

    private String getNodeStringValue(Node node) {
        return node.getStringValue();
    }

    public String getNamespaceStringValue(Object object) {
        object = (Namespace)object;
        return ((Namespace)object).getURI();
    }

    public String getNamespacePrefix(Object object) {
        object = (Namespace)object;
        return ((Namespace)object).getPrefix();
    }

    public String getCommentStringValue(Object object) {
        object = (Comment)object;
        return object.getText();
    }

    public String translateNamespacePrefixToUri(String string, Object object) {
        Element element = null;
        if (object instanceof Element) {
            element = (Element)object;
        } else if (object instanceof Node) {
            object = (Node)object;
            element = object.getParent();
        }
        if (element != null && (object = element.getNamespaceForPrefix(string)) != null) {
            return ((Namespace)object).getURI();
        }
        return null;
    }

    public short getNodeType(Object object) {
        if (object instanceof Node) {
            return ((Node)object).getNodeType();
        }
        return 0;
    }

    public Object getDocument(String string) {
        try {
            return this.getSAXReader().read(string);
        }
        catch (DocumentException documentException) {
            throw new FunctionCallException("Failed to parse document for URI: " + string, documentException);
        }
    }

    public String getProcessingInstructionTarget(Object object) {
        object = (ProcessingInstruction)object;
        return object.getTarget();
    }

    public String getProcessingInstructionData(Object object) {
        object = (ProcessingInstruction)object;
        return object.getText();
    }

    public SAXReader getSAXReader() {
        if (this.reader == null) {
            this.reader = new SAXReader();
            this.reader.setMergeAdjacentText(true);
        }
        return this.reader;
    }

    public void setSAXReader(SAXReader sAXReader) {
        this.reader = sAXReader;
    }
}

