/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.expr;

import java.util.ArrayList;
import java.util.List;
import org.jaxen.Context;
import org.jaxen.expr.DefaultExpr;
import org.jaxen.expr.Expr;
import org.jaxen.expr.FilterExpr;
import org.jaxen.expr.Predicate;
import org.jaxen.expr.PredicateSet;
import org.jaxen.expr.Predicated;

public class DefaultFilterExpr
extends DefaultExpr
implements FilterExpr,
Predicated {
    private static final long serialVersionUID = -549640659288005735L;
    private Expr expr;
    private PredicateSet predicates;

    public DefaultFilterExpr(PredicateSet predicateSet) {
        this.predicates = predicateSet;
    }

    public DefaultFilterExpr(Expr expr, PredicateSet predicateSet) {
        this.expr = expr;
        this.predicates = predicateSet;
    }

    public void addPredicate(Predicate predicate) {
        this.predicates.addPredicate(predicate);
    }

    public List getPredicates() {
        return this.predicates.getPredicates();
    }

    public PredicateSet getPredicateSet() {
        return this.predicates;
    }

    public Expr getExpr() {
        return this.expr;
    }

    public String toString() {
        return "[(DefaultFilterExpr): expr: " + this.expr + " predicates: " + this.predicates + " ]";
    }

    public String getText() {
        String string = "";
        if (this.expr != null) {
            string = this.expr.getText();
        }
        string = string + this.predicates.getText();
        return string;
    }

    public Expr simplify() {
        this.predicates.simplify();
        if (this.expr != null) {
            this.expr = this.expr.simplify();
        }
        if (this.predicates.getPredicates().size() == 0) {
            return this.getExpr();
        }
        return this;
    }

    public boolean asBoolean(Context context) {
        ArrayList arrayList;
        if (this.expr != null) {
            arrayList = this.expr.evaluate(context);
        } else {
            arrayList = context.getNodeSet();
            ArrayList arrayList2 = new ArrayList(arrayList.size());
            arrayList2.addAll(arrayList);
            arrayList = arrayList2;
        }
        if (arrayList instanceof Boolean) {
            arrayList = (Boolean)((Object)arrayList);
            return (Boolean)((Object)arrayList);
        }
        if (arrayList instanceof List) {
            return this.getPredicateSet().evaluateAsBoolean(arrayList, context.getContextSupport());
        }
        return false;
    }

    public Object evaluate(Context object) {
        Object object2 = this.getExpr().evaluate((Context)object);
        if (object2 instanceof List) {
            object2 = object = this.getPredicateSet().evaluatePredicates((List)object2, ((Context)object).getContextSupport());
        }
        return object2;
    }
}

