/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.expr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jaxen.Context;
import org.jaxen.ContextSupport;
import org.jaxen.Navigator;
import org.jaxen.UnresolvableException;
import org.jaxen.expr.DefaultStep;
import org.jaxen.expr.IdentitySet;
import org.jaxen.expr.NameStep;
import org.jaxen.expr.PredicateSet;
import org.jaxen.expr.iter.IterableAxis;

public class DefaultNameStep
extends DefaultStep
implements NameStep {
    private static final long serialVersionUID = 428414912247718390L;
    private String prefix;
    private String localName;
    private boolean matchesAnyName;
    private boolean hasPrefix;

    public DefaultNameStep(IterableAxis iterableAxis, String string, String string2, PredicateSet predicateSet) {
        super(iterableAxis, predicateSet);
        this.prefix = string;
        this.localName = string2;
        this.matchesAnyName = "*".equals(string2);
        this.hasPrefix = this.prefix != null && this.prefix.length() > 0;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getLocalName() {
        return this.localName;
    }

    public boolean isMatchesAnyName() {
        return this.matchesAnyName;
    }

    public String getText() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(this.getAxisName()).append("::");
        if (this.getPrefix() != null && this.getPrefix().length() > 0) {
            stringBuffer.append(this.getPrefix()).append(':');
        }
        return stringBuffer.append(this.getLocalName()).append(super.getText()).toString();
    }

    public List evaluate(Context serializable) {
        int n2;
        List list = ((Context)serializable).getNodeSet();
        int n3 = list.size();
        if (n3 == 0) {
            return Collections.EMPTY_LIST;
        }
        serializable = ((Context)serializable).getContextSupport();
        IterableAxis iterableAxis = this.getIterableAxis();
        int n4 = n2 = !this.matchesAnyName && iterableAxis.supportsNamedAccess((ContextSupport)serializable) ? 1 : 0;
        if (n3 == 1) {
            Object e2 = list.get(0);
            if (n2 != 0) {
                String string = null;
                if (this.hasPrefix && (string = ((ContextSupport)serializable).translateNamespacePrefixToUri(this.prefix)) == null) {
                    throw new UnresolvableException("XPath expression uses unbound namespace prefix " + this.prefix);
                }
                Iterator iterator = iterableAxis.namedAccessIterator(e2, (ContextSupport)serializable, this.localName, this.prefix, string);
                if (iterator == null || !iterator.hasNext()) {
                    return Collections.EMPTY_LIST;
                }
                ArrayList arrayList = new ArrayList();
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next());
                }
                return this.getPredicateSet().evaluatePredicates(arrayList, (ContextSupport)serializable);
            }
            Iterator iterator = iterableAxis.iterator(e2, (ContextSupport)serializable);
            if (iterator == null || !iterator.hasNext()) {
                return Collections.EMPTY_LIST;
            }
            ArrayList arrayList = new ArrayList(n3);
            while (iterator.hasNext()) {
                Object e3 = iterator.next();
                if (!this.matches(e3, (ContextSupport)serializable)) continue;
                arrayList.add(e3);
            }
            return this.getPredicateSet().evaluatePredicates(arrayList, (ContextSupport)serializable);
        }
        IdentitySet identitySet = new IdentitySet();
        ArrayList arrayList = new ArrayList(n3);
        ArrayList arrayList2 = new ArrayList(n3);
        if (n2 != 0) {
            String string = null;
            if (this.hasPrefix && (string = ((ContextSupport)serializable).translateNamespacePrefixToUri(this.prefix)) == null) {
                throw new UnresolvableException("XPath expression uses unbound namespace prefix " + this.prefix);
            }
            for (int i2 = 0; i2 < n3; ++i2) {
                Object object = list.get(i2);
                Iterator iterator = iterableAxis.namedAccessIterator(object, (ContextSupport)serializable, this.localName, this.prefix, string);
                if (iterator == null || !iterator.hasNext()) continue;
                while (iterator.hasNext()) {
                    object = iterator.next();
                    arrayList.add(object);
                }
                object = this.getPredicateSet().evaluatePredicates(arrayList, (ContextSupport)serializable);
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    if (identitySet.contains(object)) continue;
                    identitySet.add(object);
                    arrayList2.add(object);
                }
                arrayList.clear();
            }
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                Object object;
                Object e4 = list.get(n2);
                Iterator iterator = this.axisIterator(e4, (ContextSupport)serializable);
                if (iterator == null || !iterator.hasNext()) continue;
                while (iterator.hasNext()) {
                    object = iterator.next();
                    if (!this.matches(object, (ContextSupport)serializable)) continue;
                    arrayList.add(object);
                }
                object = this.getPredicateSet().evaluatePredicates(arrayList, (ContextSupport)serializable);
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    if (identitySet.contains(object)) continue;
                    identitySet.add(object);
                    arrayList2.add(object);
                }
                arrayList.clear();
            }
        }
        return arrayList2;
    }

    public boolean matches(Object object, ContextSupport contextSupport) {
        String string;
        Navigator navigator = contextSupport.getNavigator();
        String string2 = null;
        String string3 = null;
        if (navigator.isElement(object)) {
            string = navigator.getElementName(object);
            string3 = navigator.getElementNamespaceUri(object);
        } else {
            if (navigator.isText(object)) {
                return false;
            }
            if (navigator.isAttribute(object)) {
                if (this.getAxis() != 9) {
                    return false;
                }
                string = navigator.getAttributeName(object);
                string3 = navigator.getAttributeNamespaceUri(object);
            } else {
                if (navigator.isDocument(object)) {
                    return false;
                }
                if (navigator.isNamespace(object)) {
                    if (this.getAxis() != 10) {
                        return false;
                    }
                    string = navigator.getNamespacePrefix(object);
                } else {
                    return false;
                }
            }
        }
        if (this.hasPrefix) {
            string2 = contextSupport.translateNamespacePrefixToUri(this.prefix);
            if (string2 == null) {
                throw new UnresolvableException("Cannot resolve namespace prefix '" + this.prefix + "'");
            }
        } else if (this.matchesAnyName) {
            return true;
        }
        if (this.hasNamespace(string2) != this.hasNamespace(string3)) {
            return false;
        }
        if (this.matchesAnyName || string.equals(this.getLocalName())) {
            return this.matchesNamespaceURIs(string2, string3);
        }
        return false;
    }

    private boolean hasNamespace(String string) {
        return string != null && string.length() > 0;
    }

    protected boolean matchesNamespaceURIs(String string, String string2) {
        if (string == string2) {
            return true;
        }
        if (string == null) {
            return string2.length() == 0;
        }
        if (string2 == null) {
            return string.length() == 0;
        }
        return string.equals(string2);
    }

    public String toString() {
        String string = this.getPrefix();
        string = "".equals(string) ? this.getLocalName() : this.getPrefix() + ":" + this.getLocalName();
        return "[(DefaultNameStep): " + string + "]";
    }
}

