/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.function;

import java.util.List;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jaxen.Navigator;

public class BooleanFunction
implements Function {
    public Object call(Context context, List list) {
        if (list.size() == 1) {
            return BooleanFunction.evaluate(list.get(0), context.getNavigator());
        }
        throw new FunctionCallException("boolean() requires one argument");
    }

    public static Boolean evaluate(Object object, Navigator navigator) {
        if (object instanceof List) {
            List list = (List)object;
            if (list.size() == 0) {
                return Boolean.FALSE;
            }
            object = list.get(0);
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Number) {
            double d2 = ((Number)object).doubleValue();
            if (d2 == 0.0 || Double.isNaN(d2)) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        if (object instanceof String) {
            if (((String)object).length() > 0) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (object != null) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

