/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.function;

import java.util.List;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jaxen.Navigator;
import org.jaxen.UnsupportedAxisException;
import org.jaxen.function.StringFunction;

public class LangFunction
implements Function {
    private static final String LANG_LOCALNAME = "lang";
    private static final String XMLNS_URI = "http://www.w3.org/XML/1998/namespace";

    public Object call(Context context, List list) {
        if (list.size() != 1) {
            throw new FunctionCallException("lang() requires exactly one argument.");
        }
        list = list.get(0);
        try {
            return LangFunction.evaluate(context.getNodeSet(), list, context.getNavigator());
        }
        catch (UnsupportedAxisException unsupportedAxisException) {
            throw new FunctionCallException("Can't evaluate lang()", unsupportedAxisException);
        }
    }

    private static Boolean evaluate(List list, Object object, Navigator navigator) {
        if (LangFunction.evaluate(list.get(0), StringFunction.evaluate(object, navigator), navigator)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private static boolean evaluate(Object object, String string, Navigator navigator) {
        Object object2 = object;
        if (!navigator.isElement(object2)) {
            object2 = navigator.getParentNode(object);
        }
        while (object2 != null && navigator.isElement(object2)) {
            object = navigator.getAttributeAxisIterator(object2);
            while (object.hasNext()) {
                Object e2 = object.next();
                if (!LANG_LOCALNAME.equals(navigator.getAttributeName(e2)) || !XMLNS_URI.equals(navigator.getAttributeNamespaceUri(e2))) continue;
                return LangFunction.isSublang(navigator.getAttributeStringValue(e2), string);
            }
            object2 = navigator.getParentNode(object2);
        }
        return false;
    }

    private static boolean isSublang(String string, String string2) {
        if (string.equalsIgnoreCase(string2)) {
            return true;
        }
        int n2 = string2.length();
        return string.length() > n2 && string.charAt(n2) == '-' && string.substring(0, n2).equalsIgnoreCase(string2);
    }
}

