/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.function;

import java.util.Iterator;
import java.util.List;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jaxen.Navigator;
import org.jaxen.function.StringFunction;

public class NumberFunction
implements Function {
    private static final Double NaN = Double.NaN;

    public Object call(Context context, List list) {
        if (list.size() == 1) {
            return NumberFunction.evaluate(list.get(0), context.getNavigator());
        }
        if (list.size() == 0) {
            return NumberFunction.evaluate(context.getNodeSet(), context.getNavigator());
        }
        throw new FunctionCallException("number() takes at most one argument.");
    }

    public static Double evaluate(Object object, Navigator navigator) {
        while (true) {
            if (object instanceof Double) {
                return (Double)object;
            }
            if (object instanceof String) {
                object = (String)object;
                try {
                    object = new Double((String)object);
                    return object;
                }
                catch (NumberFormatException numberFormatException) {
                    return NaN;
                }
            }
            if (object instanceof List || object instanceof Iterator) {
                object = StringFunction.evaluate(object, navigator);
                continue;
            }
            if (!navigator.isElement(object) && !navigator.isAttribute(object) && !navigator.isText(object) && !navigator.isComment(object) && !navigator.isProcessingInstruction(object) && !navigator.isDocument(object) && !navigator.isNamespace(object)) break;
            object = StringFunction.evaluate(object, navigator);
        }
        if (object instanceof Boolean) {
            if (Boolean.TRUE.equals(object)) {
                return 1.0;
            }
            return 0.0;
        }
        return NaN;
    }

    public static boolean isNaN(double d2) {
        return Double.isNaN(d2);
    }

    public static boolean isNaN(Double d2) {
        return d2.equals(NaN);
    }
}

