/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.function;

import java.util.List;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jaxen.Navigator;
import org.jaxen.function.NumberFunction;
import org.jaxen.function.RoundFunction;
import org.jaxen.function.StringFunction;
import org.jaxen.function.StringLengthFunction;

public class SubstringFunction
implements Function {
    public Object call(Context serializable, List object) {
        int n2 = object.size();
        if (n2 < 2 || n2 > 3) {
            throw new FunctionCallException("substring() requires two or three arguments.");
        }
        serializable = serializable.getNavigator();
        String string = StringFunction.evaluate(object.get(0), (Navigator)serializable);
        if (string == null) {
            return "";
        }
        int n3 = StringLengthFunction.evaluate(object.get(0), (Navigator)serializable).intValue();
        if (n3 == 0) {
            return "";
        }
        Double d2 = NumberFunction.evaluate(object.get(1), (Navigator)serializable);
        if (d2.isNaN()) {
            return "";
        }
        int n4 = RoundFunction.evaluate(d2, (Navigator)serializable).intValue() - 1;
        int n5 = n3;
        if (n2 == 3) {
            n5 = !((Double)(object = NumberFunction.evaluate(object.get(2), (Navigator)serializable))).isNaN() ? RoundFunction.evaluate(object, (Navigator)serializable).intValue() : 0;
        }
        if (n5 < 0) {
            return "";
        }
        int n6 = n4 + n5;
        if (n2 == 2) {
            n6 = n3;
        }
        if (n4 < 0) {
            n4 = 0;
        } else if (n4 > n3) {
            return "";
        }
        if (n6 > n3) {
            n6 = n3;
        } else if (n6 < n4) {
            return "";
        }
        if (n3 == string.length()) {
            return string.substring(n4, n6);
        }
        return SubstringFunction.unicodeSubstring(string, n4, n6);
    }

    private static String unicodeSubstring(String string, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = string.charAt(n4);
            if (i2 >= n2) {
                stringBuffer.append(c2);
            }
            if (c2 >= '\ud800') {
                ++n4;
                if (i2 >= n2) {
                    stringBuffer.append(string.charAt(n4));
                }
            }
            ++n4;
        }
        return stringBuffer.toString();
    }
}

