/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.jdom;

import java.util.HashMap;
import java.util.Iterator;
import org.jaxen.DefaultNavigator;
import org.jaxen.FunctionCallException;
import org.jaxen.JaxenConstants;
import org.jaxen.NamedAccessNavigator;
import org.jaxen.Navigator;
import org.jaxen.XPath;
import org.jaxen.jdom.DocumentNavigator$Singleton;
import org.jaxen.jdom.JDOMXPath;
import org.jaxen.jdom.XPathNamespace;
import org.jaxen.util.SingleObjectIterator;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Parent;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;
import org.jdom.input.SAXBuilder;

public class DocumentNavigator
extends DefaultNavigator
implements NamedAccessNavigator {
    private static final long serialVersionUID = -1636727587303584165L;

    public static Navigator getInstance() {
        return DocumentNavigator$Singleton.access$000();
    }

    public boolean isElement(Object object) {
        return object instanceof Element;
    }

    public boolean isComment(Object object) {
        return object instanceof Comment;
    }

    public boolean isText(Object object) {
        return object instanceof Text || object instanceof CDATA;
    }

    public boolean isAttribute(Object object) {
        return object instanceof Attribute;
    }

    public boolean isProcessingInstruction(Object object) {
        return object instanceof ProcessingInstruction;
    }

    public boolean isDocument(Object object) {
        return object instanceof Document;
    }

    public boolean isNamespace(Object object) {
        return object instanceof Namespace || object instanceof XPathNamespace;
    }

    public String getElementName(Object object) {
        object = (Element)object;
        return object.getName();
    }

    public String getElementNamespaceUri(Object object) {
        object = (Element)object;
        if ((object = object.getNamespaceURI()) != null && ((String)object).length() == 0) {
            return null;
        }
        return object;
    }

    public String getAttributeName(Object object) {
        object = (Attribute)object;
        return object.getName();
    }

    public String getAttributeNamespaceUri(Object object) {
        object = (Attribute)object;
        if ((object = object.getNamespaceURI()) != null && ((String)object).length() == 0) {
            return null;
        }
        return object;
    }

    public Iterator getChildAxisIterator(Object object) {
        if (object instanceof Element) {
            return ((Element)object).getContent().iterator();
        }
        if (object instanceof Document) {
            return ((Document)object).getContent().iterator();
        }
        return JaxenConstants.EMPTY_ITERATOR;
    }

    public Iterator getChildAxisIterator(Object object, String string, String string2, String string3) {
        if (object instanceof Element) {
            object = (Element)object;
            if (string3 == null) {
                return object.getChildren(string).iterator();
            }
            return object.getChildren(string, Namespace.getNamespace((String)string2, (String)string3)).iterator();
        }
        if (object instanceof Document) {
            object = (Document)object;
            if (!(object = object.getRootElement()).getName().equals(string)) {
                return JaxenConstants.EMPTY_ITERATOR;
            }
            if (string3 != null ? !Namespace.getNamespace((String)string2, (String)string3).equals((Object)object.getNamespace()) : object.getNamespace() != Namespace.NO_NAMESPACE) {
                return JaxenConstants.EMPTY_ITERATOR;
            }
            return new SingleObjectIterator(object);
        }
        return JaxenConstants.EMPTY_ITERATOR;
    }

    public Iterator getNamespaceAxisIterator(Object object) {
        if (!(object instanceof Element)) {
            return JaxenConstants.EMPTY_ITERATOR;
        }
        object = (Element)object;
        HashMap<String, XPathNamespace> hashMap = new HashMap<String, XPathNamespace>();
        Object object2 = object;
        while (object2 != null) {
            Object object3 = object2.getNamespace();
            if (object3 != Namespace.NO_NAMESPACE && !hashMap.containsKey(object3.getPrefix())) {
                hashMap.put(object3.getPrefix(), new XPathNamespace((Element)object, (Namespace)object3));
            }
            Attribute attribute = object2.getAdditionalNamespaces().iterator();
            while (attribute.hasNext()) {
                object3 = (Namespace)attribute.next();
                if (hashMap.containsKey(object3.getPrefix())) continue;
                hashMap.put(object3.getPrefix(), new XPathNamespace((Element)object, (Namespace)object3));
            }
            object3 = object2.getAttributes().iterator();
            while (object3.hasNext()) {
                attribute = (Attribute)object3.next();
                if ((attribute = attribute.getNamespace()) == Namespace.NO_NAMESPACE || hashMap.containsKey(attribute.getPrefix())) continue;
                hashMap.put(attribute.getPrefix(), new XPathNamespace((Element)object, (Namespace)attribute));
            }
            if (object2.getParent() instanceof Element) {
                object2 = (Element)object2.getParent();
                continue;
            }
            object2 = null;
        }
        hashMap.put("xml", new XPathNamespace((Element)object, Namespace.XML_NAMESPACE));
        return hashMap.values().iterator();
    }

    public Iterator getParentAxisIterator(Object object) {
        Parent parent = null;
        if (object instanceof Document) {
            return JaxenConstants.EMPTY_ITERATOR;
        }
        if (object instanceof Element) {
            parent = ((Element)object).getParent();
            if (parent == null && ((Element)object).isRootElement()) {
                parent = ((Element)object).getDocument();
            }
        } else if (object instanceof Attribute) {
            parent = ((Attribute)object).getParent();
        } else if (object instanceof XPathNamespace) {
            parent = ((XPathNamespace)object).getJDOMElement();
        } else if (object instanceof ProcessingInstruction) {
            parent = ((ProcessingInstruction)object).getParent();
        } else if (object instanceof Comment) {
            parent = ((Comment)object).getParent();
        } else if (object instanceof Text) {
            parent = ((Text)object).getParent();
        }
        if (parent != null) {
            return new SingleObjectIterator(parent);
        }
        return JaxenConstants.EMPTY_ITERATOR;
    }

    public Iterator getAttributeAxisIterator(Object object) {
        if (!(object instanceof Element)) {
            return JaxenConstants.EMPTY_ITERATOR;
        }
        object = (Element)object;
        return object.getAttributes().iterator();
    }

    public Iterator getAttributeAxisIterator(Object object, String string, String string2, String string3) {
        if (object instanceof Element) {
            object = (Element)object;
            string2 = string3 == null ? Namespace.NO_NAMESPACE : Namespace.getNamespace((String)string2, (String)string3);
            if ((object = object.getAttribute(string, (Namespace)string2)) != null) {
                return new SingleObjectIterator(object);
            }
        }
        return JaxenConstants.EMPTY_ITERATOR;
    }

    public XPath parseXPath(String string) {
        return new JDOMXPath(string);
    }

    public Object getDocumentNode(Object object) {
        if (object instanceof Document) {
            return object;
        }
        object = (Element)object;
        return object.getDocument();
    }

    public String getElementQName(Object object) {
        String string = (object = (Element)object).getNamespacePrefix();
        if (string == null || string.length() == 0) {
            return object.getName();
        }
        return string + ":" + object.getName();
    }

    public String getAttributeQName(Object object) {
        String string = (object = (Attribute)object).getNamespacePrefix();
        if (string == null || "".equals(string)) {
            return object.getName();
        }
        return string + ":" + object.getName();
    }

    public String getNamespaceStringValue(Object object) {
        if (object instanceof Namespace) {
            object = (Namespace)object;
            return object.getURI();
        }
        object = (XPathNamespace)object;
        return ((XPathNamespace)object).getJDOMNamespace().getURI();
    }

    public String getNamespacePrefix(Object object) {
        if (object instanceof Namespace) {
            object = (Namespace)object;
            return object.getPrefix();
        }
        object = (XPathNamespace)object;
        return ((XPathNamespace)object).getJDOMNamespace().getPrefix();
    }

    public String getTextStringValue(Object object) {
        if (object instanceof Text) {
            return ((Text)object).getText();
        }
        if (object instanceof CDATA) {
            return ((CDATA)object).getText();
        }
        return "";
    }

    public String getAttributeStringValue(Object object) {
        object = (Attribute)object;
        return object.getValue();
    }

    public String getElementStringValue(Object iterator) {
        iterator = (Element)iterator;
        StringBuffer stringBuffer = new StringBuffer();
        iterator = iterator.getContent();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (e2 instanceof Text) {
                stringBuffer.append(((Text)e2).getText());
                continue;
            }
            if (e2 instanceof CDATA) {
                stringBuffer.append(((CDATA)e2).getText());
                continue;
            }
            if (!(e2 instanceof Element)) continue;
            stringBuffer.append(this.getElementStringValue(e2));
        }
        return stringBuffer.toString();
    }

    public String getProcessingInstructionTarget(Object object) {
        object = (ProcessingInstruction)object;
        return object.getTarget();
    }

    public String getProcessingInstructionData(Object object) {
        object = (ProcessingInstruction)object;
        return object.getData();
    }

    public String getCommentStringValue(Object object) {
        object = (Comment)object;
        return object.getText();
    }

    public String translateNamespacePrefixToUri(String string, Object object) {
        Element element = null;
        if (object instanceof Element) {
            element = (Element)object;
        } else if (object instanceof Text) {
            element = (Element)((Text)object).getParent();
        } else if (object instanceof Attribute) {
            element = ((Attribute)object).getParent();
        } else if (object instanceof XPathNamespace) {
            element = ((XPathNamespace)object).getJDOMElement();
        } else if (object instanceof Comment) {
            element = (Element)((Comment)object).getParent();
        } else if (object instanceof ProcessingInstruction) {
            element = (Element)((ProcessingInstruction)object).getParent();
        }
        if (element != null && (string = element.getNamespace(string)) != null) {
            return string.getURI();
        }
        return null;
    }

    public Object getDocument(String string) {
        try {
            SAXBuilder sAXBuilder = new SAXBuilder();
            return sAXBuilder.build(string);
        }
        catch (Exception exception) {
            throw new FunctionCallException(exception.getMessage());
        }
    }
}

