/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.pattern;

import java.util.ArrayList;
import java.util.List;
import org.jaxen.Context;
import org.jaxen.JaxenException;
import org.jaxen.expr.FilterExpr;
import org.jaxen.pattern.AnyNodeTest;
import org.jaxen.pattern.NodeTest;
import org.jaxen.pattern.Pattern;
import org.jaxen.util.SingletonList;

public class LocationPathPattern
extends Pattern {
    private NodeTest nodeTest = AnyNodeTest.getInstance();
    private Pattern parentPattern;
    private Pattern ancestorPattern;
    private List filters;
    private boolean absolute;

    public LocationPathPattern() {
    }

    public LocationPathPattern(NodeTest nodeTest) {
        this.nodeTest = nodeTest;
    }

    public Pattern simplify() {
        if (this.parentPattern != null) {
            this.parentPattern = this.parentPattern.simplify();
        }
        if (this.ancestorPattern != null) {
            this.ancestorPattern = this.ancestorPattern.simplify();
        }
        if (this.filters == null) {
            if (this.parentPattern == null && this.ancestorPattern == null) {
                return this.nodeTest;
            }
            if (this.parentPattern != null && this.ancestorPattern == null && this.nodeTest instanceof AnyNodeTest) {
                return this.parentPattern;
            }
        }
        return this;
    }

    public void addFilter(FilterExpr filterExpr) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        this.filters.add(filterExpr);
    }

    public void setParentPattern(Pattern pattern) {
        this.parentPattern = pattern;
    }

    public void setAncestorPattern(Pattern pattern) {
        this.ancestorPattern = pattern;
    }

    public void setNodeTest(NodeTest nodeTest) {
        if (this.nodeTest instanceof AnyNodeTest) {
            this.nodeTest = nodeTest;
            return;
        }
        throw new JaxenException("Attempt to overwrite nodeTest: " + this.nodeTest + " with: " + nodeTest);
    }

    public boolean matches(Object object, Context context) {
        Object object2;
        Object object3 = context.getNavigator();
        if (!this.nodeTest.matches(object, context)) {
            return false;
        }
        if (this.parentPattern != null) {
            object2 = object3.getParentNode(object);
            if (object2 == null) {
                return false;
            }
            if (!this.parentPattern.matches(object2, context)) {
                return false;
            }
        }
        if (this.ancestorPattern != null) {
            object2 = object3.getParentNode(object);
            while (!this.ancestorPattern.matches(object2, context)) {
                if (object2 == null) {
                    return false;
                }
                if (object3.isDocument(object2)) {
                    return false;
                }
                object2 = object3.getParentNode(object2);
            }
        }
        if (this.filters != null) {
            object2 = new SingletonList(object);
            context.setNodeSet((List)object2);
            boolean bl = true;
            object3 = this.filters.iterator();
            while (object3.hasNext()) {
                FilterExpr filterExpr = (FilterExpr)object3.next();
                if (filterExpr.asBoolean(context)) continue;
                bl = false;
                break;
            }
            context.setNodeSet((List)object2);
            return bl;
        }
        return true;
    }

    public double getPriority() {
        if (this.filters != null) {
            return 0.5;
        }
        return this.nodeTest.getPriority();
    }

    public short getMatchType() {
        return this.nodeTest.getMatchType();
    }

    public String getText() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.absolute) {
            stringBuffer.append("/");
        }
        if (this.ancestorPattern != null && ((String)(object = this.ancestorPattern.getText())).length() > 0) {
            stringBuffer.append((String)object);
            stringBuffer.append("//");
        }
        if (this.parentPattern != null && ((String)(object = this.parentPattern.getText())).length() > 0) {
            stringBuffer.append((String)object);
            stringBuffer.append("/");
        }
        stringBuffer.append(this.nodeTest.getText());
        if (this.filters != null) {
            stringBuffer.append("[");
            object = this.filters.iterator();
            while (object.hasNext()) {
                FilterExpr filterExpr = (FilterExpr)object.next();
                stringBuffer.append(filterExpr.getText());
            }
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return super.toString() + "[ absolute: " + this.absolute + " parent: " + this.parentPattern + " ancestor: " + this.ancestorPattern + " filters: " + this.filters + " nodeTest: " + this.nodeTest + " ]";
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    public void setAbsolute(boolean bl) {
        this.absolute = bl;
    }

    public boolean hasAnyNodeTest() {
        return this.nodeTest instanceof AnyNodeTest;
    }
}

