/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.pattern;

import java.util.LinkedList;
import org.jaxen.JaxenHandler;
import org.jaxen.expr.Expr;
import org.jaxen.expr.FilterExpr;
import org.jaxen.pattern.AnyNodeTest;
import org.jaxen.pattern.LocationPathPattern;
import org.jaxen.pattern.NameTest;
import org.jaxen.pattern.NamespaceTest;
import org.jaxen.pattern.NodeTest;
import org.jaxen.pattern.NodeTypeTest;
import org.jaxen.pattern.Pattern;

public class PatternHandler
extends JaxenHandler {
    private Pattern pattern;

    public Pattern getPattern() {
        return this.getPattern(true);
    }

    public Pattern getPattern(boolean bl) {
        if (bl && !this.simplified) {
            this.pattern.simplify();
            this.simplified = true;
        }
        return this.pattern;
    }

    public void endXPath() {
        this.pattern = (Pattern)this.pop();
        System.out.println("stack is: " + this.stack);
        this.popFrame();
    }

    public void endPathExpr() {
        LinkedList linkedList = this.popFrame();
        System.out.println("endPathExpr(): " + linkedList);
        this.push(linkedList.removeFirst());
    }

    public void startAbsoluteLocationPath() {
        this.pushFrame();
        PatternHandler patternHandler = this;
        patternHandler.push(patternHandler.createAbsoluteLocationPath());
    }

    public void endAbsoluteLocationPath() {
        this.endLocationPath();
    }

    public void startRelativeLocationPath() {
        this.pushFrame();
        PatternHandler patternHandler = this;
        patternHandler.push(patternHandler.createRelativeLocationPath());
    }

    public void endRelativeLocationPath() {
        this.endLocationPath();
    }

    public void endLocationPath() {
        LinkedList linkedList = this.popFrame();
        System.out.println("endLocationPath: " + linkedList);
        LocationPathPattern locationPathPattern = (LocationPathPattern)linkedList.removeFirst();
        this.push(locationPathPattern);
        while (!linkedList.isEmpty()) {
            Object object = linkedList.removeFirst();
            if (object instanceof NodeTest) {
                locationPathPattern.setNodeTest((NodeTest)object);
                continue;
            }
            if (object instanceof FilterExpr) {
                locationPathPattern.addFilter((FilterExpr)object);
                continue;
            }
            if (!(object instanceof LocationPathPattern)) continue;
            object = (LocationPathPattern)object;
            locationPathPattern.setParentPattern((Pattern)object);
            locationPathPattern = object;
        }
    }

    public void startNameStep(int n2, String string, String string2) {
        this.pushFrame();
        short s2 = 1;
        switch (n2) {
            case 9: {
                s2 = 2;
                break;
            }
            case 10: {
                s2 = 13;
            }
        }
        if (string != null && string.length() > 0 && !string.equals("*")) {
            this.push(new NamespaceTest(string, s2));
        }
        if (string2 != null && string2.length() > 0 && !string2.equals("*")) {
            this.push(new NameTest(string2, s2));
        }
    }

    public void startTextNodeStep(int n2) {
        this.pushFrame();
        this.push(new NodeTypeTest(3));
    }

    public void startCommentNodeStep(int n2) {
        this.pushFrame();
        this.push(new NodeTypeTest(8));
    }

    public void startAllNodeStep(int n2) {
        this.pushFrame();
        this.push(AnyNodeTest.getInstance());
    }

    public void startProcessingInstructionNodeStep(int n2, String string) {
        this.pushFrame();
        this.push(new NodeTypeTest(7));
    }

    public void endStep() {
        LinkedList linkedList = this.popFrame();
        if (!linkedList.isEmpty()) {
            this.push(linkedList.removeFirst());
            if (!linkedList.isEmpty()) {
                System.out.println("List should now be empty!" + linkedList);
            }
        }
    }

    public void startUnionExpr() {
    }

    public void endUnionExpr(boolean bl) {
        if (bl) {
            Expr expr = (Expr)this.pop();
            Expr expr2 = (Expr)this.pop();
            PatternHandler patternHandler = this;
            patternHandler.push(patternHandler.getXPathFactory().createUnionExpr(expr2, expr));
        }
    }

    protected Pattern createAbsoluteLocationPath() {
        return new LocationPathPattern(NodeTypeTest.DOCUMENT_TEST);
    }

    protected Pattern createRelativeLocationPath() {
        return new LocationPathPattern();
    }
}

