/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.saxpath.base;

import java.util.ArrayList;
import org.jaxen.saxpath.Axis;
import org.jaxen.saxpath.XPathHandler;
import org.jaxen.saxpath.XPathSyntaxException;
import org.jaxen.saxpath.base.Token;
import org.jaxen.saxpath.base.TokenTypes;
import org.jaxen.saxpath.base.XPathLexer;
import org.jaxen.saxpath.helpers.DefaultXPathHandler;

public class XPathReader
implements org.jaxen.saxpath.XPathReader {
    private ArrayList tokens;
    private XPathLexer lexer;
    private XPathHandler handler;
    private static XPathHandler defaultHandler = new DefaultXPathHandler();

    public XPathReader() {
        this.setXPathHandler(defaultHandler);
    }

    public void setXPathHandler(XPathHandler xPathHandler) {
        this.handler = xPathHandler;
    }

    public XPathHandler getXPathHandler() {
        return this.handler;
    }

    public void parse(String object) {
        this.setUpParse((String)object);
        this.getXPathHandler().startXPath();
        this.expr();
        this.getXPathHandler().endXPath();
        if (this.LA(1) != -1) {
            object = this.createSyntaxException("Unexpected '" + this.LT(1).getTokenText() + "'");
            throw object;
        }
        this.lexer = null;
        this.tokens = null;
    }

    void setUpParse(String string) {
        this.tokens = new ArrayList();
        this.lexer = new XPathLexer(string);
    }

    /*
     * Unable to fully structure code
     */
    private void pathExpr() {
        this.getXPathHandler().startPathExpr();
        switch (this.LA(1)) {
            case 26: 
            case 29: {
                this.filterExpr();
                if (this.LA(1) != 12 && this.LA(1) != 13) break;
                var1_1 = this.createSyntaxException("Node-set expected");
                throw var1_1;
            }
            case 23: 
            case 25: {
                this.filterExpr();
                if (this.LA(1) != 12 && this.LA(1) != 13) break;
                this.locationPath(false);
                break;
            }
            case 16: {
                if (this.LA(2) != 23) ** GOTO lbl17
                v0 = this;
                if (!v0.isNodeTypeName(v0.LT(1))) ** GOTO lbl18
lbl17:
                // 2 sources

                if (this.LA(2) != 19 || this.LA(4) != 23) ** GOTO lbl22
lbl18:
                // 2 sources

                this.filterExpr();
                if (this.LA(1) != 12 && this.LA(1) != 13) break;
                this.locationPath(false);
                break;
lbl22:
                // 1 sources

                this.locationPath(false);
                break;
            }
            case 9: 
            case 14: 
            case 15: 
            case 17: {
                this.locationPath(false);
                break;
            }
            case 12: 
            case 13: {
                this.locationPath(true);
                break;
            }
            default: {
                var1_2 = this.createSyntaxException("Unexpected '" + this.LT(1).getTokenText() + "'");
                throw var1_2;
            }
        }
        this.getXPathHandler().endPathExpr();
    }

    private void literal() {
        Token token = this.match(26);
        this.getXPathHandler().literal(token.getTokenText());
    }

    private void functionCall() {
        String string;
        if (this.LA(2) == 19) {
            string = this.match(16).getTokenText();
            this.match(19);
        } else {
            string = "";
        }
        String string2 = this.match(16).getTokenText();
        this.getXPathHandler().startFunction(string, string2);
        this.match(23);
        this.arguments();
        this.match(24);
        this.getXPathHandler().endFunction();
    }

    private void arguments() {
        while (this.LA(1) != 24) {
            this.expr();
            if (this.LA(1) != 30) break;
            this.match(30);
        }
    }

    private void filterExpr() {
        this.getXPathHandler().startFilterExpr();
        switch (this.LA(1)) {
            case 29: {
                Token token = this.match(29);
                this.getXPathHandler().number(Double.parseDouble(token.getTokenText()));
                break;
            }
            case 26: {
                this.literal();
                break;
            }
            case 23: {
                this.match(23);
                this.expr();
                this.match(24);
                break;
            }
            case 16: {
                this.functionCall();
                break;
            }
            case 25: {
                this.variableReference();
            }
        }
        this.predicates();
        this.getXPathHandler().endFilterExpr();
    }

    private void variableReference() {
        String string;
        this.match(25);
        if (this.LA(2) == 19) {
            string = this.match(16).getTokenText();
            this.match(19);
        } else {
            string = "";
        }
        String string2 = this.match(16).getTokenText();
        this.getXPathHandler().variableReference(string, string2);
    }

    void locationPath(boolean bl) {
        switch (this.LA(1)) {
            case 12: 
            case 13: {
                if (bl) {
                    this.absoluteLocationPath();
                    return;
                }
                this.relativeLocationPath();
                return;
            }
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                this.relativeLocationPath();
                return;
            }
        }
        XPathSyntaxException xPathSyntaxException = this.createSyntaxException("Unexpected '" + this.LT(1).getTokenText() + "'");
        throw xPathSyntaxException;
    }

    private void absoluteLocationPath() {
        this.getXPathHandler().startAbsoluteLocationPath();
        block0 : switch (this.LA(1)) {
            case 12: {
                this.match(12);
                switch (this.LA(1)) {
                    case 9: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: {
                        this.steps();
                    }
                }
                break;
            }
            case 13: {
                this.getXPathHandler().startAllNodeStep(12);
                this.getXPathHandler().endAllNodeStep();
                this.match(13);
                switch (this.LA(1)) {
                    case 9: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: {
                        this.steps();
                        break block0;
                    }
                }
                XPathSyntaxException xPathSyntaxException = this.createSyntaxException("Location path cannot end with //");
                throw xPathSyntaxException;
            }
        }
        this.getXPathHandler().endAbsoluteLocationPath();
    }

    private void relativeLocationPath() {
        this.getXPathHandler().startRelativeLocationPath();
        switch (this.LA(1)) {
            case 12: {
                this.match(12);
                break;
            }
            case 13: {
                this.getXPathHandler().startAllNodeStep(12);
                this.getXPathHandler().endAllNodeStep();
                this.match(13);
            }
        }
        this.steps();
        this.getXPathHandler().endRelativeLocationPath();
    }

    private void steps() {
        switch (this.LA(1)) {
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                this.step();
                break;
            }
            case -1: {
                return;
            }
            default: {
                XPathSyntaxException xPathSyntaxException = this.createSyntaxException("Expected one of '.', '..', '@', '*', <QName>");
                throw xPathSyntaxException;
            }
        }
        block11: while (true) {
            if (this.LA(1) == 12 || this.LA(1) == 13) {
                switch (this.LA(1)) {
                    case 12: {
                        this.match(12);
                        break;
                    }
                    case 13: {
                        this.getXPathHandler().startAllNodeStep(12);
                        this.getXPathHandler().endAllNodeStep();
                        this.match(13);
                    }
                }
            } else {
                return;
            }
            switch (this.LA(1)) {
                case 9: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    this.step();
                    continue block11;
                }
            }
            break;
        }
        XPathSyntaxException xPathSyntaxException = this.createSyntaxException("Expected one of '.', '..', '@', '*', <QName>");
        throw xPathSyntaxException;
    }

    void step() {
        int n2 = 0;
        switch (this.LA(1)) {
            case 14: 
            case 15: {
                this.abbrStep();
                return;
            }
            case 17: {
                n2 = this.axisSpecifier();
                break;
            }
            case 16: {
                if (this.LA(2) == 20) {
                    n2 = this.axisSpecifier();
                    break;
                }
                n2 = 1;
                break;
            }
            case 9: {
                n2 = 1;
            }
        }
        this.nodeTest(n2);
    }

    private int axisSpecifier() {
        int n2 = 0;
        switch (this.LA(1)) {
            case 17: {
                this.match(17);
                n2 = 9;
                break;
            }
            case 16: {
                Token token = this.LT(1);
                n2 = Axis.lookup(token.getTokenText());
                if (n2 == 0) {
                    this.throwInvalidAxis(token.getTokenText());
                }
                this.match(16);
                this.match(20);
            }
        }
        return n2;
    }

    private void nodeTest(int n2) {
        switch (this.LA(1)) {
            case 16: {
                switch (this.LA(2)) {
                    case 23: {
                        this.nodeTypeTest(n2);
                        return;
                    }
                }
                this.nameTest(n2);
                return;
            }
            case 9: {
                this.nameTest(n2);
                return;
            }
        }
        XPathSyntaxException xPathSyntaxException = this.createSyntaxException("Expected <QName> or *");
        throw xPathSyntaxException;
    }

    private void nodeTypeTest(int n2) {
        Object object = this.match(16);
        object = ((Token)object).getTokenText();
        this.match(23);
        if ("processing-instruction".equals(object)) {
            object = "";
            if (this.LA(1) == 26) {
                object = this.match(26).getTokenText();
            }
            this.match(24);
            this.getXPathHandler().startProcessingInstructionNodeStep(n2, (String)object);
            this.predicates();
            this.getXPathHandler().endProcessingInstructionNodeStep();
            return;
        }
        if ("node".equals(object)) {
            this.match(24);
            this.getXPathHandler().startAllNodeStep(n2);
            this.predicates();
            this.getXPathHandler().endAllNodeStep();
            return;
        }
        if ("text".equals(object)) {
            this.match(24);
            this.getXPathHandler().startTextNodeStep(n2);
            this.predicates();
            this.getXPathHandler().endTextNodeStep();
            return;
        }
        if ("comment".equals(object)) {
            this.match(24);
            this.getXPathHandler().startCommentNodeStep(n2);
            this.predicates();
            this.getXPathHandler().endCommentNodeStep();
            return;
        }
        object = this.createSyntaxException("Expected node-type");
        throw object;
    }

    private void nameTest(int n2) {
        String string = null;
        String string2 = null;
        switch (this.LA(2)) {
            case 19: {
                switch (this.LA(1)) {
                    case 16: {
                        string = this.match(16).getTokenText();
                        this.match(19);
                    }
                }
            }
        }
        switch (this.LA(1)) {
            case 16: {
                string2 = this.match(16).getTokenText();
                break;
            }
            case 9: {
                this.match(9);
                string2 = "*";
            }
        }
        if (string == null) {
            string = "";
        }
        this.getXPathHandler().startNameStep(n2, string, string2);
        this.predicates();
        this.getXPathHandler().endNameStep();
    }

    private void abbrStep() {
        switch (this.LA(1)) {
            case 14: {
                this.match(14);
                this.getXPathHandler().startAllNodeStep(11);
                this.predicates();
                this.getXPathHandler().endAllNodeStep();
                return;
            }
            case 15: {
                this.match(15);
                this.getXPathHandler().startAllNodeStep(3);
                this.predicates();
                this.getXPathHandler().endAllNodeStep();
            }
        }
    }

    private void predicates() {
        while (this.LA(1) == 21) {
            this.predicate();
        }
    }

    void predicate() {
        this.getXPathHandler().startPredicate();
        this.match(21);
        this.predicateExpr();
        this.match(22);
        this.getXPathHandler().endPredicate();
    }

    private void predicateExpr() {
        this.expr();
    }

    private void expr() {
        this.orExpr();
    }

    private void orExpr() {
        this.getXPathHandler().startOrExpr();
        this.andExpr();
        boolean bl = false;
        switch (this.LA(1)) {
            case 28: {
                bl = true;
                this.match(28);
                this.orExpr();
            }
        }
        this.getXPathHandler().endOrExpr(bl);
    }

    private void andExpr() {
        this.getXPathHandler().startAndExpr();
        this.equalityExpr();
        boolean bl = false;
        switch (this.LA(1)) {
            case 27: {
                bl = true;
                this.match(27);
                this.andExpr();
            }
        }
        this.getXPathHandler().endAndExpr(bl);
    }

    private void equalityExpr() {
        this.relationalExpr();
        int n2 = this.LA(1);
        while (n2 == 1 || n2 == 2) {
            switch (n2) {
                case 1: {
                    this.match(1);
                    this.getXPathHandler().startEqualityExpr();
                    this.relationalExpr();
                    this.getXPathHandler().endEqualityExpr(1);
                    break;
                }
                case 2: {
                    this.match(2);
                    this.getXPathHandler().startEqualityExpr();
                    this.relationalExpr();
                    this.getXPathHandler().endEqualityExpr(2);
                }
            }
            n2 = this.LA(1);
        }
    }

    private void relationalExpr() {
        this.additiveExpr();
        int n2 = this.LA(1);
        while (n2 == 3 || n2 == 5 || n2 == 4 || n2 == 6) {
            switch (n2) {
                case 3: {
                    this.match(3);
                    this.getXPathHandler().startRelationalExpr();
                    this.additiveExpr();
                    this.getXPathHandler().endRelationalExpr(3);
                    break;
                }
                case 5: {
                    this.match(5);
                    this.getXPathHandler().startRelationalExpr();
                    this.additiveExpr();
                    this.getXPathHandler().endRelationalExpr(5);
                    break;
                }
                case 6: {
                    this.match(6);
                    this.getXPathHandler().startRelationalExpr();
                    this.additiveExpr();
                    this.getXPathHandler().endRelationalExpr(6);
                    break;
                }
                case 4: {
                    this.match(4);
                    this.getXPathHandler().startRelationalExpr();
                    this.additiveExpr();
                    this.getXPathHandler().endRelationalExpr(4);
                }
            }
            n2 = this.LA(1);
        }
    }

    private void additiveExpr() {
        this.multiplicativeExpr();
        int n2 = this.LA(1);
        while (n2 == 7 || n2 == 8) {
            switch (n2) {
                case 7: {
                    this.match(7);
                    this.getXPathHandler().startAdditiveExpr();
                    this.multiplicativeExpr();
                    this.getXPathHandler().endAdditiveExpr(7);
                    break;
                }
                case 8: {
                    this.match(8);
                    this.getXPathHandler().startAdditiveExpr();
                    this.multiplicativeExpr();
                    this.getXPathHandler().endAdditiveExpr(8);
                }
            }
            n2 = this.LA(1);
        }
    }

    private void multiplicativeExpr() {
        this.unaryExpr();
        int n2 = this.LA(1);
        while (n2 == 31 || n2 == 11 || n2 == 10) {
            switch (n2) {
                case 9: 
                case 31: {
                    this.match(31);
                    this.getXPathHandler().startMultiplicativeExpr();
                    this.unaryExpr();
                    this.getXPathHandler().endMultiplicativeExpr(9);
                    break;
                }
                case 11: {
                    this.match(11);
                    this.getXPathHandler().startMultiplicativeExpr();
                    this.unaryExpr();
                    this.getXPathHandler().endMultiplicativeExpr(11);
                    break;
                }
                case 10: {
                    this.match(10);
                    this.getXPathHandler().startMultiplicativeExpr();
                    this.unaryExpr();
                    this.getXPathHandler().endMultiplicativeExpr(10);
                }
            }
            n2 = this.LA(1);
        }
    }

    private void unaryExpr() {
        switch (this.LA(1)) {
            case 8: {
                this.getXPathHandler().startUnaryExpr();
                this.match(8);
                this.unaryExpr();
                this.getXPathHandler().endUnaryExpr(12);
                return;
            }
        }
        this.unionExpr();
    }

    private void unionExpr() {
        this.getXPathHandler().startUnionExpr();
        this.pathExpr();
        boolean bl = false;
        switch (this.LA(1)) {
            case 18: {
                this.match(18);
                bl = true;
                this.expr();
            }
        }
        this.getXPathHandler().endUnionExpr(bl);
    }

    private Token match(int n2) {
        this.LT(1);
        Token token = (Token)this.tokens.get(0);
        if (token.getTokenType() == n2) {
            this.tokens.remove(0);
            return token;
        }
        XPathSyntaxException xPathSyntaxException = this.createSyntaxException("Expected: " + TokenTypes.getTokenText(n2));
        throw xPathSyntaxException;
    }

    private int LA(int n2) {
        return this.LT(n2).getTokenType();
    }

    private Token LT(int n2) {
        if (this.tokens.size() <= n2 - 1) {
            for (int i2 = 0; i2 < n2; ++i2) {
                this.tokens.add(this.lexer.nextToken());
            }
        }
        return (Token)this.tokens.get(n2 - 1);
    }

    private boolean isNodeTypeName(Token object) {
        return "node".equals(object = ((Token)object).getTokenText()) || "comment".equals(object) || "text".equals(object) || "processing-instruction".equals(object);
    }

    private XPathSyntaxException createSyntaxException(String string) {
        String string2 = this.lexer.getXPath();
        int n2 = this.LT(1).getTokenBegin();
        return new XPathSyntaxException(string2, n2, string);
    }

    private void throwInvalidAxis(String string) {
        String string2 = this.lexer.getXPath();
        int n2 = this.LT(1).getTokenBegin();
        string = "Expected valid axis name instead of [" + string + "]";
        throw new XPathSyntaxException(string2, n2, string);
    }
}

