/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.openal.AL$ICD;
import org.lwjgl.openal.AL$ICDStatic;
import org.lwjgl.openal.ALC;
import org.lwjgl.openal.ALCCapabilities;
import org.lwjgl.openal.ALCapabilities;
import org.lwjgl.openal.EXTThreadLocalContext;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.APIUtil$APIVersion;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public final class AL {
    @Nullable
    private static ALCapabilities processCaps;
    private static final ThreadLocal<ALCapabilities> capabilitiesTLS;
    private static AL$ICD icd;

    private AL() {
    }

    static void init() {
    }

    static void destroy() {
        AL.setCurrentProcess(null);
    }

    public static void setCurrentProcess(@Nullable ALCapabilities aLCapabilities) {
        processCaps = aLCapabilities;
        capabilitiesTLS.set(null);
        icd.set(aLCapabilities);
    }

    public static void setCurrentThread(@Nullable ALCapabilities aLCapabilities) {
        capabilitiesTLS.set(aLCapabilities);
        icd.set(aLCapabilities);
    }

    public static ALCapabilities getCapabilities() {
        ALCapabilities aLCapabilities = capabilitiesTLS.get();
        if (aLCapabilities == null) {
            aLCapabilities = processCaps;
        }
        return AL.checkCapabilities(aLCapabilities);
    }

    private static ALCapabilities checkCapabilities(@Nullable ALCapabilities aLCapabilities) {
        if (aLCapabilities == null) {
            throw new IllegalStateException("No ALCapabilities instance set for the current thread or process. Possible solutions:\n\ta) Call AL.createCapabilities() after making a context current.\n\tb) Call AL.setCurrentProcess() or AL.setCurrentThread() if an ALCapabilities instance already exists.");
        }
        return aLCapabilities;
    }

    public static ALCapabilities createCapabilities(ALCCapabilities aLCCapabilities) {
        return AL.createCapabilities(aLCCapabilities, null);
    }

    public static ALCapabilities createCapabilities(ALCCapabilities object, @Nullable IntFunction<PointerBuffer> intFunction) {
        Object object2;
        Object object3;
        long l2 = ALC.getFunctionProvider().getFunctionAddress(0L, "alGetProcAddress");
        if (l2 == 0L) {
            throw new RuntimeException("A core AL function is missing. Make sure that the OpenAL library has been loaded correctly.");
        }
        FunctionProvider functionProvider = byteBuffer -> {
            long l3 = JNI.invokePP(MemoryUtil.memAddress(byteBuffer), l2);
            if (l3 == 0L && Checks.DEBUG_FUNCTIONS) {
                APIUtil.apiLogMissing("AL", byteBuffer);
            }
            return l3;
        };
        long l3 = functionProvider.getFunctionAddress("alGetString");
        long l4 = functionProvider.getFunctionAddress("alGetError");
        long l5 = functionProvider.getFunctionAddress("alIsExtensionPresent");
        if (l3 == 0L || l4 == 0L || l5 == 0L) {
            throw new IllegalStateException("Core OpenAL functions could not be found. Make sure that the OpenAL library has been loaded correctly.");
        }
        Object object4 = MemoryUtil.memASCIISafe(JNI.invokeP(45058, l3));
        if (object4 == null || JNI.invokeI(l4) != 0) {
            throw new IllegalStateException("There is no OpenAL context current in the current thread or process.");
        }
        object4 = APIUtil.apiParseVersion((String)object4);
        int n2 = ((APIUtil$APIVersion)object4).major;
        int n3 = ((APIUtil$APIVersion)object4).minor;
        int[][] nArrayArray = new int[][]{{0, 1}};
        HashSet<String> hashSet = new HashSet<String>(32);
        for (int i2 = 1; i2 <= nArrayArray.length; ++i2) {
            object2 = object3 = nArrayArray[i2 - 1];
            int n4 = ((int[])object3).length;
            for (int i3 = 0; i3 < n4; ++i3) {
                Object object5 = object2[i3];
                if (i2 >= n2 && (i2 != n2 || object5 > n3)) continue;
                hashSet.add("OpenAL" + i2 + (int)object5);
            }
        }
        String string = MemoryUtil.memASCIISafe(JNI.invokeP(45060, l3));
        if (string != null) {
            object3 = MemoryStack.stackGet();
            object2 = new StringTokenizer(string);
            while (((StringTokenizer)object2).hasMoreTokens()) {
                String string2 = ((StringTokenizer)object2).nextToken();
                MemoryStack memoryStack = ((MemoryStack)object3).push();
                Throwable throwable = null;
                try {
                    if (JNI.invokePZ(MemoryUtil.memAddress(memoryStack.ASCII(string2, true)), l5)) {
                        hashSet.add(string2);
                    }
                    if (memoryStack == null) continue;
                    memoryStack.close();
                }
                catch (Throwable throwable2) {
                    try {
                        object = throwable2;
                        throwable = throwable2;
                        throw object;
                    }
                    catch (Throwable throwable3) {
                        if (memoryStack != null) {
                            if (throwable != null) {
                                try {
                                    memoryStack.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                            } else {
                                memoryStack.close();
                            }
                        }
                        throw throwable3;
                    }
                }
            }
        }
        if (((ALCCapabilities)object).ALC_EXT_EFX) {
            hashSet.add("ALC_EXT_EFX");
        }
        APIUtil.apiFilterExtensions(hashSet, Configuration.OPENAL_EXTENSION_FILTER);
        object3 = new ALCapabilities(functionProvider, hashSet, intFunction == null ? BufferUtils::createPointerBuffer : intFunction);
        if (((ALCCapabilities)object).ALC_EXT_thread_local_context && EXTThreadLocalContext.alcGetThreadContext() != 0L) {
            AL.setCurrentThread((ALCapabilities)object3);
        } else {
            AL.setCurrentProcess((ALCapabilities)object3);
        }
        return object3;
    }

    static ALCapabilities getICD() {
        return ALC.check(icd.get());
    }

    static /* synthetic */ AL$ICD access$102(AL$ICD aL$ICD) {
        icd = aL$ICD;
        return icd;
    }

    static {
        capabilitiesTLS = new ThreadLocal();
        icd = new AL$ICDStatic(null);
    }
}

