/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import java.io.Serializable;
import java.nio.IntBuffer;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.ALC$ICD;
import org.lwjgl.openal.ALC$ICDStatic;
import org.lwjgl.openal.ALC$SharedLibraryAL;
import org.lwjgl.openal.ALCCapabilities;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.FunctionProviderLocal;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Platform;
import org.lwjgl.system.SharedLibrary;

public final class ALC {
    @Nullable
    private static FunctionProviderLocal functionProvider;
    @Nullable
    private static ALCCapabilities router;
    private static final ThreadLocal<ALCCapabilities> capabilitiesTLS;
    @Nullable
    private static ALC$ICD icd;

    private ALC() {
    }

    public static void create() {
        String string;
        switch (Platform.get()) {
            case FREEBSD: 
            case LINUX: 
            case MACOSX: {
                string = "openal";
                break;
            }
            case WINDOWS: {
                string = "OpenAL";
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        ALC.create(Configuration.OPENAL_LIBRARY_NAME.get(Platform.mapLibraryNameBundled(string)));
    }

    public static void create(String object) {
        object = Library.loadNative(ALC.class, "org.lwjgl.openal", (String)object, true);
        try {
            ALC.create(new ALC$SharedLibraryAL((SharedLibrary)object));
            return;
        }
        catch (RuntimeException runtimeException) {
            object.free();
            throw runtimeException;
        }
    }

    public static void create(FunctionProviderLocal functionProviderLocal) {
        if (functionProvider != null) {
            throw new IllegalStateException("ALC has already been created.");
        }
        functionProvider = functionProviderLocal;
        router = ALC.createCapabilities(0L);
        AL.init();
    }

    public static void destroy() {
        if (functionProvider == null) {
            return;
        }
        AL.destroy();
        router = null;
        if (functionProvider instanceof NativeResource) {
            ((NativeResource)((Object)functionProvider)).free();
        }
        functionProvider = null;
    }

    static <T> T check(@Nullable T t2) {
        if (t2 == null) {
            throw new IllegalStateException("OpenAL library has not been loaded.");
        }
        return t2;
    }

    public static FunctionProviderLocal getFunctionProvider() {
        return ALC.check(functionProvider);
    }

    public static void setCapabilities(@Nullable ALCCapabilities aLCCapabilities) {
        capabilitiesTLS.set(aLCCapabilities);
        if (icd == null) {
            icd = new ALC$ICDStatic(null);
        }
        icd.set(aLCCapabilities);
    }

    public static ALCCapabilities getCapabilities() {
        ALCCapabilities aLCCapabilities = capabilitiesTLS.get();
        if (aLCCapabilities == null) {
            aLCCapabilities = router;
        }
        return ALC.checkCapabilities(aLCCapabilities);
    }

    private static ALCCapabilities checkCapabilities(@Nullable ALCCapabilities aLCCapabilities) {
        if (aLCCapabilities == null) {
            throw new IllegalStateException("No ALCCapabilities instance set");
        }
        return aLCCapabilities;
    }

    public static ALCCapabilities createCapabilities(long l2) {
        return ALC.createCapabilities(l2, null);
    }

    public static ALCCapabilities createCapabilities(long l2, @Nullable IntFunction<PointerBuffer> intFunction) {
        Object object;
        int n2;
        int n3;
        FunctionProviderLocal functionProviderLocal = ALC.getFunctionProvider();
        long l3 = functionProviderLocal.getFunctionAddress("alcGetIntegerv");
        long l4 = functionProviderLocal.getFunctionAddress("alcGetString");
        long l5 = functionProviderLocal.getFunctionAddress("alcIsExtensionPresent");
        if (l3 == 0L || l4 == 0L || l5 == 0L) {
            throw new IllegalStateException("Core ALC functions could not be found. Make sure that OpenAL has been loaded.");
        }
        Object object2 = MemoryStack.stackPush();
        Serializable serializable = null;
        try {
            IntBuffer intBuffer = ((MemoryStack)object2).mallocInt(1);
            JNI.invokePPV(l2, 4096, 1, MemoryUtil.memAddress(intBuffer), l3);
            n3 = intBuffer.get(0);
            JNI.invokePPV(l2, 4097, 1, MemoryUtil.memAddress(intBuffer), l3);
            n2 = intBuffer.get(0);
            if (object2 != null) {
                ((MemoryStack)object2).close();
            }
        }
        catch (Throwable throwable) {
            try {
                Throwable throwable2 = throwable;
                serializable = throwable;
                throw throwable2;
            }
            catch (Throwable throwable3) {
                if (object2 != null) {
                    if (serializable != null) {
                        try {
                            ((MemoryStack)object2).close();
                        }
                        catch (Throwable throwable4) {
                            ((Throwable)serializable).addSuppressed(throwable4);
                        }
                    } else {
                        ((MemoryStack)object2).close();
                    }
                }
                throw throwable3;
            }
        }
        object2 = new int[][]{{0, 1}};
        serializable = new HashSet(16);
        for (int i2 = 1; i2 <= ((Object)object2).length; ++i2) {
            Object object3;
            object = object3 = object2[i2 - 1];
            int n4 = ((Object)object3).length;
            for (int i3 = 0; i3 < n4; ++i3) {
                Object object4 = object[i3];
                if (i2 >= n3 && (i2 != n3 || object4 > n2)) continue;
                serializable.add("OpenALC" + i2 + (int)object4);
            }
        }
        String string = MemoryUtil.memASCIISafe(JNI.invokePP(l2, 4102, l4));
        if (string != null) {
            Object object5 = new StringTokenizer(string);
            while (((StringTokenizer)object5).hasMoreTokens()) {
                object = ((StringTokenizer)object5).nextToken();
                MemoryStack memoryStack = MemoryStack.stackPush();
                Throwable throwable = null;
                try {
                    if (JNI.invokePPZ(l2, MemoryUtil.memAddress(memoryStack.ASCII((CharSequence)object, true)), l5)) {
                        serializable.add(object);
                    }
                    if (memoryStack == null) continue;
                    memoryStack.close();
                }
                catch (Throwable throwable5) {
                    try {
                        object5 = throwable5;
                        throwable = throwable5;
                        throw object5;
                    }
                    catch (Throwable throwable6) {
                        if (memoryStack != null) {
                            if (throwable != null) {
                                try {
                                    memoryStack.close();
                                }
                                catch (Throwable throwable7) {
                                    throwable.addSuppressed(throwable7);
                                }
                            } else {
                                memoryStack.close();
                            }
                        }
                        throw throwable6;
                    }
                }
            }
        }
        APIUtil.apiFilterExtensions((Set<String>)((Object)serializable), Configuration.OPENAL_EXTENSION_FILTER);
        ALCCapabilities aLCCapabilities = new ALCCapabilities(functionProviderLocal, l2, (Set<String>)((Object)serializable), intFunction == null ? BufferUtils::createPointerBuffer : intFunction);
        if (l2 != 0L) {
            ALC.setCapabilities(aLCCapabilities);
        }
        return aLCCapabilities;
    }

    static ALCCapabilities getICD() {
        ALCCapabilities aLCCapabilities = icd == null ? null : icd.get();
        if (aLCCapabilities == null) {
            aLCCapabilities = router;
        }
        return ALC.check(aLCCapabilities);
    }

    static /* synthetic */ ALC$ICD access$102(ALC$ICD aLC$ICD) {
        icd = aLC$ICD;
        return icd;
    }

    static {
        capabilitiesTLS = new ThreadLocal();
        if (!Configuration.OPENAL_EXPLICIT_INIT.get(Boolean.FALSE).booleanValue()) {
            ALC.create();
        }
    }
}

