/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import org.lwjgl.PointerBuffer;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.SOFTCallbackBufferTypeI;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class SOFTCallbackBuffer {
    public static final int AL_BUFFER_CALLBACK_FUNCTION_SOFT = 6560;
    public static final int AL_BUFFER_CALLBACK_USER_PARAM_SOFT = 6561;

    protected SOFTCallbackBuffer() {
        throw new UnsupportedOperationException();
    }

    public static void nalBufferCallbackSOFT(int n2, int n3, int n4, long l2, long l3) {
        long l4 = AL.getICD().alBufferCallbackSOFT;
        if (Checks.CHECKS) {
            Checks.check(l4);
            Checks.check(l3);
        }
        JNI.invokePPV(n2, n3, n4, l2, l3, l4);
    }

    @NativeType(value="ALvoid")
    public static void alBufferCallbackSOFT(@NativeType(value="ALuint") int n2, @NativeType(value="ALenum") int n3, @NativeType(value="ALsizei") int n4, @NativeType(value="ALBUFFERCALLBACKTYPESOFT") SOFTCallbackBufferTypeI sOFTCallbackBufferTypeI, @NativeType(value="ALvoid *") long l2) {
        SOFTCallbackBuffer.nalBufferCallbackSOFT(n2, n3, n4, sOFTCallbackBufferTypeI.address(), l2);
    }

    public static void nalGetBufferPtrSOFT(int n2, int n3, long l2) {
        long l3 = AL.getICD().alGetBufferPtrSOFT;
        if (Checks.CHECKS) {
            Checks.check(l3);
        }
        JNI.invokePV(n2, n3, l2, l3);
    }

    @NativeType(value="ALvoid")
    public static void alGetBufferPtrSOFT(@NativeType(value="ALuint") int n2, @NativeType(value="ALenum") int n3, @NativeType(value="ALvoid **") PointerBuffer pointerBuffer) {
        if (Checks.CHECKS) {
            Checks.check(pointerBuffer, 1);
        }
        SOFTCallbackBuffer.nalGetBufferPtrSOFT(n2, n3, MemoryUtil.memAddress(pointerBuffer));
    }

    @NativeType(value="ALvoid")
    public static long alGetBufferPtrSOFT(@NativeType(value="ALuint") int n2, @NativeType(value="ALenum") int n3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n4 = memoryStack.getPointer();
        try {
            PointerBuffer pointerBuffer = memoryStack.callocPointer(1);
            SOFTCallbackBuffer.nalGetBufferPtrSOFT(n2, n3, MemoryUtil.memAddress(pointerBuffer));
            long l2 = pointerBuffer.get(0);
            return l2;
        }
        finally {
            memoryStack.setPointer(n4);
        }
    }

    public static void nalGetBuffer3PtrSOFT(int n2, int n3, long l2, long l3, long l4) {
        long l5 = AL.getICD().alGetBuffer3PtrSOFT;
        if (Checks.CHECKS) {
            Checks.check(l5);
        }
        JNI.invokePPPV(n2, n3, l2, l3, l4, l5);
    }

    @NativeType(value="ALvoid")
    public static void alGetBuffer3PtrSOFT(@NativeType(value="ALuint") int n2, @NativeType(value="ALenum") int n3, @NativeType(value="ALvoid **") PointerBuffer pointerBuffer, @NativeType(value="ALvoid **") PointerBuffer pointerBuffer2, @NativeType(value="ALvoid **") PointerBuffer pointerBuffer3) {
        if (Checks.CHECKS) {
            Checks.check(pointerBuffer, 1);
            Checks.check(pointerBuffer2, 1);
            Checks.check(pointerBuffer3, 1);
        }
        SOFTCallbackBuffer.nalGetBuffer3PtrSOFT(n2, n3, MemoryUtil.memAddress(pointerBuffer), MemoryUtil.memAddress(pointerBuffer2), MemoryUtil.memAddress(pointerBuffer3));
    }

    public static void nalGetBufferPtrvSOFT(int n2, int n3, long l2) {
        long l3 = AL.getICD().alGetBufferPtrvSOFT;
        if (Checks.CHECKS) {
            Checks.check(l3);
        }
        JNI.invokePV(n2, n3, l2, l3);
    }

    @NativeType(value="ALvoid")
    public static void alGetBufferPtrvSOFT(@NativeType(value="ALuint") int n2, @NativeType(value="ALenum") int n3, @NativeType(value="ALvoid **") PointerBuffer pointerBuffer) {
        if (Checks.CHECKS) {
            Checks.check(pointerBuffer, 1);
        }
        SOFTCallbackBuffer.nalGetBufferPtrvSOFT(n2, n3, MemoryUtil.memAddress(pointerBuffer));
    }
}

