/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.SOFTEventProcI;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class SOFTEvents {
    public static final int AL_EVENT_CALLBACK_FUNCTION_SOFT = 6562;
    public static final int AL_EVENT_CALLBACK_USER_PARAM_SOFT = 6563;
    public static final int AL_EVENT_TYPE_BUFFER_COMPLETED_SOFT = 6564;
    public static final int AL_EVENT_TYPE_SOURCE_STATE_CHANGED_SOFT = 6565;
    public static final int AL_EVENT_TYPE_DISCONNECTED_SOFT = 6566;

    protected SOFTEvents() {
        throw new UnsupportedOperationException();
    }

    public static void nalEventControlSOFT(int n2, long l2, boolean bl) {
        long l3 = AL.getICD().alEventControlSOFT;
        if (Checks.CHECKS) {
            Checks.check(l3);
        }
        JNI.invokePV(n2, l2, bl, l3);
    }

    public static void alEventControlSOFT(@NativeType(value="ALenum const *") IntBuffer intBuffer, @NativeType(value="ALboolean") boolean bl) {
        SOFTEvents.nalEventControlSOFT(intBuffer.remaining(), MemoryUtil.memAddress(intBuffer), bl);
    }

    public static void nalEventCallbackSOFT(long l2, long l3) {
        long l4 = AL.getICD().alEventCallbackSOFT;
        if (Checks.CHECKS) {
            Checks.check(l4);
        }
        JNI.invokePPV(l2, l3, l4);
    }

    public static void alEventCallbackSOFT(@NativeType(value="ALEVENTPROCSOFT") SOFTEventProcI sOFTEventProcI, @Nullable @NativeType(value="ALvoid *") ByteBuffer byteBuffer) {
        SOFTEvents.nalEventCallbackSOFT(sOFTEventProcI.address(), MemoryUtil.memAddressSafe(byteBuffer));
    }

    @NativeType(value="ALvoid *")
    public static long alGetPointerSOFT(@NativeType(value="ALenum") int n2) {
        long l2 = AL.getICD().alGetPointerSOFT;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokeP(n2, l2);
    }

    public static void nalGetPointervSOFT(int n2, long l2) {
        long l3 = AL.getICD().alGetPointervSOFT;
        if (Checks.CHECKS) {
            Checks.check(l3);
        }
        JNI.invokePV(n2, l2, l3);
    }

    public static void alGetPointervSOFT(@NativeType(value="ALenum") int n2, @NativeType(value="ALvoid **") PointerBuffer pointerBuffer) {
        if (Checks.CHECKS) {
            Checks.check(pointerBuffer, 1);
        }
        SOFTEvents.nalGetPointervSOFT(n2, MemoryUtil.memAddress(pointerBuffer));
    }

    public static void alEventControlSOFT(@NativeType(value="ALenum const *") int[] nArray, @NativeType(value="ALboolean") boolean bl) {
        long l2 = AL.getICD().alEventControlSOFT;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.invokePV(nArray.length, nArray, bl, l2);
    }
}

