/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.openal.ALC;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class SOFTReopenDevice {
    protected SOFTReopenDevice() {
        throw new UnsupportedOperationException();
    }

    public static boolean nalcReopenDeviceSOFT(long l2, long l3, long l4) {
        long l5 = ALC.getICD().alcReopenDeviceSOFT;
        if (Checks.CHECKS) {
            Checks.check(l5);
            Checks.check(l2);
        }
        return JNI.invokePPPZ(l2, l3, l4, l5);
    }

    @NativeType(value="ALCboolean")
    public static boolean alcReopenDeviceSOFT(@NativeType(value="ALCdevice *") long l2, @Nullable @NativeType(value="ALCchar const *") ByteBuffer byteBuffer, @Nullable @NativeType(value="ALCint const *") IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1Safe(byteBuffer);
            Checks.checkNTSafe(intBuffer);
        }
        return SOFTReopenDevice.nalcReopenDeviceSOFT(l2, MemoryUtil.memAddressSafe(byteBuffer), MemoryUtil.memAddressSafe(intBuffer));
    }

    @NativeType(value="ALCboolean")
    public static boolean alcReopenDeviceSOFT(@NativeType(value="ALCdevice *") long l2, @Nullable @NativeType(value="ALCchar const *") CharSequence charSequence, @Nullable @NativeType(value="ALCint const *") IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNTSafe(intBuffer);
        }
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8Safe(charSequence, true);
            long l3 = charSequence == null ? 0L : memoryStack.getPointerAddress();
            boolean bl = SOFTReopenDevice.nalcReopenDeviceSOFT(l2, l3, MemoryUtil.memAddressSafe(intBuffer));
            return bl;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    @NativeType(value="ALCboolean")
    public static boolean alcReopenDeviceSOFT(@NativeType(value="ALCdevice *") long l2, @Nullable @NativeType(value="ALCchar const *") ByteBuffer byteBuffer, @Nullable @NativeType(value="ALCint const *") int[] nArray) {
        long l3 = ALC.getICD().alcReopenDeviceSOFT;
        if (Checks.CHECKS) {
            Checks.check(l3);
            Checks.check(l2);
            Checks.checkNT1Safe(byteBuffer);
            Checks.checkNTSafe(nArray);
        }
        return JNI.invokePPPZ(l2, MemoryUtil.memAddressSafe(byteBuffer), nArray, l3);
    }

    @NativeType(value="ALCboolean")
    public static boolean alcReopenDeviceSOFT(@NativeType(value="ALCdevice *") long l2, @Nullable @NativeType(value="ALCchar const *") CharSequence charSequence, @Nullable @NativeType(value="ALCint const *") int[] nArray) {
        long l3 = ALC.getICD().alcReopenDeviceSOFT;
        if (Checks.CHECKS) {
            Checks.check(l3);
            Checks.check(l2);
            Checks.checkNTSafe(nArray);
        }
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8Safe(charSequence, true);
            long l4 = charSequence == null ? 0L : memoryStack.getPointerAddress();
            boolean bl = JNI.invokePPPZ(l2, l4, nArray, l3);
            return bl;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }
}

