/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.io.PrintStream;
import javax.annotation.Nullable;
import org.lwjgl.opengl.AMDDebugOutput;
import org.lwjgl.opengl.ARBDebugOutput;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL43C;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLDebugMessageAMDCallback;
import org.lwjgl.opengl.GLDebugMessageAMDCallbackI;
import org.lwjgl.opengl.GLDebugMessageARBCallback;
import org.lwjgl.opengl.GLDebugMessageARBCallbackI;
import org.lwjgl.opengl.GLDebugMessageCallback;
import org.lwjgl.opengl.GLDebugMessageCallbackI;
import org.lwjgl.opengl.KHRDebug;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Callback;

public final class GLUtil {
    private GLUtil() {
    }

    @Nullable
    public static Callback setupDebugMessageCallback() {
        return GLUtil.setupDebugMessageCallback(APIUtil.DEBUG_STREAM);
    }

    @Nullable
    public static Callback setupDebugMessageCallback(PrintStream autoCloseable) {
        GLCapabilities gLCapabilities = GL.getCapabilities();
        if (gLCapabilities.OpenGL43) {
            APIUtil.apiLog("[GL] Using OpenGL 4.3 for error logging.");
            autoCloseable = GLDebugMessageCallback.create((arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> GLUtil.lambda$setupDebugMessageCallback$0((PrintStream)autoCloseable, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6));
            GL43C.glDebugMessageCallback((GLDebugMessageCallbackI)((Object)autoCloseable), 0L);
            if ((GL43C.glGetInteger(33310) & 2) == 0) {
                APIUtil.apiLog("[GL] Warning: A non-debug context may not produce any debug output.");
                GL43C.glEnable(37600);
            }
            return autoCloseable;
        }
        if (gLCapabilities.GL_KHR_debug) {
            APIUtil.apiLog("[GL] Using KHR_debug for error logging.");
            autoCloseable = GLDebugMessageCallback.create((arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> GLUtil.lambda$setupDebugMessageCallback$1((PrintStream)autoCloseable, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6));
            KHRDebug.glDebugMessageCallback((GLDebugMessageCallbackI)((Object)autoCloseable), 0L);
            if (gLCapabilities.OpenGL30 && (GL43C.glGetInteger(33310) & 2) == 0) {
                APIUtil.apiLog("[GL] Warning: A non-debug context may not produce any debug output.");
                GL43C.glEnable(37600);
            }
            return autoCloseable;
        }
        if (gLCapabilities.GL_ARB_debug_output) {
            APIUtil.apiLog("[GL] Using ARB_debug_output for error logging.");
            autoCloseable = GLDebugMessageARBCallback.create((arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> GLUtil.lambda$setupDebugMessageCallback$2((PrintStream)autoCloseable, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6));
            ARBDebugOutput.glDebugMessageCallbackARB((GLDebugMessageARBCallbackI)((Object)autoCloseable), 0L);
            return autoCloseable;
        }
        if (gLCapabilities.GL_AMD_debug_output) {
            APIUtil.apiLog("[GL] Using AMD_debug_output for error logging.");
            autoCloseable = GLDebugMessageAMDCallback.create((arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> GLUtil.lambda$setupDebugMessageCallback$3((PrintStream)autoCloseable, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5));
            AMDDebugOutput.glDebugMessageCallbackAMD((GLDebugMessageAMDCallbackI)((Object)autoCloseable), 0L);
            return autoCloseable;
        }
        APIUtil.apiLog("[GL] No debug output implementation is available.");
        return null;
    }

    private static void printDetail(StringBuilder stringBuilder, String string, String string2) {
        stringBuilder.append("\t").append(string).append(": ").append(string2).append("\n");
    }

    private static String getDebugSource(int n2) {
        switch (n2) {
            case 33350: {
                return "API";
            }
            case 33351: {
                return "WINDOW SYSTEM";
            }
            case 33352: {
                return "SHADER COMPILER";
            }
            case 33353: {
                return "THIRD PARTY";
            }
            case 33354: {
                return "APPLICATION";
            }
            case 33355: {
                return "OTHER";
            }
        }
        return APIUtil.apiUnknownToken(n2);
    }

    private static String getDebugType(int n2) {
        switch (n2) {
            case 33356: {
                return "ERROR";
            }
            case 33357: {
                return "DEPRECATED BEHAVIOR";
            }
            case 33358: {
                return "UNDEFINED BEHAVIOR";
            }
            case 33359: {
                return "PORTABILITY";
            }
            case 33360: {
                return "PERFORMANCE";
            }
            case 33361: {
                return "OTHER";
            }
            case 33384: {
                return "MARKER";
            }
        }
        return APIUtil.apiUnknownToken(n2);
    }

    private static String getDebugSeverity(int n2) {
        switch (n2) {
            case 37190: {
                return "HIGH";
            }
            case 37191: {
                return "MEDIUM";
            }
            case 37192: {
                return "LOW";
            }
            case 33387: {
                return "NOTIFICATION";
            }
        }
        return APIUtil.apiUnknownToken(n2);
    }

    private static String getSourceARB(int n2) {
        switch (n2) {
            case 33350: {
                return "API";
            }
            case 33351: {
                return "WINDOW SYSTEM";
            }
            case 33352: {
                return "SHADER COMPILER";
            }
            case 33353: {
                return "THIRD PARTY";
            }
            case 33354: {
                return "APPLICATION";
            }
            case 33355: {
                return "OTHER";
            }
        }
        return APIUtil.apiUnknownToken(n2);
    }

    private static String getTypeARB(int n2) {
        switch (n2) {
            case 33356: {
                return "ERROR";
            }
            case 33357: {
                return "DEPRECATED BEHAVIOR";
            }
            case 33358: {
                return "UNDEFINED BEHAVIOR";
            }
            case 33359: {
                return "PORTABILITY";
            }
            case 33360: {
                return "PERFORMANCE";
            }
            case 33361: {
                return "OTHER";
            }
        }
        return APIUtil.apiUnknownToken(n2);
    }

    private static String getSeverityARB(int n2) {
        switch (n2) {
            case 37190: {
                return "HIGH";
            }
            case 37191: {
                return "MEDIUM";
            }
            case 37192: {
                return "LOW";
            }
        }
        return APIUtil.apiUnknownToken(n2);
    }

    private static String getCategoryAMD(int n2) {
        switch (n2) {
            case 37193: {
                return "API ERROR";
            }
            case 37194: {
                return "WINDOW SYSTEM";
            }
            case 37195: {
                return "DEPRECATION";
            }
            case 37196: {
                return "UNDEFINED BEHAVIOR";
            }
            case 37197: {
                return "PERFORMANCE";
            }
            case 37198: {
                return "SHADER COMPILER";
            }
            case 37199: {
                return "APPLICATION";
            }
            case 37200: {
                return "OTHER";
            }
        }
        return APIUtil.apiUnknownToken(n2);
    }

    private static String getSeverityAMD(int n2) {
        switch (n2) {
            case 37190: {
                return "HIGH";
            }
            case 37191: {
                return "MEDIUM";
            }
            case 37192: {
                return "LOW";
            }
        }
        return APIUtil.apiUnknownToken(n2);
    }

    private static /* synthetic */ void lambda$setupDebugMessageCallback$3(PrintStream printStream, int n2, int n3, int n4, int n5, long l2, long l3) {
        StringBuilder stringBuilder = new StringBuilder(300);
        stringBuilder.append("[LWJGL] AMD_debug_output message\n");
        GLUtil.printDetail(stringBuilder, "ID", "0x" + Integer.toHexString(n2).toUpperCase());
        GLUtil.printDetail(stringBuilder, "Category", GLUtil.getCategoryAMD(n3));
        GLUtil.printDetail(stringBuilder, "Severity", GLUtil.getSeverityAMD(n4));
        GLUtil.printDetail(stringBuilder, "Message", GLDebugMessageAMDCallback.getMessage(n5, l2));
        printStream.print(stringBuilder);
    }

    private static /* synthetic */ void lambda$setupDebugMessageCallback$2(PrintStream printStream, int n2, int n3, int n4, int n5, int n6, long l2, long l3) {
        StringBuilder stringBuilder = new StringBuilder(300);
        stringBuilder.append("[LWJGL] ARB_debug_output message\n");
        GLUtil.printDetail(stringBuilder, "ID", "0x" + Integer.toHexString(n4).toUpperCase());
        GLUtil.printDetail(stringBuilder, "Source", GLUtil.getSourceARB(n2));
        GLUtil.printDetail(stringBuilder, "Type", GLUtil.getTypeARB(n3));
        GLUtil.printDetail(stringBuilder, "Severity", GLUtil.getSeverityARB(n5));
        GLUtil.printDetail(stringBuilder, "Message", GLDebugMessageARBCallback.getMessage(n6, l2));
        printStream.print(stringBuilder);
    }

    private static /* synthetic */ void lambda$setupDebugMessageCallback$1(PrintStream printStream, int n2, int n3, int n4, int n5, int n6, long l2, long l3) {
        StringBuilder stringBuilder = new StringBuilder(300);
        stringBuilder.append("[LWJGL] OpenGL debug message\n");
        GLUtil.printDetail(stringBuilder, "ID", "0x" + Integer.toHexString(n4).toUpperCase());
        GLUtil.printDetail(stringBuilder, "Source", GLUtil.getDebugSource(n2));
        GLUtil.printDetail(stringBuilder, "Type", GLUtil.getDebugType(n3));
        GLUtil.printDetail(stringBuilder, "Severity", GLUtil.getDebugSeverity(n5));
        GLUtil.printDetail(stringBuilder, "Message", GLDebugMessageCallback.getMessage(n6, l2));
        printStream.print(stringBuilder);
    }

    private static /* synthetic */ void lambda$setupDebugMessageCallback$0(PrintStream printStream, int n2, int n3, int n4, int n5, int n6, long l2, long l3) {
        StringBuilder stringBuilder = new StringBuilder(300);
        stringBuilder.append("[LWJGL] OpenGL debug message\n");
        GLUtil.printDetail(stringBuilder, "ID", "0x" + Integer.toHexString(n4).toUpperCase());
        GLUtil.printDetail(stringBuilder, "Source", GLUtil.getDebugSource(n2));
        GLUtil.printDetail(stringBuilder, "Type", GLUtil.getDebugType(n3));
        GLUtil.printDetail(stringBuilder, "Severity", GLUtil.getDebugSeverity(n5));
        GLUtil.printDetail(stringBuilder, "Message", GLDebugMessageCallback.getMessage(n6, l2));
        printStream.print(stringBuilder);
    }
}

