/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.APIUtil$APIVersion;
import org.lwjgl.system.APIUtil$Encoder;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.MemoryUtil$MemoryAllocator;
import org.lwjgl.system.Platform;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.SharedLibrary;
import org.lwjgl.system.freebsd.FreeBSDLibrary;
import org.lwjgl.system.libffi.FFICIF;
import org.lwjgl.system.libffi.FFIType;
import org.lwjgl.system.libffi.LibFFI;
import org.lwjgl.system.linux.LinuxLibrary;
import org.lwjgl.system.macosx.MacOSXLibrary;
import org.lwjgl.system.windows.WindowsLibrary;

public final class APIUtil {
    public static final PrintStream DEBUG_STREAM = APIUtil.getDebugStream();
    private static final Pattern API_VERSION_PATTERN;

    private static PrintStream getDebugStream() {
        PrintStream printStream = System.err;
        Object object = Configuration.DEBUG_STREAM.get();
        if (object instanceof String) {
            try {
                object = (Supplier)Class.forName((String)object).getConstructor(new Class[0]).newInstance(new Object[0]);
                printStream = (PrintStream)object.get();
            }
            catch (Exception exception) {
                object = exception;
                exception.printStackTrace();
            }
        } else if (object instanceof Supplier) {
            printStream = (PrintStream)((Supplier)object).get();
        } else if (object instanceof PrintStream) {
            printStream = (PrintStream)object;
        }
        return printStream;
    }

    private APIUtil() {
    }

    public static void apiLog(CharSequence charSequence) {
        if (Checks.DEBUG) {
            DEBUG_STREAM.print("[LWJGL] " + charSequence + "\n");
        }
    }

    public static void apiLogMore(CharSequence charSequence) {
        if (Checks.DEBUG) {
            DEBUG_STREAM.print("\t" + charSequence + "\n");
        }
    }

    public static void apiLogMissing(String string, ByteBuffer object) {
        if (Checks.DEBUG) {
            ByteBuffer byteBuffer = object;
            object = MemoryUtil.memASCII(byteBuffer, byteBuffer.remaining() - 1);
            DEBUG_STREAM.print("[LWJGL] Failed to locate address for " + string + " function " + (String)object + "\n");
        }
    }

    public static String apiFindLibrary(String object, String string) {
        String string2;
        block12: {
            Object object2 = Platform.get().mapLibraryName(string);
            object = Files.find(Paths.get((String)object, new String[0]).toAbsolutePath(), Integer.MAX_VALUE, (arg_0, arg_1) -> APIUtil.lambda$apiFindLibrary$0((String)object2, arg_0, arg_1), new FileVisitOption[0]);
            object2 = null;
            try {
                string2 = object.findFirst().map(Path::toString).orElse(string);
                if (object == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        Throwable throwable2 = throwable;
                        object2 = throwable;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (object != null) {
                            if (object2 != null) {
                                try {
                                    object.close();
                                }
                                catch (Throwable throwable4) {
                                    ((Throwable)object2).addSuppressed(throwable4);
                                }
                            } else {
                                object.close();
                            }
                        }
                        throw throwable3;
                    }
                }
                catch (IOException iOException) {
                    return string;
                }
            }
            object.close();
        }
        return string2;
    }

    public static SharedLibrary apiCreateLibrary(String string) {
        switch (Platform.get()) {
            case FREEBSD: {
                return new FreeBSDLibrary(string);
            }
            case LINUX: {
                return new LinuxLibrary(string);
            }
            case MACOSX: {
                return MacOSXLibrary.create(string);
            }
            case WINDOWS: {
                return new WindowsLibrary(string);
            }
        }
        throw new IllegalStateException();
    }

    public static long apiGetFunctionAddress(FunctionProvider functionProvider, String string) {
        long l2 = functionProvider.getFunctionAddress(string);
        if (l2 == 0L) {
            APIUtil.requiredFunctionMissing(string);
        }
        return l2;
    }

    private static void requiredFunctionMissing(String string) {
        if (!Configuration.DISABLE_FUNCTION_CHECKS.get(Boolean.FALSE).booleanValue()) {
            throw new NullPointerException("A required function is missing: " + string);
        }
    }

    public static long apiGetFunctionAddressOptional(SharedLibrary sharedLibrary, String string) {
        long l2 = sharedLibrary.getFunctionAddress(string);
        if (Checks.DEBUG_FUNCTIONS && l2 == 0L) {
            APIUtil.optionalFunctionMissing(sharedLibrary, string);
        }
        return l2;
    }

    private static void optionalFunctionMissing(SharedLibrary sharedLibrary, String string) {
        if (Checks.DEBUG) {
            DEBUG_STREAM.print("[LWJGL] Failed to locate address for " + sharedLibrary.getName() + " function " + string + "\n");
        }
    }

    @Nullable
    public static ByteBuffer apiGetMappedBuffer(@Nullable ByteBuffer byteBuffer, long l2, int n2) {
        if (byteBuffer != null && MemoryUtil.memAddress(byteBuffer) == l2 && byteBuffer.capacity() == n2) {
            return byteBuffer;
        }
        if (l2 == 0L) {
            return null;
        }
        return MemoryUtil.wrap(MemoryUtil.BUFFER_BYTE, l2, n2).order(MemoryUtil.NATIVE_ORDER);
    }

    public static long apiGetBytes(int n2, int n3) {
        return ((long)n2 & 0xFFFFFFFFL) << n3;
    }

    public static long apiCheckAllocation(int n2, long l2, long l3) {
        if (Checks.DEBUG) {
            if (n2 < 0) {
                throw new IllegalArgumentException("Invalid number of elements");
            }
            if (l3 + Long.MIN_VALUE < l2 + Long.MIN_VALUE) {
                throw new IllegalArgumentException("The request allocation is too large");
            }
        }
        return l2;
    }

    @Nullable
    public static APIUtil$APIVersion apiParseVersion(Configuration<?> object) {
        object = (object = ((Configuration)object).get()) instanceof String ? APIUtil.apiParseVersion((String)object) : (object instanceof APIUtil$APIVersion ? (APIUtil$APIVersion)object : null);
        return object;
    }

    public static APIUtil$APIVersion apiParseVersion(String string) {
        Matcher matcher = API_VERSION_PATTERN.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("Malformed API version string [%s]", string));
        }
        return new APIUtil$APIVersion(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), matcher.group(3), matcher.group(4));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void apiFilterExtensions(Set<String> set, Configuration<Object> object) {
        Object t2 = ((Configuration)object).get();
        if (t2 == null) {
            return;
        }
        if (t2 instanceof String) {
            String string = (String)t2;
            if (string.indexOf(46) != -1) {
                try {
                    Predicate predicate = (Predicate)Class.forName(string).newInstance();
                    set.removeIf(predicate);
                    return;
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
            String[] stringArray = string.split(",");
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String string2 = stringArray[n3];
                set.remove(string2);
                ++n3;
            }
            return;
        }
        if (t2 instanceof List) {
            List list = (List)t2;
            set.removeAll(list);
            return;
        }
        if (!(t2 instanceof Predicate)) throw new IllegalStateException("Unsupported " + ((Configuration)object).getProperty() + " value specified.");
        Predicate predicate = (Predicate)t2;
        set.removeIf(predicate);
    }

    public static String apiUnknownToken(int n2) {
        return APIUtil.apiUnknownToken("Unknown", n2);
    }

    public static String apiUnknownToken(String string, int n2) {
        return String.format("%s [0x%X]", string, n2);
    }

    public static Map<Integer, String> apiClassTokens(@Nullable BiPredicate<Field, Integer> biPredicate, @Nullable Map<Integer, String> map, Class<?> ... classArray) {
        if (map == null) {
            map = new HashMap<Integer, String>(64);
        }
        for (Class<?> clazz : classArray) {
            if (clazz == null) continue;
            for (Field field : clazz.getDeclaredFields()) {
                if ((field.getModifiers() & 0x19) != 25 || field.getType() != Integer.TYPE) continue;
                try {
                    Integer n2 = field.getInt(null);
                    if (biPredicate != null && !biPredicate.test(field, n2)) continue;
                    String string = map.get(n2);
                    map.put(n2, string == null ? field.getName() : string + "|" + field.getName());
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
        }
        return map;
    }

    public static long apiArray(MemoryStack pointer$Default, long ... lArray) {
        pointer$Default = MemoryUtil.memPointerBuffer(((MemoryStack)pointer$Default).nmalloc(MemoryStack.POINTER_SIZE, lArray.length << MemoryStack.POINTER_SHIFT), lArray.length);
        for (long l2 : lArray) {
            ((PointerBuffer)pointer$Default).put(l2);
        }
        return pointer$Default.address;
    }

    public static long apiArray(MemoryStack pointer$Default, ByteBuffer ... byteBufferArray) {
        pointer$Default = MemoryUtil.memPointerBuffer(((MemoryStack)pointer$Default).nmalloc(MemoryStack.POINTER_SIZE, byteBufferArray.length << MemoryStack.POINTER_SHIFT), byteBufferArray.length);
        for (ByteBuffer byteBuffer : byteBufferArray) {
            ((PointerBuffer)pointer$Default).put(byteBuffer);
        }
        return pointer$Default.address;
    }

    public static long apiArrayp(MemoryStack pointer$Default, ByteBuffer ... byteBufferArray) {
        long l2 = APIUtil.apiArray((MemoryStack)pointer$Default, byteBufferArray);
        pointer$Default = ((MemoryStack)pointer$Default).mallocPointer(byteBufferArray.length);
        for (ByteBuffer byteBuffer : byteBufferArray) {
            ((PointerBuffer)pointer$Default).put(byteBuffer.remaining());
        }
        return l2;
    }

    public static long apiArray(MemoryStack pointer$Default, APIUtil$Encoder aPIUtil$Encoder, CharSequence ... charSequenceArray) {
        pointer$Default = ((MemoryStack)pointer$Default).mallocPointer(charSequenceArray.length);
        for (CharSequence charSequence : charSequenceArray) {
            ((PointerBuffer)pointer$Default).put(aPIUtil$Encoder.encode(charSequence, true));
        }
        return pointer$Default.address;
    }

    public static long apiArrayi(MemoryStack object, APIUtil$Encoder aPIUtil$Encoder, CharSequence ... charSequenceArray) {
        PointerBuffer pointerBuffer = ((MemoryStack)object).mallocPointer(charSequenceArray.length);
        object = ((MemoryStack)object).mallocInt(charSequenceArray.length);
        for (CharSequence charSequence : charSequenceArray) {
            ByteBuffer object2 = aPIUtil$Encoder.encode(charSequence, false);
            pointerBuffer.put(object2);
            ((IntBuffer)object).put(object2.capacity());
        }
        return pointerBuffer.address;
    }

    public static long apiArrayp(MemoryStack pointer$Default, APIUtil$Encoder aPIUtil$Encoder, CharSequence ... charSequenceArray) {
        PointerBuffer pointerBuffer = ((MemoryStack)pointer$Default).mallocPointer(charSequenceArray.length);
        pointer$Default = ((MemoryStack)pointer$Default).mallocPointer(charSequenceArray.length);
        for (CharSequence charSequence : charSequenceArray) {
            ByteBuffer object = aPIUtil$Encoder.encode(charSequence, false);
            pointerBuffer.put(object);
            ((PointerBuffer)pointer$Default).put(object.capacity());
        }
        return pointerBuffer.address;
    }

    public static void apiArrayFree(long l2, int n2) {
        while (--n2 >= 0) {
            MemoryUtil.nmemFree(MemoryUtil.memGetAddress(l2 + Integer.toUnsignedLong(n2) * (long)MemoryStack.POINTER_SIZE));
        }
    }

    public static FFIType apiCreateStruct(FFIType ... fFITypeArray) {
        MemoryUtil$MemoryAllocator memoryUtil$MemoryAllocator = MemoryUtil.getAllocator();
        PointerBuffer pointerBuffer = PointerBuffer.create(memoryUtil$MemoryAllocator.malloc((fFITypeArray.length + 1) * MemoryStack.POINTER_SIZE), fFITypeArray.length + 1);
        for (int i2 = 0; i2 < fFITypeArray.length; ++i2) {
            pointerBuffer.put(i2, fFITypeArray[i2]);
        }
        pointerBuffer.put(fFITypeArray.length, 0L);
        return FFIType.create(memoryUtil$MemoryAllocator.calloc(1L, FFIType.SIZEOF)).type((short)13).elements(pointerBuffer);
    }

    private static FFIType prep(FFIType fFIType) {
        MemoryStack memoryStack = MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            FFICIF fFICIF = FFICIF.calloc(memoryStack);
            if (LibFFI.ffi_prep_cif(fFICIF, LibFFI.FFI_DEFAULT_ABI, fFIType, null) != 0) {
                throw new IllegalStateException("Failed to prepare LibFFI type.");
            }
            if (memoryStack != null) {
                memoryStack.close();
            }
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (memoryStack != null) {
                    if (throwable != null) {
                        try {
                            memoryStack.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        memoryStack.close();
                    }
                }
                throw throwable4;
            }
        }
        return fFIType;
    }

    public static FFIType apiCreateUnion(FFIType ... fFITypeArray) {
        MemoryUtil$MemoryAllocator memoryUtil$MemoryAllocator = MemoryUtil.getAllocator();
        FFIType fFIType = APIUtil.prep(fFITypeArray[0]);
        short s2 = fFITypeArray[0].alignment();
        for (int i2 = 1; i2 < fFITypeArray.length; ++i2) {
            FFIType fFIType2 = APIUtil.prep(fFITypeArray[i2]);
            if (fFIType.size() < fFIType2.size()) {
                fFIType = fFIType2;
            }
            if (s2 >= fFIType2.alignment()) continue;
            s2 = fFIType2.alignment();
        }
        return FFIType.create(memoryUtil$MemoryAllocator.malloc(FFIType.SIZEOF)).size(fFIType.size()).alignment(s2).type((short)13).elements(PointerBuffer.create(memoryUtil$MemoryAllocator.malloc(2 * MemoryStack.POINTER_SIZE), 2).put(0, fFIType).put(1, 0L));
    }

    public static FFIType apiCreateArray(FFIType fFIType, int n2) {
        MemoryUtil$MemoryAllocator memoryUtil$MemoryAllocator = MemoryUtil.getAllocator();
        PointerBuffer pointerBuffer = PointerBuffer.create(memoryUtil$MemoryAllocator.malloc((n2 + 1) * MemoryStack.POINTER_SIZE), n2 + 1);
        for (int i2 = 0; i2 < n2; ++i2) {
            pointerBuffer.put(i2, fFIType);
        }
        pointerBuffer.put(n2, 0L);
        return FFIType.create(memoryUtil$MemoryAllocator.calloc(1L, FFIType.SIZEOF)).type((short)13).elements(pointerBuffer);
    }

    public static FFICIF apiCreateCIF(int n2, FFIType fFIType, FFIType ... fFITypeArray) {
        MemoryUtil$MemoryAllocator memoryUtil$MemoryAllocator = MemoryUtil.getAllocator();
        PointerBuffer pointerBuffer = PointerBuffer.create(memoryUtil$MemoryAllocator.malloc(fFITypeArray.length * MemoryStack.POINTER_SIZE), fFITypeArray.length);
        for (int i2 = 0; i2 < fFITypeArray.length; ++i2) {
            pointerBuffer.put(i2, fFITypeArray[i2]);
        }
        FFICIF fFICIF = FFICIF.create(memoryUtil$MemoryAllocator.malloc(FFICIF.SIZEOF));
        n2 = LibFFI.ffi_prep_cif(fFICIF, n2, fFIType, pointerBuffer);
        if (n2 != 0) {
            throw new IllegalStateException("Failed to prepare libffi CIF: " + n2);
        }
        return fFICIF;
    }

    public static FFICIF apiCreateCIFVar(int n2, int n3, FFIType fFIType, FFIType ... fFITypeArray) {
        MemoryUtil$MemoryAllocator memoryUtil$MemoryAllocator = MemoryUtil.getAllocator();
        PointerBuffer pointerBuffer = PointerBuffer.create(memoryUtil$MemoryAllocator.malloc(fFITypeArray.length * MemoryStack.POINTER_SIZE), fFITypeArray.length);
        for (int i2 = 0; i2 < fFITypeArray.length; ++i2) {
            pointerBuffer.put(i2, fFITypeArray[i2]);
        }
        FFICIF fFICIF = FFICIF.create(memoryUtil$MemoryAllocator.malloc(FFICIF.SIZEOF));
        n2 = LibFFI.ffi_prep_cif_var(fFICIF, n2, n3, fFIType, pointerBuffer);
        if (n2 != 0) {
            throw new IllegalStateException("Failed to prepare libffi var CIF: " + n2);
        }
        return fFICIF;
    }

    public static int apiStdcall() {
        if (Platform.get() == Platform.WINDOWS && Pointer.BITS32) {
            return LibFFI.FFI_STDCALL;
        }
        return LibFFI.FFI_DEFAULT_ABI;
    }

    public static void apiClosureRet(long l2, boolean bl) {
        MemoryUtil.memPutAddress(l2, bl ? 1L : 0L);
    }

    public static void apiClosureRet(long l2, byte by) {
        MemoryUtil.memPutAddress(l2, (long)by & 0xFFL);
    }

    public static void apiClosureRet(long l2, short s2) {
        MemoryUtil.memPutAddress(l2, (long)s2 & 0xFFFFL);
    }

    public static void apiClosureRet(long l2, int n2) {
        MemoryUtil.memPutAddress(l2, (long)n2 & 0xFFFFFFFFL);
    }

    public static void apiClosureRetL(long l2, long l3) {
        MemoryUtil.memPutLong(l2, l3);
    }

    public static void apiClosureRetP(long l2, long l3) {
        MemoryUtil.memPutAddress(l2, l3);
    }

    public static void apiClosureRet(long l2, float f2) {
        MemoryUtil.memPutFloat(l2, f2);
    }

    public static void apiClosureRet(long l2, double d2) {
        MemoryUtil.memPutDouble(l2, d2);
    }

    private static /* synthetic */ boolean lambda$apiFindLibrary$0(String string, Path path, BasicFileAttributes basicFileAttributes) {
        return basicFileAttributes.isRegularFile() && path.getFileName().toString().equals(string);
    }

    static {
        String string = "[^\\d\\n\\r]*";
        String string2 = "(\\d+)[.](\\d+)(?:[.](\\S+))?";
        String string3 = "(?:\\s+(.+?))?\\s*";
        API_VERSION_PATTERN = Pattern.compile("^" + string + string2 + string3 + "$", 32);
    }
}

