/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.net.URL;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.Library;
import org.lwjgl.system.SharedLibraryLoader;

public final class LibraryResource {
    private LibraryResource() {
    }

    public static Path load(String string, String string2) {
        return LibraryResource.load(LibraryResource.class, string, string2);
    }

    public static Path load(Class<?> clazz, String string, String string2) {
        return LibraryResource.load(clazz, string, string2, false, true);
    }

    public static Path load(Class<?> clazz, String string, String string2, boolean bl) {
        return LibraryResource.load(clazz, string, string2, bl, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Path load(Class<?> object, String string, String string2, boolean bl, boolean bl2) {
        String string3;
        Object object2;
        block20: {
            if (Checks.DEBUG) {
                APIUtil.DEBUG_STREAM.print("[LWJGL] Loading library resource: " + string2 + "\n\tModule: " + string + "\n");
            }
            if ((object2 = Paths.get(string2, new String[0])).isAbsolute()) {
                if (!Files.exists((Path)object2, new LinkOption[0])) {
                    if (!bl2) throw new IllegalStateException("Failed to locate library resource: " + string2);
                    LibraryResource.printError();
                    throw new IllegalStateException("Failed to locate library resource: " + string2);
                }
                APIUtil.apiLogMore("Success");
                return object2;
            }
            if ((object = Library.findResource(object, string, string2, bl)) == null) {
                object2 = LibraryResource.loadFromLibraryPath(string, string2, bl);
                if (object2 != null) {
                    return object2;
                }
            } else {
                boolean bl3 = Configuration.DEBUG_LOADER.get(Boolean.FALSE);
                try {
                    block19: {
                        object2 = Library.getRegularFilePath((URL)object);
                        if (object2 != null) {
                            APIUtil.apiLogMore("Loaded from classpath: " + (String)object2);
                            return Paths.get((String)object2, new String[0]);
                        }
                        if (bl3) {
                            APIUtil.apiLogMore("Using SharedLibraryLoader...");
                        }
                        String string4 = string2;
                        object = SharedLibraryLoader.load(string4, string4, (URL)object, null);
                        Throwable throwable = null;
                        try {
                            object2 = LibraryResource.loadFromLibraryPath(string, string2, bl);
                            if (object2 == null) break block19;
                            if (object == null) return object2;
                        }
                        catch (Throwable throwable2) {
                            try {
                                object2 = throwable2;
                                throwable = throwable2;
                                throw object2;
                            }
                            catch (Throwable throwable3) {
                                if (object == null) throw throwable3;
                                if (throwable == null) {
                                    ((AbstractInterruptibleChannel)object).close();
                                    throw throwable3;
                                }
                                try {
                                    ((AbstractInterruptibleChannel)object).close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                        }
                        ((AbstractInterruptibleChannel)object).close();
                        return object2;
                    }
                    if (object != null) {
                        ((AbstractInterruptibleChannel)object).close();
                    }
                }
                catch (Exception exception) {
                    if (!bl3) break block20;
                    exception.printStackTrace(APIUtil.DEBUG_STREAM);
                }
            }
        }
        if ((string3 = System.getProperty("java.library.path")) != null && (object2 = LibraryResource.load(string, string2, bl, "java.library.path", string3)) != null) {
            return object2;
        }
        if (!bl2) throw new IllegalStateException("Failed to locate library resource: " + string2);
        LibraryResource.printError();
        throw new IllegalStateException("Failed to locate library resource: " + string2);
    }

    @Nullable
    private static Path loadFromLibraryPath(String string, String string2, boolean bl) {
        String string3 = Configuration.LIBRARY_PATH.get();
        if (string3 == null) {
            return null;
        }
        return LibraryResource.load(string, string2, bl, Configuration.LIBRARY_PATH.getProperty(), string3);
    }

    @Nullable
    private static Path load(String object, String string, boolean bl, String string2, String string3) {
        if ((object = Library.findFile(string3, (String)object, string, bl)) == null) {
            APIUtil.apiLogMore(string + " not found in " + string2 + "=" + string3);
            return null;
        }
        APIUtil.apiLogMore("Loaded from " + string2 + ": " + object);
        return object;
    }

    public static Path load(Class<?> clazz, String string, Configuration<String> configuration, String ... stringArray) {
        return LibraryResource.load(clazz, string, configuration, null, stringArray);
    }

    public static Path load(Class<?> clazz, String string, Configuration<String> object, @Nullable Supplier<Path> supplier, String ... stringArray) {
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("No default names specified.");
        }
        if ((object = ((Configuration)object).get()) != null) {
            return LibraryResource.load(clazz, string, (String)object);
        }
        if (supplier == null && stringArray.length <= 1) {
            return LibraryResource.load(clazz, string, stringArray[0]);
        }
        try {
            return LibraryResource.load(clazz, string, stringArray[0], false, false);
        }
        catch (Throwable throwable) {
            for (int i2 = 1; i2 < stringArray.length; ++i2) {
                try {
                    return LibraryResource.load(clazz, string, stringArray[i2], false, supplier == null && i2 == stringArray.length - 1);
                }
                catch (Throwable throwable2) {
                    continue;
                }
            }
            if (supplier != null) {
                return supplier.get();
            }
            throw throwable;
        }
    }

    private static void printError() {
        Library.printError("[LWJGL] Failed to load a library resource. Possible solutions:\n\ta) Add the directory that contains the resource to -Djava.library.path or -Dorg.lwjgl.librarypath.\n\tb) Add the JAR that contains the resource to the classpath.");
    }

    static {
        Library.initialize();
    }
}

