/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.util.function.Function;
import javax.annotation.Nullable;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.Platform$1;
import org.lwjgl.system.Platform$2;
import org.lwjgl.system.Platform$3;
import org.lwjgl.system.Platform$4;
import org.lwjgl.system.Platform$Architecture;

public abstract class Platform
extends Enum<Platform> {
    public static final /* enum */ Platform FREEBSD = new Platform$1("FreeBSD", "freebsd");
    public static final /* enum */ Platform LINUX = new Platform$2("Linux", "linux");
    public static final /* enum */ Platform MACOSX = new Platform$3("macOS", "macos");
    public static final /* enum */ Platform WINDOWS = new Platform$4("Windows", "windows");
    private static final Platform current;
    private static final Function<String, String> bundledLibraryNameMapper;
    private static final Function<String, String> bundledLibraryPathMapper;
    private final String name;
    private final String nativePath;
    private static final /* synthetic */ Platform[] $VALUES;

    public static Platform[] values() {
        return (Platform[])$VALUES.clone();
    }

    public static Platform valueOf(String string) {
        return Enum.valueOf(Platform.class, string);
    }

    private Platform(String string2, String string3) {
        this.name = string2;
        this.nativePath = string3;
    }

    public String getName() {
        return this.name;
    }

    abstract String mapLibraryName(String var1);

    public static Platform get() {
        return current;
    }

    public static Platform$Architecture getArchitecture() {
        return Platform$Architecture.current;
    }

    public static String mapLibraryNameBundled(String string) {
        return bundledLibraryNameMapper.apply(string);
    }

    static String mapLibraryPathBundled(String string) {
        return bundledLibraryPathMapper.apply(string);
    }

    private static Function<String, String> getMapper(@Nullable Object object, Function<String, String> function, Function<String, String> function2) {
        if (object == null || "default".equals(object)) {
            return function;
        }
        if ("legacy".equals(object)) {
            return function2;
        }
        if (object instanceof Function) {
            return (Function)object;
        }
        object = object.toString();
        try {
            return (Function)Class.forName((String)object).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable throwable) {
            if (Checks.DEBUG) {
                throwable.printStackTrace(APIUtil.DEBUG_STREAM);
            }
            APIUtil.apiLog(String.format("Warning: Failed to instantiate bundled library mapper: %s. Using the default.", object));
            return function;
        }
    }

    /* synthetic */ Platform(String string, int n2, String string2, String string3, Platform$1 platform$1) {
        this(string2, string3);
    }

    static {
        $VALUES = new Platform[]{FREEBSD, LINUX, MACOSX, WINDOWS};
        String string2 = System.getProperty("os.name");
        if (string2.startsWith("Windows")) {
            current = WINDOWS;
        } else if (string2.startsWith("FreeBSD")) {
            current = FREEBSD;
        } else if (string2.startsWith("Linux") || string2.startsWith("SunOS") || string2.startsWith("Unix")) {
            current = LINUX;
        } else if (string2.startsWith("Mac OS X") || string2.startsWith("Darwin")) {
            current = MACOSX;
        } else {
            throw new LinkageError("Unknown platform: " + string2);
        }
        bundledLibraryNameMapper = Platform.getMapper(Configuration.BUNDLED_LIBRARY_NAME_MAPPER.get("default"), string -> string, string -> {
            if (Platform$Architecture.current.is64Bit) {
                return string;
            }
            return string + "32";
        });
        bundledLibraryPathMapper = Platform.getMapper(Configuration.BUNDLED_LIBRARY_PATH_MAPPER.get("default"), string -> Platform.current.nativePath + "/" + Platform$Architecture.current.name().toLowerCase() + "/" + string, string -> {
            String string2 = string;
            return string2.substring(string2.lastIndexOf(47));
        });
    }
}

