/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.zip.CRC32;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.lwjgl.Version;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.Platform;

final class SharedLibraryLoader {
    private static final Lock EXTRACT_PATH_LOCK = new ReentrantLock();
    @Nullable
    @GuardedBy(value="EXTRACT_PATH_LOCK")
    private static Path extractPath;
    private static HashSet<Path> extractPaths;
    private static boolean checkedLoad;

    private SharedLibraryLoader() {
    }

    static FileChannel load(String string, String object, URL uRL, @Nullable Consumer<String> object2) {
        try {
            EXTRACT_PATH_LOCK.lock();
            try {
                if (extractPath != null) {
                    object = extractPath.resolve((String)object);
                } else {
                    object = SharedLibraryLoader.getExtractPath((String)object, uRL, object2);
                    object2 = object.getParent();
                    if (checkedLoad) {
                        extractPath = object2;
                    }
                    SharedLibraryLoader.initExtractPath((Path)object2);
                }
            }
            finally {
                EXTRACT_PATH_LOCK.unlock();
            }
            return SharedLibraryLoader.extract((Path)object, uRL);
        }
        catch (Exception exception) {
            throw new RuntimeException("\tFailed to extract " + string + " library", exception);
        }
    }

    private static void initExtractPath(Path object) {
        if (extractPaths.contains(object)) {
            return;
        }
        extractPaths.add((Path)object);
        object = object.toAbsolutePath().toString();
        String string = Configuration.LIBRARY_PATH.get();
        if (string != null && !string.isEmpty()) {
            object = (String)object + File.pathSeparator + string;
        }
        System.setProperty(Configuration.LIBRARY_PATH.getProperty(), (String)object);
        Configuration.LIBRARY_PATH.set((String)object);
    }

    private static Path getExtractPath(String string, URL uRL, @Nullable Consumer<String> consumer) {
        Path path;
        Object object;
        Object object2 = Configuration.SHARED_LIBRARY_EXTRACT_PATH.get();
        if (object2 != null) {
            object = Paths.get((String)object2, new String[0]);
            if (SharedLibraryLoader.canWrite((Path)object, path = object.resolve(string), uRL, consumer)) {
                return path;
            }
            APIUtil.apiLogMore("The path " + (String)object2 + " is not accessible. Trying other paths.");
        }
        object2 = Version.getVersion().replace(' ', '-');
        String string2 = Platform.getArchitecture().name().toLowerCase();
        object = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
        if (SharedLibraryLoader.canWrite((Path)object, path = object.resolve(Paths.get(Configuration.SHARED_LIBRARY_EXTRACT_DIRECTORY.get("lwjgl_" + System.getProperty("user.name").trim()), new String[]{object2, string2, string})), uRL, consumer)) {
            return path;
        }
        object2 = Paths.get("." + Configuration.SHARED_LIBRARY_EXTRACT_DIRECTORY.get("lwjgl"), new String[]{object2, string2, string});
        object = Paths.get("", new String[0]).toAbsolutePath();
        if (SharedLibraryLoader.canWrite((Path)object, path = object.resolve((Path)object2), uRL, consumer)) {
            return path;
        }
        object = Paths.get(System.getProperty("user.home"), new String[0]);
        if (SharedLibraryLoader.canWrite((Path)object, path = object.resolve((Path)object2), uRL, consumer)) {
            return path;
        }
        if (Platform.get() == Platform.WINDOWS) {
            object = System.getenv("SystemRoot");
            if (object != null && SharedLibraryLoader.canWrite((Path)(object = Paths.get((String)object, "Temp")), path = object.resolve((Path)object2), uRL, consumer)) {
                return path;
            }
            object = System.getenv("SystemDrive");
            if (object != null && SharedLibraryLoader.canWrite((Path)(object = Paths.get((String)object + "/", new String[0])), path = object.resolve(Paths.get("Temp", new String[0]).resolve((Path)object2)), uRL, consumer)) {
                return path;
            }
        }
        try {
            path = Files.createTempDirectory("lwjgl", new FileAttribute[0]);
            object = path.getParent();
            path = path.resolve(string);
            if (SharedLibraryLoader.canWrite((Path)object, path, uRL, consumer)) {
                return path;
            }
        }
        catch (IOException iOException) {}
        throw new RuntimeException("Failed to find an appropriate directory to extract the native library");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static FileChannel extract(Path object, URL uRL) {
        Object object2;
        Throwable throwable;
        InputStream inputStream;
        if (Files.exists((Path)object, new LinkOption[0])) {
            block27: {
                inputStream = uRL.openStream();
                throwable = null;
                try {
                    block28: {
                        object2 = Files.newInputStream((Path)object, new OpenOption[0]);
                        Throwable throwable2 = null;
                        try {
                            if (SharedLibraryLoader.crc(inputStream) != SharedLibraryLoader.crc((InputStream)object2)) break block27;
                            if (Configuration.DEBUG_LOADER.get(Boolean.FALSE).booleanValue()) {
                                APIUtil.apiLogMore("Found at: " + object);
                            }
                            object = SharedLibraryLoader.lock((Path)object);
                            if (object2 == null) break block28;
                        }
                        catch (Throwable throwable3) {
                            try {
                                object = throwable3;
                                throwable2 = throwable3;
                                throw object;
                            }
                            catch (Throwable throwable4) {
                                if (object2 == null) throw throwable4;
                                if (throwable2 == null) {
                                    ((InputStream)object2).close();
                                    throw throwable4;
                                }
                                try {
                                    ((InputStream)object2).close();
                                    throw throwable4;
                                }
                                catch (Throwable throwable5) {
                                    throwable2.addSuppressed(throwable5);
                                    throw throwable4;
                                }
                            }
                        }
                        ((InputStream)object2).close();
                    }
                    if (inputStream == null) return object;
                }
                catch (Throwable throwable6) {
                    try {
                        object2 = throwable6;
                        throwable = throwable6;
                        throw object2;
                    }
                    catch (Throwable throwable7) {
                        if (inputStream == null) throw throwable7;
                        if (throwable == null) {
                            inputStream.close();
                            throw throwable7;
                        }
                        try {
                            inputStream.close();
                            throw throwable7;
                        }
                        catch (Throwable throwable8) {
                            throwable.addSuppressed(throwable8);
                            throw throwable7;
                        }
                    }
                }
                inputStream.close();
                return object;
            }
            if (object2 != null) {
                ((InputStream)object2).close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
        APIUtil.apiLogMore("Extracting: " + uRL.getPath());
        if (extractPath == null) {
            APIUtil.apiLogMore("        to: " + object);
        }
        Files.createDirectories(object.getParent(), new FileAttribute[0]);
        inputStream = uRL.openStream();
        throwable = null;
        try {
            Files.copy(inputStream, (Path)object, StandardCopyOption.REPLACE_EXISTING);
            if (inputStream == null) return SharedLibraryLoader.lock((Path)object);
        }
        catch (Throwable throwable9) {
            try {
                object2 = throwable9;
                throwable = throwable9;
                throw object2;
            }
            catch (Throwable throwable10) {
                if (inputStream == null) throw throwable10;
                if (throwable == null) {
                    inputStream.close();
                    throw throwable10;
                }
                try {
                    inputStream.close();
                    throw throwable10;
                }
                catch (Throwable throwable11) {
                    throwable.addSuppressed(throwable11);
                    throw throwable10;
                }
            }
        }
        inputStream.close();
        return SharedLibraryLoader.lock((Path)object);
    }

    private static FileChannel lock(Path object) {
        try {
            object = FileChannel.open((Path)object, new OpenOption[0]);
            if (((FileChannel)object).tryLock(0L, Long.MAX_VALUE, true) == null) {
                if (Configuration.DEBUG_LOADER.get(Boolean.FALSE).booleanValue()) {
                    APIUtil.apiLogMore("File is locked by another process, waiting...");
                }
                ((FileChannel)object).lock(0L, Long.MAX_VALUE, true);
            }
            return object;
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to lock file.", exception);
        }
    }

    private static long crc(InputStream inputStream) {
        int n2;
        CRC32 cRC32 = new CRC32();
        byte[] byArray = new byte[8192];
        while ((n2 = inputStream.read(byArray)) != -1) {
            cRC32.update(byArray, 0, n2);
        }
        return cRC32.getValue();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean canWrite(Path path, Path path2, URL object, @Nullable Consumer<String> object2) {
        Path path3;
        if (Files.exists(path2, new LinkOption[0])) {
            if (!Files.isWritable(path2)) {
                return false;
            }
            path3 = path2.getParent().resolve(".lwjgl.test");
        } else {
            try {
                Files.createDirectories(path2.getParent(), new FileAttribute[0]);
            }
            catch (IOException iOException) {
                return false;
            }
            path3 = path2;
        }
        try {
            block14: {
                Files.write(path3, new byte[0], new OpenOption[0]);
                Files.delete(path3);
                if (object2 == null) return true;
                object = SharedLibraryLoader.extract(path2, (URL)object);
                Throwable throwable = null;
                try {
                    object2.accept(path2.toAbsolutePath().toString());
                    if (object == null) break block14;
                }
                catch (Throwable throwable2) {
                    try {
                        object2 = throwable2;
                        throwable = throwable2;
                        throw object2;
                    }
                    catch (Throwable throwable3) {
                        if (object == null) throw throwable3;
                        if (throwable == null) {
                            ((AbstractInterruptibleChannel)object).close();
                            throw throwable3;
                        }
                        try {
                            ((AbstractInterruptibleChannel)object).close();
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                            throw throwable3;
                        }
                    }
                }
                ((AbstractInterruptibleChannel)object).close();
            }
            checkedLoad = true;
            return true;
        }
        catch (Throwable throwable) {
            if (path2 != path3) return false;
            SharedLibraryLoader.canWriteCleanup(path, path2);
            return false;
        }
    }

    private static void canWriteCleanup(Path object, Path path) {
        try {
            Stream<Path> stream;
            block14: {
                Files.deleteIfExists(path);
                path = path.getParent();
                while (!Files.isSameFile(path, (Path)object)) {
                    block13: {
                        stream = Files.list(path);
                        Throwable throwable = null;
                        try {
                            if (!stream.findAny().isPresent()) break block13;
                            if (stream == null) break;
                        }
                        catch (Throwable throwable2) {
                            try {
                                object = throwable2;
                                throwable = throwable2;
                                throw object;
                            }
                            catch (Throwable throwable3) {
                                if (stream != null) {
                                    if (throwable != null) {
                                        try {
                                            stream.close();
                                        }
                                        catch (Throwable throwable4) {
                                            throwable.addSuppressed(throwable4);
                                        }
                                    } else {
                                        stream.close();
                                    }
                                }
                                throw throwable3;
                            }
                        }
                        break block14;
                    }
                    if (stream != null) {
                        stream.close();
                    }
                    Files.delete(path);
                    path = path.getParent();
                }
                return;
            }
            stream.close();
        }
        catch (IOException iOException) {}
    }

    static {
        extractPaths = new HashSet(4);
    }
}

