/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.system.Struct;

class StructBuffer$StructSpliterator<T extends Struct<T>>
implements Spliterator<T> {
    private long address;
    @Nullable
    private ByteBuffer container;
    private T factory;
    private int index;
    private int fence;

    StructBuffer$StructSpliterator(long l2, @Nullable ByteBuffer byteBuffer, T t2, int n2, int n3) {
        this.address = l2;
        this.container = byteBuffer;
        this.factory = t2;
        this.index = n2;
        this.fence = n3;
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> consumer) {
        Objects.requireNonNull(consumer);
        if (this.index < this.fence) {
            consumer.accept(((Struct)this.factory).create(this.address + Integer.toUnsignedLong(this.index++) * (long)((Struct)this.factory).sizeof(), this.container));
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public Spliterator<T> trySplit() {
        int n2 = this.index;
        int n3 = n2 + this.fence >>> 1;
        if (n2 < n3) {
            this.index = n3;
            return new StructBuffer$StructSpliterator<T>(this.address, this.container, this.factory, n2, this.index);
        }
        return null;
    }

    @Override
    public long estimateSize() {
        return this.fence - this.index;
    }

    @Override
    public int characteristics() {
        return 17744;
    }

    @Override
    public void forEachRemaining(Consumer<? super T> consumer) {
        int n2;
        Objects.requireNonNull(consumer);
        try {
            int n3 = ((Struct)this.factory).sizeof();
            for (n2 = this.index; n2 < this.fence; ++n2) {
                consumer.accept(((Struct)this.factory).create(this.address + Integer.toUnsignedLong(n2) * (long)n3, this.container));
            }
            return;
        }
        finally {
            this.index = n2;
        }
    }

    @Override
    public Comparator<? super T> getComparator() {
        throw new IllegalStateException();
    }
}

