/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer$Default;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer$StructIterator;
import org.lwjgl.system.StructBuffer$StructSpliterator;

public abstract class StructBuffer<T extends Struct<T>, SELF extends StructBuffer<T, SELF>>
extends CustomBuffer<SELF>
implements Iterable<T> {
    public StructBuffer(ByteBuffer byteBuffer, int n2) {
        int n3 = n2;
        super(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public StructBuffer(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
        super(l2, byteBuffer, n2, n3, n4, n5);
    }

    @Override
    public int sizeof() {
        return ((Struct)this.getElementFactory()).sizeof();
    }

    public T get() {
        T t2 = this.getElementFactory();
        return (T)((Struct)t2).create(this.address + Integer.toUnsignedLong(this.nextGetIndex()) * (long)((Struct)t2).sizeof(), this.container);
    }

    public SELF get(T t2) {
        int n2 = ((Struct)this.getElementFactory()).sizeof();
        MemoryUtil.memCopy(this.address + Integer.toUnsignedLong(this.nextGetIndex()) * (long)n2, ((Pointer$Default)t2).address(), n2);
        return (SELF)((StructBuffer)this.self());
    }

    @Override
    public SELF put(T t2) {
        int n2 = ((Struct)this.getElementFactory()).sizeof();
        MemoryUtil.memCopy(((Pointer$Default)t2).address(), this.address + Integer.toUnsignedLong(this.nextPutIndex()) * (long)n2, n2);
        return (SELF)((StructBuffer)this.self());
    }

    public T get(int n2) {
        T t2 = this.getElementFactory();
        return (T)((Struct)t2).create(this.address + Integer.toUnsignedLong(StructBuffer.check(n2, this.limit)) * (long)((Struct)t2).sizeof(), this.container);
    }

    public SELF get(int n2, T t2) {
        int n3 = ((Struct)this.getElementFactory()).sizeof();
        MemoryUtil.memCopy(this.address + Checks.check(n2, this.limit) * (long)n3, ((Pointer$Default)t2).address(), n3);
        return (SELF)((StructBuffer)this.self());
    }

    public SELF put(int n2, T t2) {
        int n3 = ((Struct)this.getElementFactory()).sizeof();
        MemoryUtil.memCopy(((Pointer$Default)t2).address(), this.address + Checks.check(n2, this.limit) * (long)n3, n3);
        return (SELF)((StructBuffer)this.self());
    }

    public SELF apply(Consumer<T> consumer) {
        consumer.accept(this.get());
        return (SELF)((StructBuffer)this.self());
    }

    public SELF apply(int n2, Consumer<T> consumer) {
        consumer.accept(this.get(n2));
        return (SELF)((StructBuffer)this.self());
    }

    @Override
    public Iterator<T> iterator() {
        return new StructBuffer$StructIterator<T>(this.address, this.container, this.getElementFactory(), this.position, this.limit);
    }

    @Override
    public void forEach(Consumer<? super T> consumer) {
        Objects.requireNonNull(consumer);
        T t2 = this.getElementFactory();
        int n2 = this.limit;
        ((Struct)t2).sizeof();
        for (int i2 = this.position; i2 < n2; ++i2) {
            consumer.accept(((Struct)t2).create(this.address + Integer.toUnsignedLong(i2) * (long)((CustomBuffer)this).sizeof(), this.container));
        }
    }

    @Override
    public Spliterator<T> spliterator() {
        return new StructBuffer$StructSpliterator<T>(this.address, this.container, this.getElementFactory(), this.position, this.limit);
    }

    public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public Stream<T> parallelStream() {
        return StreamSupport.stream(this.spliterator(), true);
    }

    protected abstract T getElementFactory();

    private static int check(int n2, int n3) {
        if (Checks.CHECKS && (n2 < 0 || n3 <= n2)) {
            throw new IndexOutOfBoundsException();
        }
        return n2;
    }
}

