/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.freebsd;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.SharedLibrary$Default;
import org.lwjgl.system.SharedLibraryUtil;
import org.lwjgl.system.freebsd.DynamicLinkLoader;

public class FreeBSDLibrary
extends SharedLibrary$Default {
    public FreeBSDLibrary(String string) {
        String string2 = string;
        this(string2, FreeBSDLibrary.loadLibrary(string2));
    }

    public FreeBSDLibrary(String string, long l2) {
        super(string, l2);
    }

    private static long loadLibrary(String object) {
        long l2;
        MemoryStack memoryStack = MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            l2 = DynamicLinkLoader.dlopen(memoryStack.UTF8((CharSequence)object), 1);
            if (memoryStack != null) {
                memoryStack.close();
            }
        }
        catch (Throwable throwable2) {
            try {
                object = throwable2;
                throwable = throwable2;
                throw object;
            }
            catch (Throwable throwable3) {
                if (memoryStack != null) {
                    if (throwable != null) {
                        try {
                            memoryStack.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        memoryStack.close();
                    }
                }
                throw throwable3;
            }
        }
        if (l2 == 0L) {
            throw new UnsatisfiedLinkError("Failed to dynamically load library: " + (String)object + "(error = " + DynamicLinkLoader.dlerror() + ")");
        }
        return l2;
    }

    @Override
    @Nullable
    public String getPath() {
        return SharedLibraryUtil.getLibraryPath(this.address());
    }

    @Override
    public long getFunctionAddress(ByteBuffer byteBuffer) {
        return DynamicLinkLoader.dlsym(this.address(), byteBuffer);
    }

    @Override
    public void free() {
        DynamicLinkLoader.dlclose(this.address());
    }
}

