/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.linux.Flock$Buffer;

@NativeType(value="struct flock64")
public class Flock
extends Struct<Flock>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int L_TYPE;
    public static final int L_WHENCE;
    public static final int L_START;
    public static final int L_LEN;
    public static final int L_PID;

    protected Flock(long l2, @Nullable ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected Flock create(long l2, @Nullable ByteBuffer byteBuffer) {
        return new Flock(l2, byteBuffer);
    }

    public Flock(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), Flock.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public short l_type() {
        return Flock.nl_type(this.address());
    }

    public short l_whence() {
        return Flock.nl_whence(this.address());
    }

    @NativeType(value="off_t")
    public long l_start() {
        return Flock.nl_start(this.address());
    }

    @NativeType(value="off_t")
    public long l_len() {
        return Flock.nl_len(this.address());
    }

    @NativeType(value="pid_t")
    public int l_pid() {
        return Flock.nl_pid(this.address());
    }

    public Flock l_type(short s2) {
        Flock.nl_type(this.address(), s2);
        return this;
    }

    public Flock l_whence(short s2) {
        Flock.nl_whence(this.address(), s2);
        return this;
    }

    public Flock l_start(@NativeType(value="off_t") long l2) {
        Flock.nl_start(this.address(), l2);
        return this;
    }

    public Flock l_len(@NativeType(value="off_t") long l2) {
        Flock.nl_len(this.address(), l2);
        return this;
    }

    public Flock l_pid(@NativeType(value="pid_t") int n2) {
        Flock.nl_pid(this.address(), n2);
        return this;
    }

    public Flock set(short s2, short s3, long l2, long l3, int n2) {
        this.l_type(s2);
        this.l_whence(s3);
        this.l_start(l2);
        this.l_len(l3);
        this.l_pid(n2);
        return this;
    }

    public Flock set(Flock flock) {
        MemoryUtil.memCopy(flock.address(), this.address(), SIZEOF);
        return this;
    }

    public static Flock malloc() {
        return new Flock(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static Flock calloc() {
        return new Flock(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static Flock create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new Flock(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static Flock create(long l2) {
        return new Flock(l2, null);
    }

    @Nullable
    public static Flock createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new Flock(l2, null);
    }

    public static Flock$Buffer malloc(int n2) {
        return new Flock$Buffer(MemoryUtil.nmemAllocChecked(Flock.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static Flock$Buffer calloc(int n2) {
        return new Flock$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static Flock$Buffer create(int n2) {
        ByteBuffer byteBuffer = Flock.__create(n2, SIZEOF);
        int n3 = n2;
        return new Flock$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static Flock$Buffer create(long l2, int n2) {
        return new Flock$Buffer(l2, n2);
    }

    @Nullable
    public static Flock$Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new Flock$Buffer(l2, n2);
    }

    public static Flock malloc(MemoryStack memoryStack) {
        return new Flock(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static Flock calloc(MemoryStack memoryStack) {
        return new Flock(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Flock$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new Flock$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static Flock$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new Flock$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static short nl_type(long l2) {
        return UNSAFE.getShort(null, l2 + (long)L_TYPE);
    }

    public static short nl_whence(long l2) {
        return UNSAFE.getShort(null, l2 + (long)L_WHENCE);
    }

    public static long nl_start(long l2) {
        return UNSAFE.getLong(null, l2 + (long)L_START);
    }

    public static long nl_len(long l2) {
        return UNSAFE.getLong(null, l2 + (long)L_LEN);
    }

    public static int nl_pid(long l2) {
        return UNSAFE.getInt(null, l2 + (long)L_PID);
    }

    public static void nl_type(long l2, short s2) {
        UNSAFE.putShort(null, l2 + (long)L_TYPE, s2);
    }

    public static void nl_whence(long l2, short s2) {
        UNSAFE.putShort(null, l2 + (long)L_WHENCE, s2);
    }

    public static void nl_start(long l2, long l3) {
        UNSAFE.putLong(null, l2 + (long)L_START, l3);
    }

    public static void nl_len(long l2, long l3) {
        UNSAFE.putLong(null, l2 + (long)L_LEN, l3);
    }

    public static void nl_pid(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)L_PID, n2);
    }

    static {
        Struct$Layout struct$Layout = Flock.__struct(Flock.__member(2), Flock.__member(2), Flock.__member(8), Flock.__member(8), Flock.__member(4));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        L_TYPE = struct$Layout.offsetof(0);
        L_WHENCE = struct$Layout.offsetof(1);
        L_START = struct$Layout.offsetof(2);
        L_LEN = struct$Layout.offsetof(3);
        L_PID = struct$Layout.offsetof(4);
    }
}

