/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.linux.IOVec$Buffer;

@NativeType(value="struct iovec")
public class IOVec
extends Struct<IOVec>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int IOV_BASE;
    public static final int IOV_LEN;

    protected IOVec(long l2, @Nullable ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected IOVec create(long l2, @Nullable ByteBuffer byteBuffer) {
        return new IOVec(l2, byteBuffer);
    }

    public IOVec(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), IOVec.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @Nullable
    @NativeType(value="void *")
    public ByteBuffer iov_base() {
        return IOVec.niov_base(this.address());
    }

    @NativeType(value="size_t")
    public long iov_len() {
        return IOVec.niov_len(this.address());
    }

    public IOVec iov_base(@Nullable @NativeType(value="void *") ByteBuffer byteBuffer) {
        IOVec.niov_base(this.address(), byteBuffer);
        return this;
    }

    public IOVec iov_len(@NativeType(value="size_t") long l2) {
        IOVec.niov_len(this.address(), l2);
        return this;
    }

    public IOVec set(@Nullable ByteBuffer byteBuffer, long l2) {
        this.iov_base(byteBuffer);
        this.iov_len(l2);
        return this;
    }

    public IOVec set(IOVec iOVec) {
        MemoryUtil.memCopy(iOVec.address(), this.address(), SIZEOF);
        return this;
    }

    public static IOVec malloc() {
        return new IOVec(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static IOVec calloc() {
        return new IOVec(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static IOVec create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new IOVec(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static IOVec create(long l2) {
        return new IOVec(l2, null);
    }

    @Nullable
    public static IOVec createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new IOVec(l2, null);
    }

    public static IOVec$Buffer malloc(int n2) {
        return new IOVec$Buffer(MemoryUtil.nmemAllocChecked(IOVec.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static IOVec$Buffer calloc(int n2) {
        return new IOVec$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static IOVec$Buffer create(int n2) {
        ByteBuffer byteBuffer = IOVec.__create(n2, SIZEOF);
        int n3 = n2;
        return new IOVec$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static IOVec$Buffer create(long l2, int n2) {
        return new IOVec$Buffer(l2, n2);
    }

    @Nullable
    public static IOVec$Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new IOVec$Buffer(l2, n2);
    }

    public static IOVec malloc(MemoryStack memoryStack) {
        return new IOVec(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static IOVec calloc(MemoryStack memoryStack) {
        return new IOVec(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static IOVec$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new IOVec$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static IOVec$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new IOVec$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    @Nullable
    public static ByteBuffer niov_base(long l2) {
        return MemoryUtil.memByteBufferSafe(MemoryUtil.memGetAddress(l2 + (long)IOV_BASE), (int)IOVec.niov_len(l2));
    }

    public static long niov_len(long l2) {
        return MemoryUtil.memGetAddress(l2 + (long)IOV_LEN);
    }

    public static void niov_base(long l2, @Nullable ByteBuffer byteBuffer) {
        MemoryUtil.memPutAddress(l2 + (long)IOV_BASE, MemoryUtil.memAddressSafe(byteBuffer));
    }

    public static void niov_len(long l2, long l3) {
        MemoryUtil.memPutAddress(l2 + (long)IOV_LEN, l3);
    }

    static {
        Struct$Layout struct$Layout = IOVec.__struct(IOVec.__member(POINTER_SIZE), IOVec.__member(POINTER_SIZE));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        IOV_BASE = struct$Layout.offsetof(0);
        IOV_LEN = struct$Layout.offsetof(1);
    }
}

