/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.linux.XKeyEvent$Buffer;

public class XKeyEvent
extends Struct<XKeyEvent>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int SERIAL;
    public static final int SEND_EVENT;
    public static final int DISPLAY;
    public static final int WINDOW;
    public static final int ROOT;
    public static final int SUBWINDOW;
    public static final int TIME;
    public static final int X;
    public static final int Y;
    public static final int X_ROOT;
    public static final int Y_ROOT;
    public static final int STATE;
    public static final int KEYCODE;
    public static final int SAME_SCREEN;

    protected XKeyEvent(long l2, @Nullable ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected XKeyEvent create(long l2, @Nullable ByteBuffer byteBuffer) {
        return new XKeyEvent(l2, byteBuffer);
    }

    public XKeyEvent(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), XKeyEvent.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int type() {
        return XKeyEvent.ntype(this.address());
    }

    @NativeType(value="unsigned long")
    public long serial() {
        return XKeyEvent.nserial(this.address());
    }

    @NativeType(value="Bool")
    public boolean send_event() {
        return XKeyEvent.nsend_event(this.address()) != 0;
    }

    @NativeType(value="Display *")
    public long display() {
        return XKeyEvent.ndisplay(this.address());
    }

    @NativeType(value="Window")
    public long window() {
        return XKeyEvent.nwindow(this.address());
    }

    @NativeType(value="Window")
    public long root() {
        return XKeyEvent.nroot(this.address());
    }

    @NativeType(value="Window")
    public long subwindow() {
        return XKeyEvent.nsubwindow(this.address());
    }

    @NativeType(value="Time")
    public long time() {
        return XKeyEvent.ntime(this.address());
    }

    public int x() {
        return XKeyEvent.nx(this.address());
    }

    public int y() {
        return XKeyEvent.ny(this.address());
    }

    public int x_root() {
        return XKeyEvent.nx_root(this.address());
    }

    public int y_root() {
        return XKeyEvent.ny_root(this.address());
    }

    @NativeType(value="unsigned int")
    public int state() {
        return XKeyEvent.nstate(this.address());
    }

    @NativeType(value="unsigned int")
    public int keycode() {
        return XKeyEvent.nkeycode(this.address());
    }

    @NativeType(value="Bool")
    public boolean same_screen() {
        return XKeyEvent.nsame_screen(this.address()) != 0;
    }

    public XKeyEvent type(int n2) {
        XKeyEvent.ntype(this.address(), n2);
        return this;
    }

    public XKeyEvent serial(@NativeType(value="unsigned long") long l2) {
        XKeyEvent.nserial(this.address(), l2);
        return this;
    }

    public XKeyEvent send_event(@NativeType(value="Bool") boolean bl) {
        XKeyEvent.nsend_event(this.address(), bl ? 1 : 0);
        return this;
    }

    public XKeyEvent display(@NativeType(value="Display *") long l2) {
        XKeyEvent.ndisplay(this.address(), l2);
        return this;
    }

    public XKeyEvent window(@NativeType(value="Window") long l2) {
        XKeyEvent.nwindow(this.address(), l2);
        return this;
    }

    public XKeyEvent root(@NativeType(value="Window") long l2) {
        XKeyEvent.nroot(this.address(), l2);
        return this;
    }

    public XKeyEvent subwindow(@NativeType(value="Window") long l2) {
        XKeyEvent.nsubwindow(this.address(), l2);
        return this;
    }

    public XKeyEvent time(@NativeType(value="Time") long l2) {
        XKeyEvent.ntime(this.address(), l2);
        return this;
    }

    public XKeyEvent x(int n2) {
        XKeyEvent.nx(this.address(), n2);
        return this;
    }

    public XKeyEvent y(int n2) {
        XKeyEvent.ny(this.address(), n2);
        return this;
    }

    public XKeyEvent x_root(int n2) {
        XKeyEvent.nx_root(this.address(), n2);
        return this;
    }

    public XKeyEvent y_root(int n2) {
        XKeyEvent.ny_root(this.address(), n2);
        return this;
    }

    public XKeyEvent state(@NativeType(value="unsigned int") int n2) {
        XKeyEvent.nstate(this.address(), n2);
        return this;
    }

    public XKeyEvent keycode(@NativeType(value="unsigned int") int n2) {
        XKeyEvent.nkeycode(this.address(), n2);
        return this;
    }

    public XKeyEvent same_screen(@NativeType(value="Bool") boolean bl) {
        XKeyEvent.nsame_screen(this.address(), bl ? 1 : 0);
        return this;
    }

    public XKeyEvent set(int n2, long l2, boolean bl, long l3, long l4, long l5, long l6, long l7, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl2) {
        this.type(n2);
        this.serial(l2);
        this.send_event(bl);
        this.display(l3);
        this.window(l4);
        this.root(l5);
        this.subwindow(l6);
        this.time(l7);
        this.x(n3);
        this.y(n4);
        this.x_root(n5);
        this.y_root(n6);
        this.state(n7);
        this.keycode(n8);
        this.same_screen(bl2);
        return this;
    }

    public XKeyEvent set(XKeyEvent xKeyEvent) {
        MemoryUtil.memCopy(xKeyEvent.address(), this.address(), SIZEOF);
        return this;
    }

    public static XKeyEvent malloc() {
        return new XKeyEvent(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XKeyEvent calloc() {
        return new XKeyEvent(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XKeyEvent create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new XKeyEvent(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static XKeyEvent create(long l2) {
        return new XKeyEvent(l2, null);
    }

    @Nullable
    public static XKeyEvent createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new XKeyEvent(l2, null);
    }

    public static XKeyEvent$Buffer malloc(int n2) {
        return new XKeyEvent$Buffer(MemoryUtil.nmemAllocChecked(XKeyEvent.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static XKeyEvent$Buffer calloc(int n2) {
        return new XKeyEvent$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static XKeyEvent$Buffer create(int n2) {
        ByteBuffer byteBuffer = XKeyEvent.__create(n2, SIZEOF);
        int n3 = n2;
        return new XKeyEvent$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static XKeyEvent$Buffer create(long l2, int n2) {
        return new XKeyEvent$Buffer(l2, n2);
    }

    @Nullable
    public static XKeyEvent$Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new XKeyEvent$Buffer(l2, n2);
    }

    @Deprecated
    public static XKeyEvent mallocStack() {
        return XKeyEvent.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static XKeyEvent callocStack() {
        return XKeyEvent.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static XKeyEvent mallocStack(MemoryStack memoryStack) {
        return XKeyEvent.malloc(memoryStack);
    }

    @Deprecated
    public static XKeyEvent callocStack(MemoryStack memoryStack) {
        return XKeyEvent.calloc(memoryStack);
    }

    @Deprecated
    public static XKeyEvent$Buffer mallocStack(int n2) {
        return XKeyEvent.malloc(n2, MemoryStack.stackGet());
    }

    @Deprecated
    public static XKeyEvent$Buffer callocStack(int n2) {
        return XKeyEvent.calloc(n2, MemoryStack.stackGet());
    }

    @Deprecated
    public static XKeyEvent$Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return XKeyEvent.malloc(n2, memoryStack);
    }

    @Deprecated
    public static XKeyEvent$Buffer callocStack(int n2, MemoryStack memoryStack) {
        return XKeyEvent.calloc(n2, memoryStack);
    }

    public static XKeyEvent malloc(MemoryStack memoryStack) {
        return new XKeyEvent(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XKeyEvent calloc(MemoryStack memoryStack) {
        return new XKeyEvent(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static XKeyEvent$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new XKeyEvent$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static XKeyEvent$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new XKeyEvent$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int ntype(long l2) {
        return UNSAFE.getInt(null, l2 + (long)TYPE);
    }

    public static long nserial(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)SERIAL);
    }

    public static int nsend_event(long l2) {
        return UNSAFE.getInt(null, l2 + (long)SEND_EVENT);
    }

    public static long ndisplay(long l2) {
        return MemoryUtil.memGetAddress(l2 + (long)DISPLAY);
    }

    public static long nwindow(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)WINDOW);
    }

    public static long nroot(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)ROOT);
    }

    public static long nsubwindow(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)SUBWINDOW);
    }

    public static long ntime(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)TIME);
    }

    public static int nx(long l2) {
        return UNSAFE.getInt(null, l2 + (long)X);
    }

    public static int ny(long l2) {
        return UNSAFE.getInt(null, l2 + (long)Y);
    }

    public static int nx_root(long l2) {
        return UNSAFE.getInt(null, l2 + (long)X_ROOT);
    }

    public static int ny_root(long l2) {
        return UNSAFE.getInt(null, l2 + (long)Y_ROOT);
    }

    public static int nstate(long l2) {
        return UNSAFE.getInt(null, l2 + (long)STATE);
    }

    public static int nkeycode(long l2) {
        return UNSAFE.getInt(null, l2 + (long)KEYCODE);
    }

    public static int nsame_screen(long l2) {
        return UNSAFE.getInt(null, l2 + (long)SAME_SCREEN);
    }

    public static void ntype(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)TYPE, n2);
    }

    public static void nserial(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)SERIAL, l3);
    }

    public static void nsend_event(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)SEND_EVENT, n2);
    }

    public static void ndisplay(long l2, long l3) {
        MemoryUtil.memPutAddress(l2 + (long)DISPLAY, Checks.check(l3));
    }

    public static void nwindow(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)WINDOW, l3);
    }

    public static void nroot(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)ROOT, l3);
    }

    public static void nsubwindow(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)SUBWINDOW, l3);
    }

    public static void ntime(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)TIME, l3);
    }

    public static void nx(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)X, n2);
    }

    public static void ny(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)Y, n2);
    }

    public static void nx_root(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)X_ROOT, n2);
    }

    public static void ny_root(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)Y_ROOT, n2);
    }

    public static void nstate(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)STATE, n2);
    }

    public static void nkeycode(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)KEYCODE, n2);
    }

    public static void nsame_screen(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)SAME_SCREEN, n2);
    }

    public static void validate(long l2) {
        Checks.check(MemoryUtil.memGetAddress(l2 + (long)DISPLAY));
    }

    static {
        Struct$Layout struct$Layout = XKeyEvent.__struct(XKeyEvent.__member(4), XKeyEvent.__member(CLONG_SIZE), XKeyEvent.__member(4), XKeyEvent.__member(POINTER_SIZE), XKeyEvent.__member(CLONG_SIZE), XKeyEvent.__member(CLONG_SIZE), XKeyEvent.__member(CLONG_SIZE), XKeyEvent.__member(CLONG_SIZE), XKeyEvent.__member(4), XKeyEvent.__member(4), XKeyEvent.__member(4), XKeyEvent.__member(4), XKeyEvent.__member(4), XKeyEvent.__member(4), XKeyEvent.__member(4));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        TYPE = struct$Layout.offsetof(0);
        SERIAL = struct$Layout.offsetof(1);
        SEND_EVENT = struct$Layout.offsetof(2);
        DISPLAY = struct$Layout.offsetof(3);
        WINDOW = struct$Layout.offsetof(4);
        ROOT = struct$Layout.offsetof(5);
        SUBWINDOW = struct$Layout.offsetof(6);
        TIME = struct$Layout.offsetof(7);
        X = struct$Layout.offsetof(8);
        Y = struct$Layout.offsetof(9);
        X_ROOT = struct$Layout.offsetof(10);
        Y_ROOT = struct$Layout.offsetof(11);
        STATE = struct$Layout.offsetof(12);
        KEYCODE = struct$Layout.offsetof(13);
        SAME_SCREEN = struct$Layout.offsetof(14);
    }
}

