/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.linux.XNoExposeEvent$Buffer;

public class XNoExposeEvent
extends Struct<XNoExposeEvent>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int SERIAL;
    public static final int SEND_EVENT;
    public static final int DISPLAY;
    public static final int DRAWABLE;
    public static final int MAJOR_CODE;
    public static final int MINOR_CODE;

    protected XNoExposeEvent(long l2, @Nullable ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected XNoExposeEvent create(long l2, @Nullable ByteBuffer byteBuffer) {
        return new XNoExposeEvent(l2, byteBuffer);
    }

    public XNoExposeEvent(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), XNoExposeEvent.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int type() {
        return XNoExposeEvent.ntype(this.address());
    }

    @NativeType(value="unsigned long")
    public long serial() {
        return XNoExposeEvent.nserial(this.address());
    }

    @NativeType(value="Bool")
    public boolean send_event() {
        return XNoExposeEvent.nsend_event(this.address()) != 0;
    }

    @NativeType(value="Display *")
    public long display() {
        return XNoExposeEvent.ndisplay(this.address());
    }

    @NativeType(value="Drawable")
    public long drawable() {
        return XNoExposeEvent.ndrawable(this.address());
    }

    public int major_code() {
        return XNoExposeEvent.nmajor_code(this.address());
    }

    public int minor_code() {
        return XNoExposeEvent.nminor_code(this.address());
    }

    public XNoExposeEvent type(int n2) {
        XNoExposeEvent.ntype(this.address(), n2);
        return this;
    }

    public XNoExposeEvent serial(@NativeType(value="unsigned long") long l2) {
        XNoExposeEvent.nserial(this.address(), l2);
        return this;
    }

    public XNoExposeEvent send_event(@NativeType(value="Bool") boolean bl) {
        XNoExposeEvent.nsend_event(this.address(), bl ? 1 : 0);
        return this;
    }

    public XNoExposeEvent display(@NativeType(value="Display *") long l2) {
        XNoExposeEvent.ndisplay(this.address(), l2);
        return this;
    }

    public XNoExposeEvent drawable(@NativeType(value="Drawable") long l2) {
        XNoExposeEvent.ndrawable(this.address(), l2);
        return this;
    }

    public XNoExposeEvent major_code(int n2) {
        XNoExposeEvent.nmajor_code(this.address(), n2);
        return this;
    }

    public XNoExposeEvent minor_code(int n2) {
        XNoExposeEvent.nminor_code(this.address(), n2);
        return this;
    }

    public XNoExposeEvent set(int n2, long l2, boolean bl, long l3, long l4, int n3, int n4) {
        this.type(n2);
        this.serial(l2);
        this.send_event(bl);
        this.display(l3);
        this.drawable(l4);
        this.major_code(n3);
        this.minor_code(n4);
        return this;
    }

    public XNoExposeEvent set(XNoExposeEvent xNoExposeEvent) {
        MemoryUtil.memCopy(xNoExposeEvent.address(), this.address(), SIZEOF);
        return this;
    }

    public static XNoExposeEvent malloc() {
        return new XNoExposeEvent(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XNoExposeEvent calloc() {
        return new XNoExposeEvent(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XNoExposeEvent create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new XNoExposeEvent(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static XNoExposeEvent create(long l2) {
        return new XNoExposeEvent(l2, null);
    }

    @Nullable
    public static XNoExposeEvent createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new XNoExposeEvent(l2, null);
    }

    public static XNoExposeEvent$Buffer malloc(int n2) {
        return new XNoExposeEvent$Buffer(MemoryUtil.nmemAllocChecked(XNoExposeEvent.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static XNoExposeEvent$Buffer calloc(int n2) {
        return new XNoExposeEvent$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static XNoExposeEvent$Buffer create(int n2) {
        ByteBuffer byteBuffer = XNoExposeEvent.__create(n2, SIZEOF);
        int n3 = n2;
        return new XNoExposeEvent$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static XNoExposeEvent$Buffer create(long l2, int n2) {
        return new XNoExposeEvent$Buffer(l2, n2);
    }

    @Nullable
    public static XNoExposeEvent$Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new XNoExposeEvent$Buffer(l2, n2);
    }

    @Deprecated
    public static XNoExposeEvent mallocStack() {
        return XNoExposeEvent.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static XNoExposeEvent callocStack() {
        return XNoExposeEvent.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static XNoExposeEvent mallocStack(MemoryStack memoryStack) {
        return XNoExposeEvent.malloc(memoryStack);
    }

    @Deprecated
    public static XNoExposeEvent callocStack(MemoryStack memoryStack) {
        return XNoExposeEvent.calloc(memoryStack);
    }

    @Deprecated
    public static XNoExposeEvent$Buffer mallocStack(int n2) {
        return XNoExposeEvent.malloc(n2, MemoryStack.stackGet());
    }

    @Deprecated
    public static XNoExposeEvent$Buffer callocStack(int n2) {
        return XNoExposeEvent.calloc(n2, MemoryStack.stackGet());
    }

    @Deprecated
    public static XNoExposeEvent$Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return XNoExposeEvent.malloc(n2, memoryStack);
    }

    @Deprecated
    public static XNoExposeEvent$Buffer callocStack(int n2, MemoryStack memoryStack) {
        return XNoExposeEvent.calloc(n2, memoryStack);
    }

    public static XNoExposeEvent malloc(MemoryStack memoryStack) {
        return new XNoExposeEvent(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XNoExposeEvent calloc(MemoryStack memoryStack) {
        return new XNoExposeEvent(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static XNoExposeEvent$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new XNoExposeEvent$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static XNoExposeEvent$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new XNoExposeEvent$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int ntype(long l2) {
        return UNSAFE.getInt(null, l2 + (long)TYPE);
    }

    public static long nserial(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)SERIAL);
    }

    public static int nsend_event(long l2) {
        return UNSAFE.getInt(null, l2 + (long)SEND_EVENT);
    }

    public static long ndisplay(long l2) {
        return MemoryUtil.memGetAddress(l2 + (long)DISPLAY);
    }

    public static long ndrawable(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)DRAWABLE);
    }

    public static int nmajor_code(long l2) {
        return UNSAFE.getInt(null, l2 + (long)MAJOR_CODE);
    }

    public static int nminor_code(long l2) {
        return UNSAFE.getInt(null, l2 + (long)MINOR_CODE);
    }

    public static void ntype(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)TYPE, n2);
    }

    public static void nserial(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)SERIAL, l3);
    }

    public static void nsend_event(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)SEND_EVENT, n2);
    }

    public static void ndisplay(long l2, long l3) {
        MemoryUtil.memPutAddress(l2 + (long)DISPLAY, Checks.check(l3));
    }

    public static void ndrawable(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)DRAWABLE, l3);
    }

    public static void nmajor_code(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)MAJOR_CODE, n2);
    }

    public static void nminor_code(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)MINOR_CODE, n2);
    }

    public static void validate(long l2) {
        Checks.check(MemoryUtil.memGetAddress(l2 + (long)DISPLAY));
    }

    static {
        Struct$Layout struct$Layout = XNoExposeEvent.__struct(XNoExposeEvent.__member(4), XNoExposeEvent.__member(CLONG_SIZE), XNoExposeEvent.__member(4), XNoExposeEvent.__member(POINTER_SIZE), XNoExposeEvent.__member(CLONG_SIZE), XNoExposeEvent.__member(4), XNoExposeEvent.__member(4));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        TYPE = struct$Layout.offsetof(0);
        SERIAL = struct$Layout.offsetof(1);
        SEND_EVENT = struct$Layout.offsetof(2);
        DISPLAY = struct$Layout.offsetof(3);
        DRAWABLE = struct$Layout.offsetof(4);
        MAJOR_CODE = struct$Layout.offsetof(5);
        MINOR_CODE = struct$Layout.offsetof(6);
    }
}

