/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.linux.XResizeRequestEvent$Buffer;

public class XResizeRequestEvent
extends Struct<XResizeRequestEvent>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int SERIAL;
    public static final int SEND_EVENT;
    public static final int DISPLAY;
    public static final int WINDOW;
    public static final int WIDTH;
    public static final int HEIGHT;

    protected XResizeRequestEvent(long l2, @Nullable ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected XResizeRequestEvent create(long l2, @Nullable ByteBuffer byteBuffer) {
        return new XResizeRequestEvent(l2, byteBuffer);
    }

    public XResizeRequestEvent(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), XResizeRequestEvent.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int type() {
        return XResizeRequestEvent.ntype(this.address());
    }

    @NativeType(value="unsigned long")
    public long serial() {
        return XResizeRequestEvent.nserial(this.address());
    }

    @NativeType(value="Bool")
    public boolean send_event() {
        return XResizeRequestEvent.nsend_event(this.address()) != 0;
    }

    @NativeType(value="Display *")
    public long display() {
        return XResizeRequestEvent.ndisplay(this.address());
    }

    @NativeType(value="Window")
    public long window() {
        return XResizeRequestEvent.nwindow(this.address());
    }

    public int width() {
        return XResizeRequestEvent.nwidth(this.address());
    }

    public int height() {
        return XResizeRequestEvent.nheight(this.address());
    }

    public XResizeRequestEvent type(int n2) {
        XResizeRequestEvent.ntype(this.address(), n2);
        return this;
    }

    public XResizeRequestEvent serial(@NativeType(value="unsigned long") long l2) {
        XResizeRequestEvent.nserial(this.address(), l2);
        return this;
    }

    public XResizeRequestEvent send_event(@NativeType(value="Bool") boolean bl) {
        XResizeRequestEvent.nsend_event(this.address(), bl ? 1 : 0);
        return this;
    }

    public XResizeRequestEvent display(@NativeType(value="Display *") long l2) {
        XResizeRequestEvent.ndisplay(this.address(), l2);
        return this;
    }

    public XResizeRequestEvent window(@NativeType(value="Window") long l2) {
        XResizeRequestEvent.nwindow(this.address(), l2);
        return this;
    }

    public XResizeRequestEvent width(int n2) {
        XResizeRequestEvent.nwidth(this.address(), n2);
        return this;
    }

    public XResizeRequestEvent height(int n2) {
        XResizeRequestEvent.nheight(this.address(), n2);
        return this;
    }

    public XResizeRequestEvent set(int n2, long l2, boolean bl, long l3, long l4, int n3, int n4) {
        this.type(n2);
        this.serial(l2);
        this.send_event(bl);
        this.display(l3);
        this.window(l4);
        this.width(n3);
        this.height(n4);
        return this;
    }

    public XResizeRequestEvent set(XResizeRequestEvent xResizeRequestEvent) {
        MemoryUtil.memCopy(xResizeRequestEvent.address(), this.address(), SIZEOF);
        return this;
    }

    public static XResizeRequestEvent malloc() {
        return new XResizeRequestEvent(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XResizeRequestEvent calloc() {
        return new XResizeRequestEvent(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XResizeRequestEvent create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new XResizeRequestEvent(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static XResizeRequestEvent create(long l2) {
        return new XResizeRequestEvent(l2, null);
    }

    @Nullable
    public static XResizeRequestEvent createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new XResizeRequestEvent(l2, null);
    }

    public static XResizeRequestEvent$Buffer malloc(int n2) {
        return new XResizeRequestEvent$Buffer(MemoryUtil.nmemAllocChecked(XResizeRequestEvent.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static XResizeRequestEvent$Buffer calloc(int n2) {
        return new XResizeRequestEvent$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static XResizeRequestEvent$Buffer create(int n2) {
        ByteBuffer byteBuffer = XResizeRequestEvent.__create(n2, SIZEOF);
        int n3 = n2;
        return new XResizeRequestEvent$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static XResizeRequestEvent$Buffer create(long l2, int n2) {
        return new XResizeRequestEvent$Buffer(l2, n2);
    }

    @Nullable
    public static XResizeRequestEvent$Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new XResizeRequestEvent$Buffer(l2, n2);
    }

    @Deprecated
    public static XResizeRequestEvent mallocStack() {
        return XResizeRequestEvent.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static XResizeRequestEvent callocStack() {
        return XResizeRequestEvent.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static XResizeRequestEvent mallocStack(MemoryStack memoryStack) {
        return XResizeRequestEvent.malloc(memoryStack);
    }

    @Deprecated
    public static XResizeRequestEvent callocStack(MemoryStack memoryStack) {
        return XResizeRequestEvent.calloc(memoryStack);
    }

    @Deprecated
    public static XResizeRequestEvent$Buffer mallocStack(int n2) {
        return XResizeRequestEvent.malloc(n2, MemoryStack.stackGet());
    }

    @Deprecated
    public static XResizeRequestEvent$Buffer callocStack(int n2) {
        return XResizeRequestEvent.calloc(n2, MemoryStack.stackGet());
    }

    @Deprecated
    public static XResizeRequestEvent$Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return XResizeRequestEvent.malloc(n2, memoryStack);
    }

    @Deprecated
    public static XResizeRequestEvent$Buffer callocStack(int n2, MemoryStack memoryStack) {
        return XResizeRequestEvent.calloc(n2, memoryStack);
    }

    public static XResizeRequestEvent malloc(MemoryStack memoryStack) {
        return new XResizeRequestEvent(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XResizeRequestEvent calloc(MemoryStack memoryStack) {
        return new XResizeRequestEvent(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static XResizeRequestEvent$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new XResizeRequestEvent$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static XResizeRequestEvent$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new XResizeRequestEvent$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int ntype(long l2) {
        return UNSAFE.getInt(null, l2 + (long)TYPE);
    }

    public static long nserial(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)SERIAL);
    }

    public static int nsend_event(long l2) {
        return UNSAFE.getInt(null, l2 + (long)SEND_EVENT);
    }

    public static long ndisplay(long l2) {
        return MemoryUtil.memGetAddress(l2 + (long)DISPLAY);
    }

    public static long nwindow(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)WINDOW);
    }

    public static int nwidth(long l2) {
        return UNSAFE.getInt(null, l2 + (long)WIDTH);
    }

    public static int nheight(long l2) {
        return UNSAFE.getInt(null, l2 + (long)HEIGHT);
    }

    public static void ntype(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)TYPE, n2);
    }

    public static void nserial(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)SERIAL, l3);
    }

    public static void nsend_event(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)SEND_EVENT, n2);
    }

    public static void ndisplay(long l2, long l3) {
        MemoryUtil.memPutAddress(l2 + (long)DISPLAY, Checks.check(l3));
    }

    public static void nwindow(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)WINDOW, l3);
    }

    public static void nwidth(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)WIDTH, n2);
    }

    public static void nheight(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)HEIGHT, n2);
    }

    public static void validate(long l2) {
        Checks.check(MemoryUtil.memGetAddress(l2 + (long)DISPLAY));
    }

    static {
        Struct$Layout struct$Layout = XResizeRequestEvent.__struct(XResizeRequestEvent.__member(4), XResizeRequestEvent.__member(CLONG_SIZE), XResizeRequestEvent.__member(4), XResizeRequestEvent.__member(POINTER_SIZE), XResizeRequestEvent.__member(CLONG_SIZE), XResizeRequestEvent.__member(4), XResizeRequestEvent.__member(4));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        TYPE = struct$Layout.offsetof(0);
        SERIAL = struct$Layout.offsetof(1);
        SEND_EVENT = struct$Layout.offsetof(2);
        DISPLAY = struct$Layout.offsetof(3);
        WINDOW = struct$Layout.offsetof(4);
        WIDTH = struct$Layout.offsetof(5);
        HEIGHT = struct$Layout.offsetof(6);
    }
}

