/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux.liburing;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.linux.liburing.IOCQRingOffsets$Buffer;

@NativeType(value="struct io_cqring_offsets")
public class IOCQRingOffsets
extends Struct<IOCQRingOffsets>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HEAD;
    public static final int TAIL;
    public static final int RING_MASK;
    public static final int RING_ENTRIES;
    public static final int OVERFLOW;
    public static final int CQES;
    public static final int FLAGS;
    public static final int RESV1;
    public static final int USER_ADDR;

    protected IOCQRingOffsets(long l2, @Nullable ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected IOCQRingOffsets create(long l2, @Nullable ByteBuffer byteBuffer) {
        return new IOCQRingOffsets(l2, byteBuffer);
    }

    public IOCQRingOffsets(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), IOCQRingOffsets.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="__u32")
    public int head() {
        return IOCQRingOffsets.nhead(this.address());
    }

    @NativeType(value="__u32")
    public int tail() {
        return IOCQRingOffsets.ntail(this.address());
    }

    @NativeType(value="__u32")
    public int ring_mask() {
        return IOCQRingOffsets.nring_mask(this.address());
    }

    @NativeType(value="__u32")
    public int ring_entries() {
        return IOCQRingOffsets.nring_entries(this.address());
    }

    @NativeType(value="__u32")
    public int overflow() {
        return IOCQRingOffsets.noverflow(this.address());
    }

    @NativeType(value="__u32")
    public int cqes() {
        return IOCQRingOffsets.ncqes(this.address());
    }

    @NativeType(value="__u32")
    public int flags() {
        return IOCQRingOffsets.nflags(this.address());
    }

    @NativeType(value="__u64")
    public long user_addr() {
        return IOCQRingOffsets.nuser_addr(this.address());
    }

    public IOCQRingOffsets head(@NativeType(value="__u32") int n2) {
        IOCQRingOffsets.nhead(this.address(), n2);
        return this;
    }

    public IOCQRingOffsets tail(@NativeType(value="__u32") int n2) {
        IOCQRingOffsets.ntail(this.address(), n2);
        return this;
    }

    public IOCQRingOffsets ring_mask(@NativeType(value="__u32") int n2) {
        IOCQRingOffsets.nring_mask(this.address(), n2);
        return this;
    }

    public IOCQRingOffsets ring_entries(@NativeType(value="__u32") int n2) {
        IOCQRingOffsets.nring_entries(this.address(), n2);
        return this;
    }

    public IOCQRingOffsets overflow(@NativeType(value="__u32") int n2) {
        IOCQRingOffsets.noverflow(this.address(), n2);
        return this;
    }

    public IOCQRingOffsets cqes(@NativeType(value="__u32") int n2) {
        IOCQRingOffsets.ncqes(this.address(), n2);
        return this;
    }

    public IOCQRingOffsets flags(@NativeType(value="__u32") int n2) {
        IOCQRingOffsets.nflags(this.address(), n2);
        return this;
    }

    public IOCQRingOffsets user_addr(@NativeType(value="__u64") long l2) {
        IOCQRingOffsets.nuser_addr(this.address(), l2);
        return this;
    }

    public IOCQRingOffsets set(int n2, int n3, int n4, int n5, int n6, int n7, int n8, long l2) {
        this.head(n2);
        this.tail(n3);
        this.ring_mask(n4);
        this.ring_entries(n5);
        this.overflow(n6);
        this.cqes(n7);
        this.flags(n8);
        this.user_addr(l2);
        return this;
    }

    public IOCQRingOffsets set(IOCQRingOffsets iOCQRingOffsets) {
        MemoryUtil.memCopy(iOCQRingOffsets.address(), this.address(), SIZEOF);
        return this;
    }

    public static IOCQRingOffsets malloc() {
        return new IOCQRingOffsets(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static IOCQRingOffsets calloc() {
        return new IOCQRingOffsets(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static IOCQRingOffsets create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new IOCQRingOffsets(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static IOCQRingOffsets create(long l2) {
        return new IOCQRingOffsets(l2, null);
    }

    @Nullable
    public static IOCQRingOffsets createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new IOCQRingOffsets(l2, null);
    }

    public static IOCQRingOffsets$Buffer malloc(int n2) {
        return new IOCQRingOffsets$Buffer(MemoryUtil.nmemAllocChecked(IOCQRingOffsets.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static IOCQRingOffsets$Buffer calloc(int n2) {
        return new IOCQRingOffsets$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static IOCQRingOffsets$Buffer create(int n2) {
        ByteBuffer byteBuffer = IOCQRingOffsets.__create(n2, SIZEOF);
        int n3 = n2;
        return new IOCQRingOffsets$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static IOCQRingOffsets$Buffer create(long l2, int n2) {
        return new IOCQRingOffsets$Buffer(l2, n2);
    }

    @Nullable
    public static IOCQRingOffsets$Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new IOCQRingOffsets$Buffer(l2, n2);
    }

    public static IOCQRingOffsets malloc(MemoryStack memoryStack) {
        return new IOCQRingOffsets(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static IOCQRingOffsets calloc(MemoryStack memoryStack) {
        return new IOCQRingOffsets(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static IOCQRingOffsets$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new IOCQRingOffsets$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static IOCQRingOffsets$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new IOCQRingOffsets$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int nhead(long l2) {
        return UNSAFE.getInt(null, l2 + (long)HEAD);
    }

    public static int ntail(long l2) {
        return UNSAFE.getInt(null, l2 + (long)TAIL);
    }

    public static int nring_mask(long l2) {
        return UNSAFE.getInt(null, l2 + (long)RING_MASK);
    }

    public static int nring_entries(long l2) {
        return UNSAFE.getInt(null, l2 + (long)RING_ENTRIES);
    }

    public static int noverflow(long l2) {
        return UNSAFE.getInt(null, l2 + (long)OVERFLOW);
    }

    public static int ncqes(long l2) {
        return UNSAFE.getInt(null, l2 + (long)CQES);
    }

    public static int nflags(long l2) {
        return UNSAFE.getInt(null, l2 + (long)FLAGS);
    }

    public static int nresv1(long l2) {
        return UNSAFE.getInt(null, l2 + (long)RESV1);
    }

    public static long nuser_addr(long l2) {
        return UNSAFE.getLong(null, l2 + (long)USER_ADDR);
    }

    public static void nhead(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)HEAD, n2);
    }

    public static void ntail(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)TAIL, n2);
    }

    public static void nring_mask(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)RING_MASK, n2);
    }

    public static void nring_entries(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)RING_ENTRIES, n2);
    }

    public static void noverflow(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)OVERFLOW, n2);
    }

    public static void ncqes(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)CQES, n2);
    }

    public static void nflags(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)FLAGS, n2);
    }

    public static void nresv1(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)RESV1, n2);
    }

    public static void nuser_addr(long l2, long l3) {
        UNSAFE.putLong(null, l2 + (long)USER_ADDR, l3);
    }

    static {
        Struct$Layout struct$Layout = IOCQRingOffsets.__struct(IOCQRingOffsets.__member(4), IOCQRingOffsets.__member(4), IOCQRingOffsets.__member(4), IOCQRingOffsets.__member(4), IOCQRingOffsets.__member(4), IOCQRingOffsets.__member(4), IOCQRingOffsets.__member(4), IOCQRingOffsets.__member(4), IOCQRingOffsets.__member(8));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        HEAD = struct$Layout.offsetof(0);
        TAIL = struct$Layout.offsetof(1);
        RING_MASK = struct$Layout.offsetof(2);
        RING_ENTRIES = struct$Layout.offsetof(3);
        OVERFLOW = struct$Layout.offsetof(4);
        CQES = struct$Layout.offsetof(5);
        FLAGS = struct$Layout.offsetof(6);
        RESV1 = struct$Layout.offsetof(7);
        USER_ADDR = struct$Layout.offsetof(8);
    }
}

