/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux.liburing;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.linux.liburing.IOSQRingOffsets$Buffer;

@NativeType(value="struct io_sqring_offsets")
public class IOSQRingOffsets
extends Struct<IOSQRingOffsets>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int HEAD;
    public static final int TAIL;
    public static final int RING_MASK;
    public static final int RING_ENTRIES;
    public static final int FLAGS;
    public static final int DROPPED;
    public static final int ARRAY;
    public static final int RESV1;
    public static final int USER_ADDR;

    protected IOSQRingOffsets(long l2, @Nullable ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected IOSQRingOffsets create(long l2, @Nullable ByteBuffer byteBuffer) {
        return new IOSQRingOffsets(l2, byteBuffer);
    }

    public IOSQRingOffsets(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), IOSQRingOffsets.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="__u32")
    public int head() {
        return IOSQRingOffsets.nhead(this.address());
    }

    @NativeType(value="__u32")
    public int tail() {
        return IOSQRingOffsets.ntail(this.address());
    }

    @NativeType(value="__u32")
    public int ring_mask() {
        return IOSQRingOffsets.nring_mask(this.address());
    }

    @NativeType(value="__u32")
    public int ring_entries() {
        return IOSQRingOffsets.nring_entries(this.address());
    }

    @NativeType(value="__u32")
    public int flags() {
        return IOSQRingOffsets.nflags(this.address());
    }

    @NativeType(value="__u32")
    public int dropped() {
        return IOSQRingOffsets.ndropped(this.address());
    }

    @NativeType(value="__u32")
    public int array() {
        return IOSQRingOffsets.narray(this.address());
    }

    @NativeType(value="__u64")
    public long user_addr() {
        return IOSQRingOffsets.nuser_addr(this.address());
    }

    public IOSQRingOffsets head(@NativeType(value="__u32") int n2) {
        IOSQRingOffsets.nhead(this.address(), n2);
        return this;
    }

    public IOSQRingOffsets tail(@NativeType(value="__u32") int n2) {
        IOSQRingOffsets.ntail(this.address(), n2);
        return this;
    }

    public IOSQRingOffsets ring_mask(@NativeType(value="__u32") int n2) {
        IOSQRingOffsets.nring_mask(this.address(), n2);
        return this;
    }

    public IOSQRingOffsets ring_entries(@NativeType(value="__u32") int n2) {
        IOSQRingOffsets.nring_entries(this.address(), n2);
        return this;
    }

    public IOSQRingOffsets flags(@NativeType(value="__u32") int n2) {
        IOSQRingOffsets.nflags(this.address(), n2);
        return this;
    }

    public IOSQRingOffsets dropped(@NativeType(value="__u32") int n2) {
        IOSQRingOffsets.ndropped(this.address(), n2);
        return this;
    }

    public IOSQRingOffsets array(@NativeType(value="__u32") int n2) {
        IOSQRingOffsets.narray(this.address(), n2);
        return this;
    }

    public IOSQRingOffsets user_addr(@NativeType(value="__u64") long l2) {
        IOSQRingOffsets.nuser_addr(this.address(), l2);
        return this;
    }

    public IOSQRingOffsets set(int n2, int n3, int n4, int n5, int n6, int n7, int n8, long l2) {
        this.head(n2);
        this.tail(n3);
        this.ring_mask(n4);
        this.ring_entries(n5);
        this.flags(n6);
        this.dropped(n7);
        this.array(n8);
        this.user_addr(l2);
        return this;
    }

    public IOSQRingOffsets set(IOSQRingOffsets iOSQRingOffsets) {
        MemoryUtil.memCopy(iOSQRingOffsets.address(), this.address(), SIZEOF);
        return this;
    }

    public static IOSQRingOffsets malloc() {
        return new IOSQRingOffsets(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static IOSQRingOffsets calloc() {
        return new IOSQRingOffsets(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static IOSQRingOffsets create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new IOSQRingOffsets(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static IOSQRingOffsets create(long l2) {
        return new IOSQRingOffsets(l2, null);
    }

    @Nullable
    public static IOSQRingOffsets createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new IOSQRingOffsets(l2, null);
    }

    public static IOSQRingOffsets$Buffer malloc(int n2) {
        return new IOSQRingOffsets$Buffer(MemoryUtil.nmemAllocChecked(IOSQRingOffsets.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static IOSQRingOffsets$Buffer calloc(int n2) {
        return new IOSQRingOffsets$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static IOSQRingOffsets$Buffer create(int n2) {
        ByteBuffer byteBuffer = IOSQRingOffsets.__create(n2, SIZEOF);
        int n3 = n2;
        return new IOSQRingOffsets$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static IOSQRingOffsets$Buffer create(long l2, int n2) {
        return new IOSQRingOffsets$Buffer(l2, n2);
    }

    @Nullable
    public static IOSQRingOffsets$Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new IOSQRingOffsets$Buffer(l2, n2);
    }

    public static IOSQRingOffsets malloc(MemoryStack memoryStack) {
        return new IOSQRingOffsets(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static IOSQRingOffsets calloc(MemoryStack memoryStack) {
        return new IOSQRingOffsets(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static IOSQRingOffsets$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new IOSQRingOffsets$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static IOSQRingOffsets$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new IOSQRingOffsets$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int nhead(long l2) {
        return UNSAFE.getInt(null, l2 + (long)HEAD);
    }

    public static int ntail(long l2) {
        return UNSAFE.getInt(null, l2 + (long)TAIL);
    }

    public static int nring_mask(long l2) {
        return UNSAFE.getInt(null, l2 + (long)RING_MASK);
    }

    public static int nring_entries(long l2) {
        return UNSAFE.getInt(null, l2 + (long)RING_ENTRIES);
    }

    public static int nflags(long l2) {
        return UNSAFE.getInt(null, l2 + (long)FLAGS);
    }

    public static int ndropped(long l2) {
        return UNSAFE.getInt(null, l2 + (long)DROPPED);
    }

    public static int narray(long l2) {
        return UNSAFE.getInt(null, l2 + (long)ARRAY);
    }

    public static int nresv1(long l2) {
        return UNSAFE.getInt(null, l2 + (long)RESV1);
    }

    public static long nuser_addr(long l2) {
        return UNSAFE.getLong(null, l2 + (long)USER_ADDR);
    }

    public static void nhead(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)HEAD, n2);
    }

    public static void ntail(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)TAIL, n2);
    }

    public static void nring_mask(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)RING_MASK, n2);
    }

    public static void nring_entries(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)RING_ENTRIES, n2);
    }

    public static void nflags(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)FLAGS, n2);
    }

    public static void ndropped(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)DROPPED, n2);
    }

    public static void narray(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)ARRAY, n2);
    }

    public static void nresv1(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)RESV1, n2);
    }

    public static void nuser_addr(long l2, long l3) {
        UNSAFE.putLong(null, l2 + (long)USER_ADDR, l3);
    }

    static {
        Struct$Layout struct$Layout = IOSQRingOffsets.__struct(IOSQRingOffsets.__member(4), IOSQRingOffsets.__member(4), IOSQRingOffsets.__member(4), IOSQRingOffsets.__member(4), IOSQRingOffsets.__member(4), IOSQRingOffsets.__member(4), IOSQRingOffsets.__member(4), IOSQRingOffsets.__member(4), IOSQRingOffsets.__member(8));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        HEAD = struct$Layout.offsetof(0);
        TAIL = struct$Layout.offsetof(1);
        RING_MASK = struct$Layout.offsetof(2);
        RING_ENTRIES = struct$Layout.offsetof(3);
        FLAGS = struct$Layout.offsetof(4);
        DROPPED = struct$Layout.offsetof(5);
        ARRAY = struct$Layout.offsetof(6);
        RESV1 = struct$Layout.offsetof(7);
        USER_ADDR = struct$Layout.offsetof(8);
    }
}

