/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux.liburing;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.linux.liburing.IOURingBufStatus$Buffer;

@NativeType(value="struct io_uring_buf_status")
public class IOURingBufStatus
extends Struct<IOURingBufStatus>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BUF_GROUP;
    public static final int HEAD;
    public static final int RESV;

    protected IOURingBufStatus(long l2, @Nullable ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected IOURingBufStatus create(long l2, @Nullable ByteBuffer byteBuffer) {
        return new IOURingBufStatus(l2, byteBuffer);
    }

    public IOURingBufStatus(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), IOURingBufStatus.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="__u32")
    public int buf_group() {
        return IOURingBufStatus.nbuf_group(this.address());
    }

    @NativeType(value="__u32")
    public int head() {
        return IOURingBufStatus.nhead(this.address());
    }

    public IOURingBufStatus buf_group(@NativeType(value="__u32") int n2) {
        IOURingBufStatus.nbuf_group(this.address(), n2);
        return this;
    }

    public IOURingBufStatus head(@NativeType(value="__u32") int n2) {
        IOURingBufStatus.nhead(this.address(), n2);
        return this;
    }

    public IOURingBufStatus set(int n2, int n3) {
        this.buf_group(n2);
        this.head(n3);
        return this;
    }

    public IOURingBufStatus set(IOURingBufStatus iOURingBufStatus) {
        MemoryUtil.memCopy(iOURingBufStatus.address(), this.address(), SIZEOF);
        return this;
    }

    public static IOURingBufStatus malloc() {
        return new IOURingBufStatus(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static IOURingBufStatus calloc() {
        return new IOURingBufStatus(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static IOURingBufStatus create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new IOURingBufStatus(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static IOURingBufStatus create(long l2) {
        return new IOURingBufStatus(l2, null);
    }

    @Nullable
    public static IOURingBufStatus createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new IOURingBufStatus(l2, null);
    }

    public static IOURingBufStatus$Buffer malloc(int n2) {
        return new IOURingBufStatus$Buffer(MemoryUtil.nmemAllocChecked(IOURingBufStatus.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static IOURingBufStatus$Buffer calloc(int n2) {
        return new IOURingBufStatus$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static IOURingBufStatus$Buffer create(int n2) {
        ByteBuffer byteBuffer = IOURingBufStatus.__create(n2, SIZEOF);
        int n3 = n2;
        return new IOURingBufStatus$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static IOURingBufStatus$Buffer create(long l2, int n2) {
        return new IOURingBufStatus$Buffer(l2, n2);
    }

    @Nullable
    public static IOURingBufStatus$Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new IOURingBufStatus$Buffer(l2, n2);
    }

    public static IOURingBufStatus malloc(MemoryStack memoryStack) {
        return new IOURingBufStatus(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static IOURingBufStatus calloc(MemoryStack memoryStack) {
        return new IOURingBufStatus(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static IOURingBufStatus$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new IOURingBufStatus$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static IOURingBufStatus$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new IOURingBufStatus$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int nbuf_group(long l2) {
        return UNSAFE.getInt(null, l2 + (long)BUF_GROUP);
    }

    public static int nhead(long l2) {
        return UNSAFE.getInt(null, l2 + (long)HEAD);
    }

    public static IntBuffer nresv(long l2) {
        return MemoryUtil.memIntBuffer(l2 + (long)RESV, 8);
    }

    public static int nresv(long l2, int n2) {
        return UNSAFE.getInt(null, l2 + (long)RESV + (Checks.check(n2, 8) << 2));
    }

    public static void nbuf_group(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)BUF_GROUP, n2);
    }

    public static void nhead(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)HEAD, n2);
    }

    public static void nresv(long l2, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.checkGT(intBuffer, 8);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(intBuffer), l2 + (long)RESV, intBuffer.remaining() << 2);
    }

    public static void nresv(long l2, int n2, int n3) {
        UNSAFE.putInt(null, l2 + (long)RESV + (Checks.check(n2, 8) << 2), n3);
    }

    static {
        Struct$Layout struct$Layout = IOURingBufStatus.__struct(IOURingBufStatus.__member(4), IOURingBufStatus.__member(4), IOURingBufStatus.__array(4, 8));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        BUF_GROUP = struct$Layout.offsetof(0);
        HEAD = struct$Layout.offsetof(1);
        RESV = struct$Layout.offsetof(2);
    }
}

