/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux.liburing;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.linux.liburing.IOURingProbeOp$Buffer;

@NativeType(value="struct io_uring_probe_op")
public class IOURingProbeOp
extends Struct<IOURingProbeOp>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int OP;
    public static final int RESV;
    public static final int FLAGS;
    public static final int RESV2;

    protected IOURingProbeOp(long l2, @Nullable ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected IOURingProbeOp create(long l2, @Nullable ByteBuffer byteBuffer) {
        return new IOURingProbeOp(l2, byteBuffer);
    }

    public IOURingProbeOp(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), IOURingProbeOp.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="__u8")
    public byte op() {
        return IOURingProbeOp.nop(this.address());
    }

    @NativeType(value="__u16")
    public short flags() {
        return IOURingProbeOp.nflags(this.address());
    }

    public IOURingProbeOp op(@NativeType(value="__u8") byte by) {
        IOURingProbeOp.nop(this.address(), by);
        return this;
    }

    public IOURingProbeOp flags(@NativeType(value="__u16") short s2) {
        IOURingProbeOp.nflags(this.address(), s2);
        return this;
    }

    public IOURingProbeOp set(byte by, short s2) {
        this.op(by);
        this.flags(s2);
        return this;
    }

    public IOURingProbeOp set(IOURingProbeOp iOURingProbeOp) {
        MemoryUtil.memCopy(iOURingProbeOp.address(), this.address(), SIZEOF);
        return this;
    }

    public static IOURingProbeOp malloc() {
        return new IOURingProbeOp(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static IOURingProbeOp calloc() {
        return new IOURingProbeOp(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static IOURingProbeOp create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new IOURingProbeOp(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static IOURingProbeOp create(long l2) {
        return new IOURingProbeOp(l2, null);
    }

    @Nullable
    public static IOURingProbeOp createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new IOURingProbeOp(l2, null);
    }

    public static IOURingProbeOp$Buffer malloc(int n2) {
        return new IOURingProbeOp$Buffer(MemoryUtil.nmemAllocChecked(IOURingProbeOp.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static IOURingProbeOp$Buffer calloc(int n2) {
        return new IOURingProbeOp$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static IOURingProbeOp$Buffer create(int n2) {
        ByteBuffer byteBuffer = IOURingProbeOp.__create(n2, SIZEOF);
        int n3 = n2;
        return new IOURingProbeOp$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static IOURingProbeOp$Buffer create(long l2, int n2) {
        return new IOURingProbeOp$Buffer(l2, n2);
    }

    @Nullable
    public static IOURingProbeOp$Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new IOURingProbeOp$Buffer(l2, n2);
    }

    public static IOURingProbeOp malloc(MemoryStack memoryStack) {
        return new IOURingProbeOp(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static IOURingProbeOp calloc(MemoryStack memoryStack) {
        return new IOURingProbeOp(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static IOURingProbeOp$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new IOURingProbeOp$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static IOURingProbeOp$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new IOURingProbeOp$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static byte nop(long l2) {
        return UNSAFE.getByte(null, l2 + (long)OP);
    }

    public static byte nresv(long l2) {
        return UNSAFE.getByte(null, l2 + (long)RESV);
    }

    public static short nflags(long l2) {
        return UNSAFE.getShort(null, l2 + (long)FLAGS);
    }

    public static int nresv2(long l2) {
        return UNSAFE.getInt(null, l2 + (long)RESV2);
    }

    public static void nop(long l2, byte by) {
        UNSAFE.putByte(null, l2 + (long)OP, by);
    }

    public static void nresv(long l2, byte by) {
        UNSAFE.putByte(null, l2 + (long)RESV, by);
    }

    public static void nflags(long l2, short s2) {
        UNSAFE.putShort(null, l2 + (long)FLAGS, s2);
    }

    public static void nresv2(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)RESV2, n2);
    }

    static {
        Struct$Layout struct$Layout = IOURingProbeOp.__struct(IOURingProbeOp.__member(1), IOURingProbeOp.__member(1), IOURingProbeOp.__member(2), IOURingProbeOp.__member(4));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        OP = struct$Layout.offsetof(0);
        RESV = struct$Layout.offsetof(1);
        FLAGS = struct$Layout.offsetof(2);
        RESV2 = struct$Layout.offsetof(3);
    }
}

