/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux.liburing;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.linux.liburing.IOURingRestriction$Buffer;

@NativeType(value="struct io_uring_restriction")
public class IOURingRestriction
extends Struct<IOURingRestriction>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int OPCODE;
    public static final int REGISTER_OP;
    public static final int SQE_OP;
    public static final int SQE_FLAGS;
    public static final int RESV;
    public static final int RESV2;

    protected IOURingRestriction(long l2, @Nullable ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected IOURingRestriction create(long l2, @Nullable ByteBuffer byteBuffer) {
        return new IOURingRestriction(l2, byteBuffer);
    }

    public IOURingRestriction(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), IOURingRestriction.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="__u16")
    public short opcode() {
        return IOURingRestriction.nopcode(this.address());
    }

    @NativeType(value="__u8")
    public byte register_op() {
        return IOURingRestriction.nregister_op(this.address());
    }

    @NativeType(value="__u8")
    public byte sqe_op() {
        return IOURingRestriction.nsqe_op(this.address());
    }

    @NativeType(value="__u8")
    public byte sqe_flags() {
        return IOURingRestriction.nsqe_flags(this.address());
    }

    public IOURingRestriction opcode(@NativeType(value="__u16") short s2) {
        IOURingRestriction.nopcode(this.address(), s2);
        return this;
    }

    public IOURingRestriction register_op(@NativeType(value="__u8") byte by) {
        IOURingRestriction.nregister_op(this.address(), by);
        return this;
    }

    public IOURingRestriction sqe_op(@NativeType(value="__u8") byte by) {
        IOURingRestriction.nsqe_op(this.address(), by);
        return this;
    }

    public IOURingRestriction sqe_flags(@NativeType(value="__u8") byte by) {
        IOURingRestriction.nsqe_flags(this.address(), by);
        return this;
    }

    public IOURingRestriction set(IOURingRestriction iOURingRestriction) {
        MemoryUtil.memCopy(iOURingRestriction.address(), this.address(), SIZEOF);
        return this;
    }

    public static IOURingRestriction malloc() {
        return new IOURingRestriction(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static IOURingRestriction calloc() {
        return new IOURingRestriction(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static IOURingRestriction create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new IOURingRestriction(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static IOURingRestriction create(long l2) {
        return new IOURingRestriction(l2, null);
    }

    @Nullable
    public static IOURingRestriction createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new IOURingRestriction(l2, null);
    }

    public static IOURingRestriction$Buffer malloc(int n2) {
        return new IOURingRestriction$Buffer(MemoryUtil.nmemAllocChecked(IOURingRestriction.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static IOURingRestriction$Buffer calloc(int n2) {
        return new IOURingRestriction$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static IOURingRestriction$Buffer create(int n2) {
        ByteBuffer byteBuffer = IOURingRestriction.__create(n2, SIZEOF);
        int n3 = n2;
        return new IOURingRestriction$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static IOURingRestriction$Buffer create(long l2, int n2) {
        return new IOURingRestriction$Buffer(l2, n2);
    }

    @Nullable
    public static IOURingRestriction$Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new IOURingRestriction$Buffer(l2, n2);
    }

    public static IOURingRestriction malloc(MemoryStack memoryStack) {
        return new IOURingRestriction(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static IOURingRestriction calloc(MemoryStack memoryStack) {
        return new IOURingRestriction(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static IOURingRestriction$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new IOURingRestriction$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static IOURingRestriction$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new IOURingRestriction$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static short nopcode(long l2) {
        return UNSAFE.getShort(null, l2 + (long)OPCODE);
    }

    public static byte nregister_op(long l2) {
        return UNSAFE.getByte(null, l2 + (long)REGISTER_OP);
    }

    public static byte nsqe_op(long l2) {
        return UNSAFE.getByte(null, l2 + (long)SQE_OP);
    }

    public static byte nsqe_flags(long l2) {
        return UNSAFE.getByte(null, l2 + (long)SQE_FLAGS);
    }

    public static byte nresv(long l2) {
        return UNSAFE.getByte(null, l2 + (long)RESV);
    }

    public static IntBuffer nresv2(long l2) {
        return MemoryUtil.memIntBuffer(l2 + (long)RESV2, 3);
    }

    public static int nresv2(long l2, int n2) {
        return UNSAFE.getInt(null, l2 + (long)RESV2 + (Checks.check(n2, 3) << 2));
    }

    public static void nopcode(long l2, short s2) {
        UNSAFE.putShort(null, l2 + (long)OPCODE, s2);
    }

    public static void nregister_op(long l2, byte by) {
        UNSAFE.putByte(null, l2 + (long)REGISTER_OP, by);
    }

    public static void nsqe_op(long l2, byte by) {
        UNSAFE.putByte(null, l2 + (long)SQE_OP, by);
    }

    public static void nsqe_flags(long l2, byte by) {
        UNSAFE.putByte(null, l2 + (long)SQE_FLAGS, by);
    }

    public static void nresv(long l2, byte by) {
        UNSAFE.putByte(null, l2 + (long)RESV, by);
    }

    public static void nresv2(long l2, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.checkGT(intBuffer, 3);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(intBuffer), l2 + (long)RESV2, intBuffer.remaining() << 2);
    }

    public static void nresv2(long l2, int n2, int n3) {
        UNSAFE.putInt(null, l2 + (long)RESV2 + (Checks.check(n2, 3) << 2), n3);
    }

    static {
        Struct$Layout struct$Layout = IOURingRestriction.__struct(IOURingRestriction.__member(2), IOURingRestriction.__union(IOURingRestriction.__member(1), IOURingRestriction.__member(1), IOURingRestriction.__member(1)), IOURingRestriction.__member(1), IOURingRestriction.__array(4, 3));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        OPCODE = struct$Layout.offsetof(0);
        REGISTER_OP = struct$Layout.offsetof(2);
        SQE_OP = struct$Layout.offsetof(3);
        SQE_FLAGS = struct$Layout.offsetof(4);
        RESV = struct$Layout.offsetof(5);
        RESV2 = struct$Layout.offsetof(6);
    }
}

