/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.macosx;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer$Default;
import org.lwjgl.system.SharedLibrary;
import org.lwjgl.system.Struct;
import org.lwjgl.system.libc.LibCStdlib;
import org.lwjgl.system.macosx.EnumerationMutationHandlerI;
import org.lwjgl.system.macosx.ObjCMethodDescription;
import org.lwjgl.system.macosx.ObjCMethodDescription$Buffer;
import org.lwjgl.system.macosx.ObjCPropertyAttribute;
import org.lwjgl.system.macosx.ObjCPropertyAttribute$Buffer;
import org.lwjgl.system.macosx.ObjCRuntime$Functions;

public class ObjCRuntime {
    private static final SharedLibrary OBJC = Library.loadNative(ObjCRuntime.class, "org.lwjgl", "objc");
    public static final long nil = 0L;
    public static final byte YES = 1;
    public static final byte NO = 0;
    public static final char _C_ID = '@';
    public static final char _C_CLASS = '#';
    public static final char _C_SEL = ':';
    public static final char _C_CHR = 'c';
    public static final char _C_UCHR = 'C';
    public static final char _C_SHT = 's';
    public static final char _C_USHT = 'S';
    public static final char _C_INT = 'i';
    public static final char _C_UINT = 'I';
    public static final char _C_LNG = 'l';
    public static final char _C_ULNG = 'L';
    public static final char _C_LNG_LNG = 'q';
    public static final char _C_ULNG_LNG = 'Q';
    public static final char _C_FLT = 'f';
    public static final char _C_DBL = 'd';
    public static final char _C_BFLD = 'b';
    public static final char _C_BOOL = 'B';
    public static final char _C_VOID = 'v';
    public static final char _C_UNDEF = '?';
    public static final char _C_PTR = '^';
    public static final char _C_CHARPTR = '*';
    public static final char _C_ATOM = '%';
    public static final char _C_ARY_B = '[';
    public static final char _C_ARY_E = ']';
    public static final char _C_UNION_B = '(';
    public static final char _C_UNION_E = ')';
    public static final char _C_STRUCT_B = '{';
    public static final char _C_STRUCT_E = '}';
    public static final char _C_VECTOR = '!';
    public static final char _C_CONST = 'r';
    public static final int OBJC_ASSOCIATION_ASSIGN = 0;
    public static final int OBJC_ASSOCIATION_RETAIN_NONATOMIC = 1;
    public static final int OBJC_ASSOCIATION_COPY_NONATOMIC = 3;
    public static final int OBJC_ASSOCIATION_RETAIN = 1401;
    public static final int OBJC_ASSOCIATION_COPY = 1403;

    public static SharedLibrary getLibrary() {
        return OBJC;
    }

    protected ObjCRuntime() {
        throw new UnsupportedOperationException();
    }

    @NativeType(value="id")
    public static long object_copy(@NativeType(value="id") long l2, @NativeType(value="size_t") long l3) {
        long l4 = ObjCRuntime$Functions.object_copy;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePPP(l2, l3, l4);
    }

    @NativeType(value="id")
    public static long object_dispose(@NativeType(value="id") long l2) {
        long l3 = ObjCRuntime$Functions.object_dispose;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    @NativeType(value="Class")
    public static long object_getClass(@NativeType(value="id") long l2) {
        long l3 = ObjCRuntime$Functions.object_getClass;
        return JNI.invokePP(l2, l3);
    }

    @NativeType(value="Class")
    public static long object_setClass(@NativeType(value="id") long l2, @NativeType(value="Class") long l3) {
        long l4 = ObjCRuntime$Functions.object_setClass;
        if (Checks.CHECKS) {
            Checks.check(l3);
        }
        return JNI.invokePPP(l2, l3, l4);
    }

    public static long nobject_getClassName(long l2) {
        long l3 = ObjCRuntime$Functions.object_getClassName;
        return JNI.invokePP(l2, l3);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String object_getClassName(@NativeType(value="id") long l2) {
        long l3 = ObjCRuntime.nobject_getClassName(l2);
        return MemoryUtil.memUTF8Safe(l3);
    }

    @NativeType(value="void *")
    public static long object_getIndexedIvars(@NativeType(value="id") long l2) {
        long l3 = ObjCRuntime$Functions.object_getIndexedIvars;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    @NativeType(value="id")
    public static long object_getIvar(@NativeType(value="id") long l2, @NativeType(value="Ivar") long l3) {
        long l4 = ObjCRuntime$Functions.object_getIvar;
        if (Checks.CHECKS) {
            Checks.check(l3);
        }
        return JNI.invokePPP(l2, l3, l4);
    }

    public static void object_setIvar(@NativeType(value="id") long l2, @NativeType(value="Ivar") long l3, @NativeType(value="id") long l4) {
        long l5 = ObjCRuntime$Functions.object_setIvar;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
            Checks.check(l4);
        }
        JNI.invokePPPV(l2, l3, l4, l5);
    }

    public static long nobject_setInstanceVariable(long l2, long l3, long l4) {
        long l5 = ObjCRuntime$Functions.object_setInstanceVariable;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePPPP(l2, l3, l4, l5);
    }

    @NativeType(value="Ivar")
    public static long object_setInstanceVariable(@NativeType(value="id") long l2, @NativeType(value="char const *") ByteBuffer byteBuffer, @NativeType(value="void *") ByteBuffer byteBuffer2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return ObjCRuntime.nobject_setInstanceVariable(l2, MemoryUtil.memAddress(byteBuffer), MemoryUtil.memAddress(byteBuffer2));
    }

    @NativeType(value="Ivar")
    public static long object_setInstanceVariable(@NativeType(value="id") long l2, @NativeType(value="char const *") CharSequence charSequence, @NativeType(value="void *") ByteBuffer byteBuffer) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l3 = memoryStack.getPointerAddress();
            long l4 = ObjCRuntime.nobject_setInstanceVariable(l2, l3, MemoryUtil.memAddress(byteBuffer));
            return l4;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nobject_getInstanceVariable(long l2, long l3, long l4) {
        long l5 = ObjCRuntime$Functions.object_getInstanceVariable;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePPPP(l2, l3, l4, l5);
    }

    @NativeType(value="Ivar")
    public static long object_getInstanceVariable(@NativeType(value="id") long l2, @NativeType(value="char const *") ByteBuffer byteBuffer, @NativeType(value="void **") PointerBuffer pointerBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
            Checks.check(pointerBuffer, 1);
        }
        return ObjCRuntime.nobject_getInstanceVariable(l2, MemoryUtil.memAddress(byteBuffer), MemoryUtil.memAddress(pointerBuffer));
    }

    @NativeType(value="Ivar")
    public static long object_getInstanceVariable(@NativeType(value="id") long l2, @NativeType(value="char const *") CharSequence charSequence, @NativeType(value="void **") PointerBuffer pointerBuffer) {
        if (Checks.CHECKS) {
            Checks.check(pointerBuffer, 1);
        }
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l3 = memoryStack.getPointerAddress();
            long l4 = ObjCRuntime.nobject_getInstanceVariable(l2, l3, MemoryUtil.memAddress(pointerBuffer));
            return l4;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nobjc_getClass(long l2) {
        long l3 = ObjCRuntime$Functions.objc_getClass;
        return JNI.invokePP(l2, l3);
    }

    @NativeType(value="Class")
    public static long objc_getClass(@NativeType(value="char const *") ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return ObjCRuntime.nobjc_getClass(MemoryUtil.memAddress(byteBuffer));
    }

    @NativeType(value="Class")
    public static long objc_getClass(@NativeType(value="char const *") CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l2 = memoryStack.getPointerAddress();
            long l3 = ObjCRuntime.nobjc_getClass(l2);
            return l3;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nobjc_getMetaClass(long l2) {
        long l3 = ObjCRuntime$Functions.objc_getMetaClass;
        return JNI.invokePP(l2, l3);
    }

    @NativeType(value="Class")
    public static long objc_getMetaClass(@NativeType(value="char const *") ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return ObjCRuntime.nobjc_getMetaClass(MemoryUtil.memAddress(byteBuffer));
    }

    @NativeType(value="Class")
    public static long objc_getMetaClass(@NativeType(value="char const *") CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l2 = memoryStack.getPointerAddress();
            long l3 = ObjCRuntime.nobjc_getMetaClass(l2);
            return l3;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nobjc_lookUpClass(long l2) {
        long l3 = ObjCRuntime$Functions.objc_lookUpClass;
        return JNI.invokePP(l2, l3);
    }

    @NativeType(value="Class")
    public static long objc_lookUpClass(@NativeType(value="char const *") ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return ObjCRuntime.nobjc_lookUpClass(MemoryUtil.memAddress(byteBuffer));
    }

    @NativeType(value="Class")
    public static long objc_lookUpClass(@NativeType(value="char const *") CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l2 = memoryStack.getPointerAddress();
            long l3 = ObjCRuntime.nobjc_lookUpClass(l2);
            return l3;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nobjc_getRequiredClass(long l2) {
        long l3 = ObjCRuntime$Functions.objc_getRequiredClass;
        return JNI.invokePP(l2, l3);
    }

    @NativeType(value="Class")
    public static long objc_getRequiredClass(@NativeType(value="char const *") ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return ObjCRuntime.nobjc_getRequiredClass(MemoryUtil.memAddress(byteBuffer));
    }

    @NativeType(value="Class")
    public static long objc_getRequiredClass(@NativeType(value="char const *") CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l2 = memoryStack.getPointerAddress();
            long l3 = ObjCRuntime.nobjc_getRequiredClass(l2);
            return l3;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static int nobjc_getClassList(long l2, int n2) {
        long l3 = ObjCRuntime$Functions.objc_getClassList;
        return JNI.invokePI(l2, n2, l3);
    }

    public static int objc_getClassList(@Nullable @NativeType(value="Class *") PointerBuffer pointerBuffer) {
        return ObjCRuntime.nobjc_getClassList(MemoryUtil.memAddressSafe(pointerBuffer), Checks.remainingSafe(pointerBuffer));
    }

    public static long nobjc_copyClassList(long l2) {
        long l3 = ObjCRuntime$Functions.objc_copyClassList;
        return JNI.invokePP(l2, l3);
    }

    @Nullable
    @NativeType(value="Class *")
    public static PointerBuffer objc_copyClassList() {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        Comparable<IntBuffer> comparable = memoryStack.callocInt(1);
        try {
            long l2 = ObjCRuntime.nobjc_copyClassList(MemoryUtil.memAddress(comparable));
            comparable = MemoryUtil.memPointerBufferSafe(l2, comparable.get(0));
            return comparable;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nclass_getName(long l2) {
        long l3 = ObjCRuntime$Functions.class_getName;
        return JNI.invokePP(l2, l3);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String class_getName(@NativeType(value="Class") long l2) {
        long l3 = ObjCRuntime.nclass_getName(l2);
        return MemoryUtil.memUTF8Safe(l3);
    }

    @NativeType(value="BOOL")
    public static boolean class_isMetaClass(@NativeType(value="Class") long l2) {
        long l3 = ObjCRuntime$Functions.class_isMetaClass;
        return JNI.invokePZ(l2, l3);
    }

    @NativeType(value="Class")
    public static long class_getSuperclass(@NativeType(value="Class") long l2) {
        long l3 = ObjCRuntime$Functions.class_getSuperclass;
        return JNI.invokePP(l2, l3);
    }

    public static int class_getVersion(@NativeType(value="Class") long l2) {
        long l3 = ObjCRuntime$Functions.class_getVersion;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePI(l2, l3);
    }

    public static void class_setVersion(@NativeType(value="Class") long l2, int n2) {
        long l3 = ObjCRuntime$Functions.class_setVersion;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.invokePV(l2, n2, l3);
    }

    @NativeType(value="size_t")
    public static long class_getInstanceSize(@NativeType(value="Class") long l2) {
        long l3 = ObjCRuntime$Functions.class_getInstanceSize;
        return JNI.invokePP(l2, l3);
    }

    public static long nclass_getInstanceVariable(long l2, long l3) {
        long l4 = ObjCRuntime$Functions.class_getInstanceVariable;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePPP(l2, l3, l4);
    }

    @NativeType(value="Ivar")
    public static long class_getInstanceVariable(@NativeType(value="Class") long l2, @NativeType(value="char const *") ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return ObjCRuntime.nclass_getInstanceVariable(l2, MemoryUtil.memAddress(byteBuffer));
    }

    @NativeType(value="Ivar")
    public static long class_getInstanceVariable(@NativeType(value="Class") long l2, @NativeType(value="char const *") CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l3 = memoryStack.getPointerAddress();
            long l4 = ObjCRuntime.nclass_getInstanceVariable(l2, l3);
            return l4;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nclass_getClassVariable(long l2, long l3) {
        long l4 = ObjCRuntime$Functions.class_getClassVariable;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePPP(l2, l3, l4);
    }

    @NativeType(value="Ivar")
    public static long class_getClassVariable(@NativeType(value="Class") long l2, @NativeType(value="char const *") ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return ObjCRuntime.nclass_getClassVariable(l2, MemoryUtil.memAddress(byteBuffer));
    }

    @NativeType(value="Ivar")
    public static long class_getClassVariable(@NativeType(value="Class") long l2, @NativeType(value="char const *") CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l3 = memoryStack.getPointerAddress();
            long l4 = ObjCRuntime.nclass_getClassVariable(l2, l3);
            return l4;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nclass_copyIvarList(long l2, long l3) {
        long l4 = ObjCRuntime$Functions.class_copyIvarList;
        return JNI.invokePPP(l2, l3, l4);
    }

    @Nullable
    @NativeType(value="Ivar *")
    public static PointerBuffer class_copyIvarList(@NativeType(value="Class") long l2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        IntBuffer intBuffer = memoryStack.callocInt(1);
        try {
            long l3 = ObjCRuntime.nclass_copyIvarList(l2, MemoryUtil.memAddress(intBuffer));
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBufferSafe(l3, intBuffer.get(0));
            return pointerBuffer;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    @NativeType(value="Method")
    public static long class_getInstanceMethod(@NativeType(value="Class") long l2, @NativeType(value="SEL") long l3) {
        long l4 = ObjCRuntime$Functions.class_getInstanceMethod;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.invokePPP(l2, l3, l4);
    }

    @NativeType(value="Method")
    public static long class_getClassMethod(@NativeType(value="Class") long l2, @NativeType(value="SEL") long l3) {
        long l4 = ObjCRuntime$Functions.class_getClassMethod;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.invokePPP(l2, l3, l4);
    }

    @NativeType(value="IMP")
    public static long class_getMethodImplementation(@NativeType(value="Class") long l2, @NativeType(value="SEL") long l3) {
        long l4 = ObjCRuntime$Functions.class_getMethodImplementation;
        if (Checks.CHECKS) {
            Checks.check(l3);
        }
        return JNI.invokePPP(l2, l3, l4);
    }

    @NativeType(value="BOOL")
    public static boolean class_respondsToSelector(@NativeType(value="Class") long l2, @NativeType(value="SEL") long l3) {
        long l4 = ObjCRuntime$Functions.class_respondsToSelector;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.invokePPZ(l2, l3, l4);
    }

    public static long nclass_copyMethodList(long l2, long l3) {
        long l4 = ObjCRuntime$Functions.class_copyMethodList;
        return JNI.invokePPP(l2, l3, l4);
    }

    @Nullable
    @NativeType(value="Method *")
    public static PointerBuffer class_copyMethodList(@NativeType(value="Class") long l2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        IntBuffer intBuffer = memoryStack.callocInt(1);
        try {
            long l3 = ObjCRuntime.nclass_copyMethodList(l2, MemoryUtil.memAddress(intBuffer));
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBufferSafe(l3, intBuffer.get(0));
            return pointerBuffer;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    @NativeType(value="BOOL")
    public static boolean class_conformsToProtocol(@NativeType(value="Class") long l2, @NativeType(value="Protocol *") long l3) {
        long l4 = ObjCRuntime$Functions.class_conformsToProtocol;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.invokePPZ(l2, l3, l4);
    }

    public static long nclass_copyProtocolList(long l2, long l3) {
        long l4 = ObjCRuntime$Functions.class_copyProtocolList;
        return JNI.invokePPP(l2, l3, l4);
    }

    @Nullable
    @NativeType(value="Protocol **")
    public static PointerBuffer class_copyProtocolList(@NativeType(value="Class") long l2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        IntBuffer intBuffer = memoryStack.callocInt(1);
        try {
            long l3 = ObjCRuntime.nclass_copyProtocolList(l2, MemoryUtil.memAddress(intBuffer));
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBufferSafe(l3, intBuffer.get(0));
            return pointerBuffer;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nclass_getProperty(long l2, long l3) {
        long l4 = ObjCRuntime$Functions.class_getProperty;
        return JNI.invokePPP(l2, l3, l4);
    }

    @NativeType(value="objc_property_t")
    public static long class_getProperty(@NativeType(value="Class") long l2, @NativeType(value="char const *") ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return ObjCRuntime.nclass_getProperty(l2, MemoryUtil.memAddress(byteBuffer));
    }

    @NativeType(value="objc_property_t")
    public static long class_getProperty(@NativeType(value="Class") long l2, @NativeType(value="char const *") CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l3 = memoryStack.getPointerAddress();
            long l4 = ObjCRuntime.nclass_getProperty(l2, l3);
            return l4;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nclass_copyPropertyList(long l2, long l3) {
        long l4 = ObjCRuntime$Functions.class_copyPropertyList;
        return JNI.invokePPP(l2, l3, l4);
    }

    @Nullable
    @NativeType(value="objc_property_t *")
    public static PointerBuffer class_copyPropertyList(@NativeType(value="Class") long l2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        IntBuffer intBuffer = memoryStack.callocInt(1);
        try {
            long l3 = ObjCRuntime.nclass_copyPropertyList(l2, MemoryUtil.memAddress(intBuffer));
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBufferSafe(l3, intBuffer.get(0));
            return pointerBuffer;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nclass_getIvarLayout(long l2) {
        long l3 = ObjCRuntime$Functions.class_getIvarLayout;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    @Nullable
    @NativeType(value="uint8_t const *")
    public static String class_getIvarLayout(@NativeType(value="Class") long l2) {
        long l3 = ObjCRuntime.nclass_getIvarLayout(l2);
        return MemoryUtil.memASCIISafe(l3);
    }

    public static long nclass_getWeakIvarLayout(long l2) {
        long l3 = ObjCRuntime$Functions.class_getWeakIvarLayout;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    @Nullable
    @NativeType(value="uint8_t const *")
    public static String class_getWeakIvarLayout(@NativeType(value="Class") long l2) {
        long l3 = ObjCRuntime.nclass_getWeakIvarLayout(l2);
        return MemoryUtil.memASCIISafe(l3);
    }

    public static boolean nclass_addMethod(long l2, long l3, long l4, long l5) {
        long l6 = ObjCRuntime$Functions.class_addMethod;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
            Checks.check(l4);
        }
        return JNI.invokePPPPZ(l2, l3, l4, l5, l6);
    }

    @NativeType(value="BOOL")
    public static boolean class_addMethod(@NativeType(value="Class") long l2, @NativeType(value="SEL") long l3, @NativeType(value="IMP") long l4, @NativeType(value="char const *") ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return ObjCRuntime.nclass_addMethod(l2, l3, l4, MemoryUtil.memAddress(byteBuffer));
    }

    @NativeType(value="BOOL")
    public static boolean class_addMethod(@NativeType(value="Class") long l2, @NativeType(value="SEL") long l3, @NativeType(value="IMP") long l4, @NativeType(value="char const *") CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l5 = memoryStack.getPointerAddress();
            boolean bl = ObjCRuntime.nclass_addMethod(l2, l3, l4, l5);
            return bl;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nclass_replaceMethod(long l2, long l3, long l4, long l5) {
        long l6 = ObjCRuntime$Functions.class_replaceMethod;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
            Checks.check(l4);
        }
        return JNI.invokePPPPP(l2, l3, l4, l5, l6);
    }

    @NativeType(value="IMP")
    public static long class_replaceMethod(@NativeType(value="Class") long l2, @NativeType(value="SEL") long l3, @NativeType(value="IMP") long l4, @NativeType(value="char const *") ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return ObjCRuntime.nclass_replaceMethod(l2, l3, l4, MemoryUtil.memAddress(byteBuffer));
    }

    @NativeType(value="IMP")
    public static long class_replaceMethod(@NativeType(value="Class") long l2, @NativeType(value="SEL") long l3, @NativeType(value="IMP") long l4, @NativeType(value="char const *") CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l5 = memoryStack.getPointerAddress();
            long l6 = ObjCRuntime.nclass_replaceMethod(l2, l3, l4, l5);
            return l6;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static boolean nclass_addIvar(long l2, long l3, long l4, byte by, long l5) {
        long l6 = ObjCRuntime$Functions.class_addIvar;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePPPUPZ(l2, l3, l4, by, l5, l6);
    }

    @NativeType(value="BOOL")
    public static boolean class_addIvar(@NativeType(value="Class") long l2, @NativeType(value="char const *") ByteBuffer byteBuffer, @NativeType(value="size_t") long l3, @NativeType(value="uint8_t") byte by, @NativeType(value="char const *") ByteBuffer byteBuffer2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
            Checks.checkNT1(byteBuffer2);
        }
        return ObjCRuntime.nclass_addIvar(l2, MemoryUtil.memAddress(byteBuffer), l3, by, MemoryUtil.memAddress(byteBuffer2));
    }

    @NativeType(value="BOOL")
    public static boolean class_addIvar(@NativeType(value="Class") long l2, @NativeType(value="char const *") CharSequence charSequence, @NativeType(value="size_t") long l3, @NativeType(value="uint8_t") byte by, @NativeType(value="char const *") CharSequence charSequence2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l4 = memoryStack.getPointerAddress();
            memoryStack.nUTF8(charSequence2, true);
            long l5 = memoryStack.getPointerAddress();
            boolean bl = ObjCRuntime.nclass_addIvar(l2, l4, l3, by, l5);
            return bl;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    @NativeType(value="BOOL")
    public static boolean class_addProtocol(@NativeType(value="Class") long l2, @NativeType(value="Protocol *") long l3) {
        long l4 = ObjCRuntime$Functions.class_addProtocol;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.invokePPZ(l2, l3, l4);
    }

    public static boolean nclass_addProperty(long l2, long l3, long l4, int n2) {
        long l5 = ObjCRuntime$Functions.class_addProperty;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Struct.validate(l4, n2, ObjCPropertyAttribute.SIZEOF, ObjCPropertyAttribute::validate);
        }
        return JNI.invokePPPZ(l2, l3, l4, n2, l5);
    }

    @NativeType(value="BOOL")
    public static boolean class_addProperty(@NativeType(value="Class") long l2, @NativeType(value="char const *") ByteBuffer byteBuffer, @NativeType(value="objc_property_attribute_t const *") ObjCPropertyAttribute$Buffer objCPropertyAttribute$Buffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return ObjCRuntime.nclass_addProperty(l2, MemoryUtil.memAddress(byteBuffer), ((Pointer$Default)objCPropertyAttribute$Buffer).address(), objCPropertyAttribute$Buffer.remaining());
    }

    @NativeType(value="BOOL")
    public static boolean class_addProperty(@NativeType(value="Class") long l2, @NativeType(value="char const *") CharSequence charSequence, @NativeType(value="objc_property_attribute_t const *") ObjCPropertyAttribute$Buffer objCPropertyAttribute$Buffer) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l3 = memoryStack.getPointerAddress();
            boolean bl = ObjCRuntime.nclass_addProperty(l2, l3, ((Pointer$Default)objCPropertyAttribute$Buffer).address(), objCPropertyAttribute$Buffer.remaining());
            return bl;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static void nclass_replaceProperty(long l2, long l3, long l4, int n2) {
        long l5 = ObjCRuntime$Functions.class_replaceProperty;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Struct.validate(l4, n2, ObjCPropertyAttribute.SIZEOF, ObjCPropertyAttribute::validate);
        }
        JNI.invokePPPV(l2, l3, l4, n2, l5);
    }

    public static void class_replaceProperty(@NativeType(value="Class") long l2, @NativeType(value="char const *") ByteBuffer byteBuffer, @NativeType(value="objc_property_attribute_t const *") ObjCPropertyAttribute$Buffer objCPropertyAttribute$Buffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        ObjCRuntime.nclass_replaceProperty(l2, MemoryUtil.memAddress(byteBuffer), ((Pointer$Default)objCPropertyAttribute$Buffer).address(), objCPropertyAttribute$Buffer.remaining());
    }

    public static void class_replaceProperty(@NativeType(value="Class") long l2, @NativeType(value="char const *") CharSequence charSequence, @NativeType(value="objc_property_attribute_t const *") ObjCPropertyAttribute$Buffer objCPropertyAttribute$Buffer) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l3 = memoryStack.getPointerAddress();
            ObjCRuntime.nclass_replaceProperty(l2, l3, ((Pointer$Default)objCPropertyAttribute$Buffer).address(), objCPropertyAttribute$Buffer.remaining());
            return;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static void nclass_setIvarLayout(long l2, long l3) {
        long l4 = ObjCRuntime$Functions.class_setIvarLayout;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.invokePPV(l2, l3, l4);
    }

    public static void class_setIvarLayout(@NativeType(value="Class") long l2, @NativeType(value="uint8_t const *") ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        ObjCRuntime.nclass_setIvarLayout(l2, MemoryUtil.memAddress(byteBuffer));
    }

    public static void class_setIvarLayout(@NativeType(value="Class") long l2, @NativeType(value="uint8_t const *") CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nASCII(charSequence, true);
            long l3 = memoryStack.getPointerAddress();
            ObjCRuntime.nclass_setIvarLayout(l2, l3);
            return;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static void nclass_setWeakIvarLayout(long l2, long l3) {
        long l4 = ObjCRuntime$Functions.class_setWeakIvarLayout;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.invokePPV(l2, l3, l4);
    }

    public static void class_setWeakIvarLayout(@NativeType(value="Class") long l2, @NativeType(value="uint8_t const *") ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        ObjCRuntime.nclass_setWeakIvarLayout(l2, MemoryUtil.memAddress(byteBuffer));
    }

    public static void class_setWeakIvarLayout(@NativeType(value="Class") long l2, @NativeType(value="uint8_t const *") CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nASCII(charSequence, true);
            long l3 = memoryStack.getPointerAddress();
            ObjCRuntime.nclass_setWeakIvarLayout(l2, l3);
            return;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    @NativeType(value="id")
    public static long class_createInstance(@NativeType(value="Class") long l2, @NativeType(value="size_t") long l3) {
        long l4 = ObjCRuntime$Functions.class_createInstance;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePPP(l2, l3, l4);
    }

    public static long nobjc_constructInstance(long l2, long l3) {
        long l4 = ObjCRuntime$Functions.objc_constructInstance;
        return JNI.invokePPP(l2, l3, l4);
    }

    @NativeType(value="id")
    public static long objc_constructInstance(@NativeType(value="Class") long l2, @Nullable @NativeType(value="void *") ByteBuffer byteBuffer) {
        if (Checks.CHECKS && Checks.DEBUG) {
            Checks.checkSafe((Buffer)byteBuffer, ObjCRuntime.class_getInstanceSize(l2));
        }
        return ObjCRuntime.nobjc_constructInstance(l2, MemoryUtil.memAddressSafe(byteBuffer));
    }

    @NativeType(value="void *")
    public static long objc_destructInstance(@NativeType(value="id") long l2) {
        long l3 = ObjCRuntime$Functions.objc_destructInstance;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    public static long nobjc_allocateClassPair(long l2, long l3, long l4) {
        long l5 = ObjCRuntime$Functions.objc_allocateClassPair;
        return JNI.invokePPPP(l2, l3, l4, l5);
    }

    @NativeType(value="Class")
    public static long objc_allocateClassPair(@NativeType(value="Class") long l2, @NativeType(value="char const *") ByteBuffer byteBuffer, @NativeType(value="size_t") long l3) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return ObjCRuntime.nobjc_allocateClassPair(l2, MemoryUtil.memAddress(byteBuffer), l3);
    }

    @NativeType(value="Class")
    public static long objc_allocateClassPair(@NativeType(value="Class") long l2, @NativeType(value="char const *") CharSequence charSequence, @NativeType(value="size_t") long l3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l4 = memoryStack.getPointerAddress();
            long l5 = ObjCRuntime.nobjc_allocateClassPair(l2, l4, l3);
            return l5;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static void objc_registerClassPair(@NativeType(value="Class") long l2) {
        long l3 = ObjCRuntime$Functions.objc_registerClassPair;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.invokePV(l2, l3);
    }

    public static void objc_disposeClassPair(@NativeType(value="Class") long l2) {
        long l3 = ObjCRuntime$Functions.objc_disposeClassPair;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.invokePV(l2, l3);
    }

    @NativeType(value="SEL")
    public static long method_getName(@NativeType(value="Method") long l2) {
        long l3 = ObjCRuntime$Functions.method_getName;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    @NativeType(value="IMP")
    public static long method_getImplementation(@NativeType(value="Method") long l2) {
        long l3 = ObjCRuntime$Functions.method_getImplementation;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    public static long nmethod_getTypeEncoding(long l2) {
        long l3 = ObjCRuntime$Functions.method_getTypeEncoding;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String method_getTypeEncoding(@NativeType(value="Method") long l2) {
        long l3 = ObjCRuntime.nmethod_getTypeEncoding(l2);
        return MemoryUtil.memUTF8Safe(l3);
    }

    @NativeType(value="unsigned int")
    public static int method_getNumberOfArguments(@NativeType(value="Method") long l2) {
        long l3 = ObjCRuntime$Functions.method_getNumberOfArguments;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePI(l2, l3);
    }

    public static long nmethod_copyReturnType(long l2) {
        long l3 = ObjCRuntime$Functions.method_copyReturnType;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    @Nullable
    @NativeType(value="char *")
    public static String method_copyReturnType(@NativeType(value="Method") long l2) {
        long l3 = ObjCRuntime.nmethod_copyReturnType(l2);
        return MemoryUtil.memUTF8Safe(l3);
    }

    public static long nmethod_copyArgumentType(long l2, int n2) {
        long l3 = ObjCRuntime$Functions.method_copyArgumentType;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, n2, l3);
    }

    @Nullable
    @NativeType(value="char *")
    public static String method_copyArgumentType(@NativeType(value="Method") long l2, @NativeType(value="unsigned int") int n2) {
        long l3 = 0L;
        try {
            l3 = ObjCRuntime.nmethod_copyArgumentType(l2, n2);
            String string = MemoryUtil.memUTF8Safe(l3);
            return string;
        }
        finally {
            if (l3 != 0L) {
                LibCStdlib.nfree(l3);
            }
        }
    }

    public static void nmethod_getReturnType(long l2, long l3, long l4) {
        long l5 = ObjCRuntime$Functions.method_getReturnType;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.invokePPPV(l2, l3, l4, l5);
    }

    public static void method_getReturnType(@NativeType(value="Method") long l2, @NativeType(value="char *") ByteBuffer byteBuffer) {
        ObjCRuntime.nmethod_getReturnType(l2, MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining());
    }

    @NativeType(value="void")
    public static String method_getReturnType(@NativeType(value="Method") long l2, @NativeType(value="size_t") long l3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            ByteBuffer byteBuffer = memoryStack.malloc((int)l3);
            ObjCRuntime.nmethod_getReturnType(l2, MemoryUtil.memAddress(byteBuffer), l3);
            String string = MemoryUtil.memUTF8(MemoryUtil.memByteBufferNT1(MemoryUtil.memAddress(byteBuffer), (int)l3));
            return string;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static void nmethod_getArgumentType(long l2, int n2, long l3, long l4) {
        long l5 = ObjCRuntime$Functions.method_getArgumentType;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.invokePPPV(l2, n2, l3, l4, l5);
    }

    public static void method_getArgumentType(@NativeType(value="Method") long l2, @NativeType(value="unsigned int") int n2, @NativeType(value="char *") ByteBuffer byteBuffer) {
        ObjCRuntime.nmethod_getArgumentType(l2, n2, MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining());
    }

    @NativeType(value="void")
    public static String method_getArgumentType(@NativeType(value="Method") long l2, @NativeType(value="unsigned int") int n2, @NativeType(value="size_t") long l3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n3 = memoryStack.getPointer();
        try {
            ByteBuffer byteBuffer = memoryStack.malloc((int)l3);
            ObjCRuntime.nmethod_getArgumentType(l2, n2, MemoryUtil.memAddress(byteBuffer), l3);
            String string = MemoryUtil.memUTF8(MemoryUtil.memByteBufferNT1(MemoryUtil.memAddress(byteBuffer), (int)l3));
            return string;
        }
        finally {
            memoryStack.setPointer(n3);
        }
    }

    @NativeType(value="IMP")
    public static long method_setImplementation(@NativeType(value="Method") long l2, @NativeType(value="IMP") long l3) {
        long l4 = ObjCRuntime$Functions.method_setImplementation;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.invokePPP(l2, l3, l4);
    }

    public static void method_exchangeImplementations(@NativeType(value="Method") long l2, @NativeType(value="Method") long l3) {
        long l4 = ObjCRuntime$Functions.method_exchangeImplementations;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
        }
        JNI.invokePPV(l2, l3, l4);
    }

    public static long nivar_getName(long l2) {
        long l3 = ObjCRuntime$Functions.ivar_getName;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String ivar_getName(@NativeType(value="Ivar") long l2) {
        long l3 = ObjCRuntime.nivar_getName(l2);
        return MemoryUtil.memUTF8Safe(l3);
    }

    public static long nivar_getTypeEncoding(long l2) {
        long l3 = ObjCRuntime$Functions.ivar_getTypeEncoding;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String ivar_getTypeEncoding(@NativeType(value="Ivar") long l2) {
        long l3 = ObjCRuntime.nivar_getTypeEncoding(l2);
        return MemoryUtil.memUTF8Safe(l3);
    }

    @NativeType(value="ptrdiff_t")
    public static long ivar_getOffset(@NativeType(value="Ivar") long l2) {
        long l3 = ObjCRuntime$Functions.ivar_getOffset;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    public static long nproperty_getName(long l2) {
        long l3 = ObjCRuntime$Functions.property_getName;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String property_getName(@NativeType(value="objc_property_t") long l2) {
        long l3 = ObjCRuntime.nproperty_getName(l2);
        return MemoryUtil.memUTF8Safe(l3);
    }

    public static long nproperty_getAttributes(long l2) {
        long l3 = ObjCRuntime$Functions.property_getAttributes;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String property_getAttributes(@NativeType(value="objc_property_t") long l2) {
        long l3 = ObjCRuntime.nproperty_getAttributes(l2);
        return MemoryUtil.memUTF8Safe(l3);
    }

    public static long nproperty_copyAttributeList(long l2, long l3) {
        long l4 = ObjCRuntime$Functions.property_copyAttributeList;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePPP(l2, l3, l4);
    }

    @Nullable
    @NativeType(value="objc_property_attribute_t *")
    public static ObjCPropertyAttribute$Buffer property_copyAttributeList(@NativeType(value="objc_property_t") long l2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        IntBuffer intBuffer = memoryStack.callocInt(1);
        try {
            long l3 = ObjCRuntime.nproperty_copyAttributeList(l2, MemoryUtil.memAddress(intBuffer));
            ObjCPropertyAttribute$Buffer objCPropertyAttribute$Buffer = ObjCPropertyAttribute.createSafe(l3, intBuffer.get(0));
            return objCPropertyAttribute$Buffer;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nproperty_copyAttributeValue(long l2, long l3) {
        long l4 = ObjCRuntime$Functions.property_copyAttributeValue;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePPP(l2, l3, l4);
    }

    @Nullable
    @NativeType(value="char *")
    public static String property_copyAttributeValue(@NativeType(value="objc_property_t") long l2, @NativeType(value="char const *") ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        long l3 = 0L;
        try {
            l3 = ObjCRuntime.nproperty_copyAttributeValue(l2, MemoryUtil.memAddress(byteBuffer));
            String string = MemoryUtil.memUTF8Safe(l3);
            return string;
        }
        finally {
            if (l3 != 0L) {
                LibCStdlib.nfree(l3);
            }
        }
    }

    @Nullable
    @NativeType(value="char *")
    public static String property_copyAttributeValue(@NativeType(value="objc_property_t") long l2, @NativeType(value="char const *") CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        long l3 = 0L;
        try {
            memoryStack.nUTF8(charSequence, true);
            long l4 = memoryStack.getPointerAddress();
            l3 = ObjCRuntime.nproperty_copyAttributeValue(l2, l4);
            String string = MemoryUtil.memUTF8Safe(l3);
            return string;
        }
        finally {
            if (l3 != 0L) {
                LibCStdlib.nfree(l3);
            }
            memoryStack.setPointer(n2);
        }
    }

    public static long nobjc_getProtocol(long l2) {
        long l3 = ObjCRuntime$Functions.objc_getProtocol;
        return JNI.invokePP(l2, l3);
    }

    @NativeType(value="Protocol *")
    public static long objc_getProtocol(@NativeType(value="char const *") ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return ObjCRuntime.nobjc_getProtocol(MemoryUtil.memAddress(byteBuffer));
    }

    @NativeType(value="Protocol *")
    public static long objc_getProtocol(@NativeType(value="char const *") CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l2 = memoryStack.getPointerAddress();
            long l3 = ObjCRuntime.nobjc_getProtocol(l2);
            return l3;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nobjc_copyProtocolList(long l2) {
        long l3 = ObjCRuntime$Functions.objc_copyProtocolList;
        return JNI.invokePP(l2, l3);
    }

    @Nullable
    @NativeType(value="Protocol **")
    public static PointerBuffer objc_copyProtocolList() {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        Comparable<IntBuffer> comparable = memoryStack.callocInt(1);
        try {
            long l2 = ObjCRuntime.nobjc_copyProtocolList(MemoryUtil.memAddress(comparable));
            comparable = MemoryUtil.memPointerBufferSafe(l2, comparable.get(0));
            return comparable;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    @NativeType(value="BOOL")
    public static boolean protocol_conformsToProtocol(@NativeType(value="Protocol *") long l2, @NativeType(value="Protocol *") long l3) {
        long l4 = ObjCRuntime$Functions.protocol_conformsToProtocol;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.invokePPZ(l2, l3, l4);
    }

    @NativeType(value="BOOL")
    public static boolean protocol_isEqual(@NativeType(value="Protocol *") long l2, @NativeType(value="Protocol *") long l3) {
        long l4 = ObjCRuntime$Functions.protocol_isEqual;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.invokePPZ(l2, l3, l4);
    }

    public static long nprotocol_getName(long l2) {
        long l3 = ObjCRuntime$Functions.protocol_getName;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String protocol_getName(@NativeType(value="Protocol *") long l2) {
        long l3 = ObjCRuntime.nprotocol_getName(l2);
        return MemoryUtil.memUTF8Safe(l3);
    }

    public static native void nprotocol_getMethodDescription(long var0, long var2, boolean var4, boolean var5, long var6, long var8);

    public static void nprotocol_getMethodDescription(long l2, long l3, boolean bl, boolean bl2, long l4) {
        long l5 = ObjCRuntime$Functions.protocol_getMethodDescription;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
        }
        ObjCRuntime.nprotocol_getMethodDescription(l2, l3, bl, bl2, l5, l4);
    }

    @NativeType(value="struct objc_method_description")
    public static ObjCMethodDescription protocol_getMethodDescription(@NativeType(value="Protocol *") long l2, @NativeType(value="SEL") long l3, @NativeType(value="BOOL") boolean bl, @NativeType(value="BOOL") boolean bl2, @NativeType(value="struct objc_method_description") ObjCMethodDescription objCMethodDescription) {
        ObjCRuntime.nprotocol_getMethodDescription(l2, l3, bl, bl2, objCMethodDescription.address());
        return objCMethodDescription;
    }

    public static long nprotocol_copyMethodDescriptionList(long l2, boolean bl, boolean bl2, long l3) {
        long l4 = ObjCRuntime$Functions.protocol_copyMethodDescriptionList;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePPP(l2, bl, bl2, l3, l4);
    }

    @Nullable
    @NativeType(value="struct objc_method_description *")
    public static ObjCMethodDescription$Buffer protocol_copyMethodDescriptionList(@NativeType(value="Protocol *") long l2, @NativeType(value="BOOL") boolean bl, @NativeType(value="BOOL") boolean bl2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        IntBuffer intBuffer = memoryStack.callocInt(1);
        try {
            long l3 = ObjCRuntime.nprotocol_copyMethodDescriptionList(l2, bl, bl2, MemoryUtil.memAddress(intBuffer));
            ObjCMethodDescription$Buffer objCMethodDescription$Buffer = ObjCMethodDescription.createSafe(l3, intBuffer.get(0));
            return objCMethodDescription$Buffer;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nprotocol_getProperty(long l2, long l3, boolean bl, boolean bl2) {
        long l4 = ObjCRuntime$Functions.protocol_getProperty;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePPP(l2, l3, bl, bl2, l4);
    }

    @NativeType(value="objc_property_t")
    public static long protocol_getProperty(@NativeType(value="Protocol *") long l2, @NativeType(value="char const *") ByteBuffer byteBuffer, @NativeType(value="BOOL") boolean bl, @NativeType(value="BOOL") boolean bl2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return ObjCRuntime.nprotocol_getProperty(l2, MemoryUtil.memAddress(byteBuffer), bl, bl2);
    }

    @NativeType(value="objc_property_t")
    public static long protocol_getProperty(@NativeType(value="Protocol *") long l2, @NativeType(value="char const *") CharSequence charSequence, @NativeType(value="BOOL") boolean bl, @NativeType(value="BOOL") boolean bl2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l3 = memoryStack.getPointerAddress();
            long l4 = ObjCRuntime.nprotocol_getProperty(l2, l3, bl, bl2);
            return l4;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nprotocol_copyPropertyList(long l2, long l3) {
        long l4 = ObjCRuntime$Functions.protocol_copyPropertyList;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePPP(l2, l3, l4);
    }

    @Nullable
    @NativeType(value="objc_property_t *")
    public static PointerBuffer protocol_copyPropertyList(@NativeType(value="Protocol *") long l2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        IntBuffer intBuffer = memoryStack.callocInt(1);
        try {
            long l3 = ObjCRuntime.nprotocol_copyPropertyList(l2, MemoryUtil.memAddress(intBuffer));
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBufferSafe(l3, intBuffer.get(0));
            return pointerBuffer;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nprotocol_copyProtocolList(long l2, long l3) {
        long l4 = ObjCRuntime$Functions.protocol_copyProtocolList;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePPP(l2, l3, l4);
    }

    @Nullable
    @NativeType(value="Protocol **")
    public static PointerBuffer protocol_copyProtocolList(@NativeType(value="Protocol *") long l2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        IntBuffer intBuffer = memoryStack.callocInt(1);
        try {
            long l3 = ObjCRuntime.nprotocol_copyProtocolList(l2, MemoryUtil.memAddress(intBuffer));
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBufferSafe(l3, intBuffer.get(0));
            return pointerBuffer;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nobjc_allocateProtocol(long l2) {
        long l3 = ObjCRuntime$Functions.objc_allocateProtocol;
        return JNI.invokePP(l2, l3);
    }

    @NativeType(value="Protocol *")
    public static long objc_allocateProtocol(@NativeType(value="char const *") ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return ObjCRuntime.nobjc_allocateProtocol(MemoryUtil.memAddress(byteBuffer));
    }

    @NativeType(value="Protocol *")
    public static long objc_allocateProtocol(@NativeType(value="char const *") CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l2 = memoryStack.getPointerAddress();
            long l3 = ObjCRuntime.nobjc_allocateProtocol(l2);
            return l3;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static void objc_registerProtocol(@NativeType(value="Protocol *") long l2) {
        long l3 = ObjCRuntime$Functions.objc_registerProtocol;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.invokePV(l2, l3);
    }

    public static void nprotocol_addMethodDescription(long l2, long l3, long l4, boolean bl, boolean bl2) {
        long l5 = ObjCRuntime$Functions.protocol_addMethodDescription;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
        }
        JNI.invokePPPV(l2, l3, l4, bl, bl2, l5);
    }

    public static void protocol_addMethodDescription(@NativeType(value="Protocol *") long l2, @NativeType(value="SEL") long l3, @NativeType(value="char const *") ByteBuffer byteBuffer, @NativeType(value="BOOL") boolean bl, @NativeType(value="BOOL") boolean bl2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        ObjCRuntime.nprotocol_addMethodDescription(l2, l3, MemoryUtil.memAddress(byteBuffer), bl, bl2);
    }

    public static void protocol_addMethodDescription(@NativeType(value="Protocol *") long l2, @NativeType(value="SEL") long l3, @NativeType(value="char const *") CharSequence charSequence, @NativeType(value="BOOL") boolean bl, @NativeType(value="BOOL") boolean bl2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l4 = memoryStack.getPointerAddress();
            ObjCRuntime.nprotocol_addMethodDescription(l2, l3, l4, bl, bl2);
            return;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static void protocol_addProtocol(@NativeType(value="Protocol *") long l2, @NativeType(value="Protocol *") long l3) {
        long l4 = ObjCRuntime$Functions.protocol_addProtocol;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
        }
        JNI.invokePPV(l2, l3, l4);
    }

    public static void nprotocol_addProperty(long l2, long l3, long l4, int n2, boolean bl, boolean bl2) {
        long l5 = ObjCRuntime$Functions.protocol_addProperty;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Struct.validate(l4, n2, ObjCPropertyAttribute.SIZEOF, ObjCPropertyAttribute::validate);
        }
        JNI.invokePPPV(l2, l3, l4, n2, bl, bl2, l5);
    }

    public static void protocol_addProperty(@NativeType(value="Protocol *") long l2, @NativeType(value="char const *") ByteBuffer byteBuffer, @NativeType(value="objc_property_attribute_t const *") ObjCPropertyAttribute$Buffer objCPropertyAttribute$Buffer, @NativeType(value="BOOL") boolean bl, @NativeType(value="BOOL") boolean bl2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        ObjCRuntime.nprotocol_addProperty(l2, MemoryUtil.memAddress(byteBuffer), ((Pointer$Default)objCPropertyAttribute$Buffer).address(), objCPropertyAttribute$Buffer.remaining(), bl, bl2);
    }

    public static void protocol_addProperty(@NativeType(value="Protocol *") long l2, @NativeType(value="char const *") CharSequence charSequence, @NativeType(value="objc_property_attribute_t const *") ObjCPropertyAttribute$Buffer objCPropertyAttribute$Buffer, @NativeType(value="BOOL") boolean bl, @NativeType(value="BOOL") boolean bl2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l3 = memoryStack.getPointerAddress();
            ObjCRuntime.nprotocol_addProperty(l2, l3, ((Pointer$Default)objCPropertyAttribute$Buffer).address(), objCPropertyAttribute$Buffer.remaining(), bl, bl2);
            return;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nobjc_copyImageNames(long l2) {
        long l3 = ObjCRuntime$Functions.objc_copyImageNames;
        return JNI.invokePP(l2, l3);
    }

    @Nullable
    @NativeType(value="char const **")
    public static PointerBuffer objc_copyImageNames() {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        Comparable<IntBuffer> comparable = memoryStack.callocInt(1);
        try {
            long l2 = ObjCRuntime.nobjc_copyImageNames(MemoryUtil.memAddress(comparable));
            comparable = MemoryUtil.memPointerBufferSafe(l2, comparable.get(0));
            return comparable;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nclass_getImageName(long l2) {
        long l3 = ObjCRuntime$Functions.class_getImageName;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String class_getImageName(@NativeType(value="Class") long l2) {
        long l3 = ObjCRuntime.nclass_getImageName(l2);
        return MemoryUtil.memUTF8Safe(l3);
    }

    public static long nobjc_copyClassNamesForImage(long l2, long l3) {
        long l4 = ObjCRuntime$Functions.objc_copyClassNamesForImage;
        return JNI.invokePPP(l2, l3, l4);
    }

    @Nullable
    @NativeType(value="char const **")
    public static PointerBuffer objc_copyClassNamesForImage(@NativeType(value="char const *") ByteBuffer comparable) {
        if (Checks.CHECKS) {
            Checks.checkNT1(comparable);
        }
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        IntBuffer intBuffer = memoryStack.callocInt(1);
        try {
            long l2 = ObjCRuntime.nobjc_copyClassNamesForImage(MemoryUtil.memAddress(comparable), MemoryUtil.memAddress(intBuffer));
            comparable = MemoryUtil.memPointerBufferSafe(l2, intBuffer.get(0));
            return comparable;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    @Nullable
    @NativeType(value="char const **")
    public static PointerBuffer objc_copyClassNamesForImage(@NativeType(value="char const *") CharSequence object) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            IntBuffer intBuffer = memoryStack.callocInt(1);
            memoryStack.nUTF8((CharSequence)object, true);
            long l2 = memoryStack.getPointerAddress();
            long l3 = ObjCRuntime.nobjc_copyClassNamesForImage(l2, MemoryUtil.memAddress(intBuffer));
            object = MemoryUtil.memPointerBufferSafe(l3, intBuffer.get(0));
            return object;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nsel_getName(long l2) {
        long l3 = ObjCRuntime$Functions.sel_getName;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String sel_getName(@NativeType(value="SEL") long l2) {
        long l3 = ObjCRuntime.nsel_getName(l2);
        return MemoryUtil.memUTF8Safe(l3);
    }

    public static long nsel_getUid(long l2) {
        long l3 = ObjCRuntime$Functions.sel_getUid;
        return JNI.invokePP(l2, l3);
    }

    @NativeType(value="SEL")
    public static long sel_getUid(@NativeType(value="char const *") ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return ObjCRuntime.nsel_getUid(MemoryUtil.memAddress(byteBuffer));
    }

    @NativeType(value="SEL")
    public static long sel_getUid(@NativeType(value="char const *") CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l2 = memoryStack.getPointerAddress();
            long l3 = ObjCRuntime.nsel_getUid(l2);
            return l3;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nsel_registerName(long l2) {
        long l3 = ObjCRuntime$Functions.sel_registerName;
        return JNI.invokePP(l2, l3);
    }

    @NativeType(value="SEL")
    public static long sel_registerName(@NativeType(value="char const *") ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return ObjCRuntime.nsel_registerName(MemoryUtil.memAddress(byteBuffer));
    }

    @NativeType(value="SEL")
    public static long sel_registerName(@NativeType(value="char const *") CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l2 = memoryStack.getPointerAddress();
            long l3 = ObjCRuntime.nsel_registerName(l2);
            return l3;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    @NativeType(value="BOOL")
    public static boolean sel_isEqual(@NativeType(value="SEL") long l2, @NativeType(value="SEL") long l3) {
        long l4 = ObjCRuntime$Functions.sel_isEqual;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.invokePPZ(l2, l3, l4);
    }

    public static void objc_enumerationMutation(@NativeType(value="id") long l2) {
        long l3 = ObjCRuntime$Functions.objc_enumerationMutation;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.invokePV(l2, l3);
    }

    public static void nobjc_setEnumerationMutationHandler(long l2) {
        long l3 = ObjCRuntime$Functions.objc_setEnumerationMutationHandler;
        JNI.invokePV(l2, l3);
    }

    public static void objc_setEnumerationMutationHandler(@NativeType(value="EnumerationMutationHandler") EnumerationMutationHandlerI enumerationMutationHandlerI) {
        ObjCRuntime.nobjc_setEnumerationMutationHandler(enumerationMutationHandlerI.address());
    }

    @NativeType(value="IMP")
    public static long imp_implementationWithBlock(@NativeType(value="id") long l2) {
        long l3 = ObjCRuntime$Functions.imp_implementationWithBlock;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    @NativeType(value="id")
    public static long imp_getBlock(@NativeType(value="IMP") long l2) {
        long l3 = ObjCRuntime$Functions.imp_getBlock;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    @NativeType(value="BOOL")
    public static boolean imp_removeBlock(@NativeType(value="IMP") long l2) {
        long l3 = ObjCRuntime$Functions.imp_removeBlock;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePZ(l2, l3);
    }

    public static long nobjc_loadWeak(long l2) {
        long l3 = ObjCRuntime$Functions.objc_loadWeak;
        return JNI.invokePP(l2, l3);
    }

    @NativeType(value="id")
    public static long objc_loadWeak(@Nullable @NativeType(value="id *") PointerBuffer pointerBuffer) {
        if (Checks.CHECKS) {
            Checks.checkSafe(pointerBuffer, 1);
        }
        return ObjCRuntime.nobjc_loadWeak(MemoryUtil.memAddressSafe(pointerBuffer));
    }

    public static long nobjc_storeWeak(long l2, long l3) {
        long l4 = ObjCRuntime$Functions.objc_storeWeak;
        if (Checks.CHECKS) {
            Checks.check(l3);
        }
        return JNI.invokePPP(l2, l3, l4);
    }

    @NativeType(value="id")
    public static long objc_storeWeak(@NativeType(value="id *") PointerBuffer pointerBuffer, @NativeType(value="id") long l2) {
        if (Checks.CHECKS) {
            Checks.check(pointerBuffer, 1);
        }
        return ObjCRuntime.nobjc_storeWeak(MemoryUtil.memAddress(pointerBuffer), l2);
    }

    public static void objc_setAssociatedObject(@NativeType(value="id") long l2, @NativeType(value="void const *") long l3, @NativeType(value="id") long l4, @NativeType(value="objc_AssociationPolicy") long l5) {
        long l6 = ObjCRuntime$Functions.objc_setAssociatedObject;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
            Checks.check(l4);
        }
        JNI.invokePPPPV(l2, l3, l4, l5, l6);
    }

    @NativeType(value="id")
    public static long objc_getAssociatedObject(@NativeType(value="id") long l2, @NativeType(value="void const *") long l3) {
        long l4 = ObjCRuntime$Functions.objc_getAssociatedObject;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.invokePPP(l2, l3, l4);
    }

    public static void objc_removeAssociatedObjects(@NativeType(value="id") long l2) {
        long l3 = ObjCRuntime$Functions.objc_removeAssociatedObjects;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.invokePV(l2, l3);
    }

    static /* synthetic */ SharedLibrary access$000() {
        return OBJC;
    }
}

