/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.windows.KEYBDINPUT$Buffer;

public class KEYBDINPUT
extends Struct<KEYBDINPUT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int WVK;
    public static final int WSCAN;
    public static final int DWFLAGS;
    public static final int TIME;
    public static final int DWEXTRAINFO;

    protected KEYBDINPUT(long l2, @Nullable ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected KEYBDINPUT create(long l2, @Nullable ByteBuffer byteBuffer) {
        return new KEYBDINPUT(l2, byteBuffer);
    }

    public KEYBDINPUT(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), KEYBDINPUT.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="WORD")
    public short wVk() {
        return KEYBDINPUT.nwVk(this.address());
    }

    @NativeType(value="WORD")
    public short wScan() {
        return KEYBDINPUT.nwScan(this.address());
    }

    @NativeType(value="DWORD")
    public int dwFlags() {
        return KEYBDINPUT.ndwFlags(this.address());
    }

    @NativeType(value="DWORD")
    public int time() {
        return KEYBDINPUT.ntime(this.address());
    }

    @NativeType(value="ULONG_PTR")
    public long dwExtraInfo() {
        return KEYBDINPUT.ndwExtraInfo(this.address());
    }

    public KEYBDINPUT wVk(@NativeType(value="WORD") short s2) {
        KEYBDINPUT.nwVk(this.address(), s2);
        return this;
    }

    public KEYBDINPUT wScan(@NativeType(value="WORD") short s2) {
        KEYBDINPUT.nwScan(this.address(), s2);
        return this;
    }

    public KEYBDINPUT dwFlags(@NativeType(value="DWORD") int n2) {
        KEYBDINPUT.ndwFlags(this.address(), n2);
        return this;
    }

    public KEYBDINPUT time(@NativeType(value="DWORD") int n2) {
        KEYBDINPUT.ntime(this.address(), n2);
        return this;
    }

    public KEYBDINPUT dwExtraInfo(@NativeType(value="ULONG_PTR") long l2) {
        KEYBDINPUT.ndwExtraInfo(this.address(), l2);
        return this;
    }

    public KEYBDINPUT set(short s2, short s3, int n2, int n3, long l2) {
        this.wVk(s2);
        this.wScan(s3);
        this.dwFlags(n2);
        this.time(n3);
        this.dwExtraInfo(l2);
        return this;
    }

    public KEYBDINPUT set(KEYBDINPUT kEYBDINPUT) {
        MemoryUtil.memCopy(kEYBDINPUT.address(), this.address(), SIZEOF);
        return this;
    }

    public static KEYBDINPUT malloc() {
        return new KEYBDINPUT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static KEYBDINPUT calloc() {
        return new KEYBDINPUT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static KEYBDINPUT create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new KEYBDINPUT(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static KEYBDINPUT create(long l2) {
        return new KEYBDINPUT(l2, null);
    }

    @Nullable
    public static KEYBDINPUT createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new KEYBDINPUT(l2, null);
    }

    public static KEYBDINPUT$Buffer malloc(int n2) {
        return new KEYBDINPUT$Buffer(MemoryUtil.nmemAllocChecked(KEYBDINPUT.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static KEYBDINPUT$Buffer calloc(int n2) {
        return new KEYBDINPUT$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static KEYBDINPUT$Buffer create(int n2) {
        ByteBuffer byteBuffer = KEYBDINPUT.__create(n2, SIZEOF);
        int n3 = n2;
        return new KEYBDINPUT$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static KEYBDINPUT$Buffer create(long l2, int n2) {
        return new KEYBDINPUT$Buffer(l2, n2);
    }

    @Nullable
    public static KEYBDINPUT$Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new KEYBDINPUT$Buffer(l2, n2);
    }

    @Deprecated
    public static KEYBDINPUT mallocStack() {
        return KEYBDINPUT.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static KEYBDINPUT callocStack() {
        return KEYBDINPUT.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static KEYBDINPUT mallocStack(MemoryStack memoryStack) {
        return KEYBDINPUT.malloc(memoryStack);
    }

    @Deprecated
    public static KEYBDINPUT callocStack(MemoryStack memoryStack) {
        return KEYBDINPUT.calloc(memoryStack);
    }

    @Deprecated
    public static KEYBDINPUT$Buffer mallocStack(int n2) {
        return KEYBDINPUT.malloc(n2, MemoryStack.stackGet());
    }

    @Deprecated
    public static KEYBDINPUT$Buffer callocStack(int n2) {
        return KEYBDINPUT.calloc(n2, MemoryStack.stackGet());
    }

    @Deprecated
    public static KEYBDINPUT$Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return KEYBDINPUT.malloc(n2, memoryStack);
    }

    @Deprecated
    public static KEYBDINPUT$Buffer callocStack(int n2, MemoryStack memoryStack) {
        return KEYBDINPUT.calloc(n2, memoryStack);
    }

    public static KEYBDINPUT malloc(MemoryStack memoryStack) {
        return new KEYBDINPUT(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static KEYBDINPUT calloc(MemoryStack memoryStack) {
        return new KEYBDINPUT(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static KEYBDINPUT$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new KEYBDINPUT$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static KEYBDINPUT$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new KEYBDINPUT$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static short nwVk(long l2) {
        return UNSAFE.getShort(null, l2 + (long)WVK);
    }

    public static short nwScan(long l2) {
        return UNSAFE.getShort(null, l2 + (long)WSCAN);
    }

    public static int ndwFlags(long l2) {
        return UNSAFE.getInt(null, l2 + (long)DWFLAGS);
    }

    public static int ntime(long l2) {
        return UNSAFE.getInt(null, l2 + (long)TIME);
    }

    public static long ndwExtraInfo(long l2) {
        return MemoryUtil.memGetAddress(l2 + (long)DWEXTRAINFO);
    }

    public static void nwVk(long l2, short s2) {
        UNSAFE.putShort(null, l2 + (long)WVK, s2);
    }

    public static void nwScan(long l2, short s2) {
        UNSAFE.putShort(null, l2 + (long)WSCAN, s2);
    }

    public static void ndwFlags(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)DWFLAGS, n2);
    }

    public static void ntime(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)TIME, n2);
    }

    public static void ndwExtraInfo(long l2, long l3) {
        MemoryUtil.memPutAddress(l2 + (long)DWEXTRAINFO, l3);
    }

    static {
        Struct$Layout struct$Layout = KEYBDINPUT.__struct(KEYBDINPUT.__member(2), KEYBDINPUT.__member(2), KEYBDINPUT.__member(4), KEYBDINPUT.__member(4), KEYBDINPUT.__member(POINTER_SIZE));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        WVK = struct$Layout.offsetof(0);
        WSCAN = struct$Layout.offsetof(1);
        DWFLAGS = struct$Layout.offsetof(2);
        TIME = struct$Layout.offsetof(3);
        DWEXTRAINFO = struct$Layout.offsetof(4);
    }
}

