/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.Struct$Layout;
import org.lwjgl.system.windows.LARGE_INTEGER$Buffer;

public class LARGE_INTEGER
extends Struct<LARGE_INTEGER>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int U;
    public static final int U_LOWPART;
    public static final int U_HIGHPART;
    public static final int QUADPART;

    protected LARGE_INTEGER(long l2, @Nullable ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected LARGE_INTEGER create(long l2, @Nullable ByteBuffer byteBuffer) {
        return new LARGE_INTEGER(l2, byteBuffer);
    }

    public LARGE_INTEGER(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), LARGE_INTEGER.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="DWORD")
    public int u_LowPart() {
        return LARGE_INTEGER.nu_LowPart(this.address());
    }

    @NativeType(value="LONG")
    public int u_HighPart() {
        return LARGE_INTEGER.nu_HighPart(this.address());
    }

    @NativeType(value="LONGLONG")
    public long QuadPart() {
        return LARGE_INTEGER.nQuadPart(this.address());
    }

    public LARGE_INTEGER u_LowPart(@NativeType(value="DWORD") int n2) {
        LARGE_INTEGER.nu_LowPart(this.address(), n2);
        return this;
    }

    public LARGE_INTEGER u_HighPart(@NativeType(value="LONG") int n2) {
        LARGE_INTEGER.nu_HighPart(this.address(), n2);
        return this;
    }

    public LARGE_INTEGER QuadPart(@NativeType(value="LONGLONG") long l2) {
        LARGE_INTEGER.nQuadPart(this.address(), l2);
        return this;
    }

    public LARGE_INTEGER set(LARGE_INTEGER lARGE_INTEGER) {
        MemoryUtil.memCopy(lARGE_INTEGER.address(), this.address(), SIZEOF);
        return this;
    }

    public static LARGE_INTEGER malloc() {
        return new LARGE_INTEGER(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static LARGE_INTEGER calloc() {
        return new LARGE_INTEGER(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static LARGE_INTEGER create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new LARGE_INTEGER(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static LARGE_INTEGER create(long l2) {
        return new LARGE_INTEGER(l2, null);
    }

    @Nullable
    public static LARGE_INTEGER createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new LARGE_INTEGER(l2, null);
    }

    public static LARGE_INTEGER$Buffer malloc(int n2) {
        return new LARGE_INTEGER$Buffer(MemoryUtil.nmemAllocChecked(LARGE_INTEGER.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static LARGE_INTEGER$Buffer calloc(int n2) {
        return new LARGE_INTEGER$Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static LARGE_INTEGER$Buffer create(int n2) {
        ByteBuffer byteBuffer = LARGE_INTEGER.__create(n2, SIZEOF);
        int n3 = n2;
        return new LARGE_INTEGER$Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static LARGE_INTEGER$Buffer create(long l2, int n2) {
        return new LARGE_INTEGER$Buffer(l2, n2);
    }

    @Nullable
    public static LARGE_INTEGER$Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new LARGE_INTEGER$Buffer(l2, n2);
    }

    public static LARGE_INTEGER malloc(MemoryStack memoryStack) {
        return new LARGE_INTEGER(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static LARGE_INTEGER calloc(MemoryStack memoryStack) {
        return new LARGE_INTEGER(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static LARGE_INTEGER$Buffer malloc(int n2, MemoryStack memoryStack) {
        return new LARGE_INTEGER$Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static LARGE_INTEGER$Buffer calloc(int n2, MemoryStack memoryStack) {
        return new LARGE_INTEGER$Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int nu_LowPart(long l2) {
        return UNSAFE.getInt(null, l2 + (long)U_LOWPART);
    }

    public static int nu_HighPart(long l2) {
        return UNSAFE.getInt(null, l2 + (long)U_HIGHPART);
    }

    public static long nQuadPart(long l2) {
        return UNSAFE.getLong(null, l2 + (long)QUADPART);
    }

    public static void nu_LowPart(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)U_LOWPART, n2);
    }

    public static void nu_HighPart(long l2, int n2) {
        UNSAFE.putInt(null, l2 + (long)U_HIGHPART, n2);
    }

    public static void nQuadPart(long l2, long l3) {
        UNSAFE.putLong(null, l2 + (long)QUADPART, l3);
    }

    static {
        Struct$Layout struct$Layout = LARGE_INTEGER.__union(LARGE_INTEGER.__struct(LARGE_INTEGER.__member(4), LARGE_INTEGER.__member(4)), LARGE_INTEGER.__member(8));
        SIZEOF = struct$Layout.getSize();
        ALIGNOF = struct$Layout.getAlignment();
        U = struct$Layout.offsetof(0);
        U_LOWPART = struct$Layout.offsetof(1);
        U_HIGHPART = struct$Layout.offsetof(2);
        QUADPART = struct$Layout.offsetof(3);
    }
}

