/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.SharedLibrary$Default;
import org.lwjgl.system.windows.WinBase;
import org.lwjgl.system.windows.WindowsUtil;

public class WindowsLibrary
extends SharedLibrary$Default {
    public static final long HINSTANCE;

    public WindowsLibrary(String string) {
        String string2 = string;
        this(string2, WindowsLibrary.loadLibrary(string2));
    }

    public WindowsLibrary(String string, long l2) {
        super(string, l2);
    }

    private static long loadLibrary(String object) {
        long l2;
        MemoryStack memoryStack = MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            l2 = WinBase.LoadLibrary(memoryStack.UTF16((CharSequence)object));
            if (memoryStack != null) {
                memoryStack.close();
            }
        }
        catch (Throwable throwable2) {
            try {
                object = throwable2;
                throwable = throwable2;
                throw object;
            }
            catch (Throwable throwable3) {
                if (memoryStack != null) {
                    if (throwable != null) {
                        try {
                            memoryStack.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        memoryStack.close();
                    }
                }
                throw throwable3;
            }
        }
        if (l2 == 0L) {
            throw new UnsatisfiedLinkError("Failed to load library: " + (String)object + " (error code = " + WinBase.getLastError() + ")");
        }
        return l2;
    }

    /*
     * Loose catch block
     */
    @Override
    @Nullable
    public String getPath() {
        String string;
        int n2;
        int n3 = 256;
        ByteBuffer byteBuffer = MemoryUtil.memAlloc(256);
        while (true) {
            int n4 = WinBase.GetModuleFileName(this.address(), byteBuffer);
            n2 = WinBase.getLastError();
            if (n2 != 0) break block5;
            string = n4 == 0 ? null : MemoryUtil.memUTF16(byteBuffer, n4);
            break;
        }
        catch (Throwable throwable) {
            MemoryUtil.memFree(byteBuffer);
            throw throwable;
        }
        {
            block5: {
                MemoryUtil.memFree(byteBuffer);
                return string;
            }
            if (n2 != 122) {
                MemoryUtil.memFree(byteBuffer);
                return null;
            }
            n3 = n3 * 3 / 2;
            byteBuffer = MemoryUtil.memRealloc(byteBuffer, n3);
            continue;
        }
    }

    @Override
    public long getFunctionAddress(ByteBuffer byteBuffer) {
        return WinBase.GetProcAddress(this.address(), byteBuffer);
    }

    @Override
    public void free() {
        if (!WinBase.FreeLibrary(this.address())) {
            WindowsUtil.windowsThrowException("Failed to unload library: " + this.getName());
        }
    }

    static {
        MemoryStack memoryStack = MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            HINSTANCE = WinBase.GetModuleHandle(memoryStack.UTF16(Library.JNI_LIBRARY_NAME));
            if (HINSTANCE == 0L) {
                throw new RuntimeException("Failed to retrieve LWJGL module handle.");
            }
            if (memoryStack != null) {
                memoryStack.close();
            }
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (memoryStack != null) {
                    if (throwable != null) {
                        try {
                            memoryStack.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        memoryStack.close();
                    }
                }
                throw throwable4;
            }
        }
    }
}

