/*
 * Decompiled with CFR 0.152.
 */
package org.xml.sax.helpers;

import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.Vector;
import org.xml.sax.helpers.NamespaceSupport$Context;

public class NamespaceSupport {
    public static final String XMLNS = "http://www.w3.org/XML/1998/namespace";
    private static final Enumeration EMPTY_ENUMERATION = new Vector().elements();
    private NamespaceSupport$Context[] contexts;
    private NamespaceSupport$Context currentContext;
    private int contextPos;

    public NamespaceSupport() {
        this.reset();
    }

    public void reset() {
        this.contexts = new NamespaceSupport$Context[32];
        this.contextPos = 0;
        this.contexts[this.contextPos] = this.currentContext = new NamespaceSupport$Context(this);
        this.currentContext.declarePrefix("xml", XMLNS);
    }

    public void pushContext() {
        int n2 = this.contexts.length;
        this.contexts[this.contextPos].declsOK = false;
        ++this.contextPos;
        if (this.contextPos >= n2) {
            NamespaceSupport$Context[] namespaceSupport$ContextArray = new NamespaceSupport$Context[n2 << 1];
            System.arraycopy(this.contexts, 0, namespaceSupport$ContextArray, 0, n2);
            this.contexts = namespaceSupport$ContextArray;
        }
        this.currentContext = this.contexts[this.contextPos];
        if (this.currentContext == null) {
            this.contexts[this.contextPos] = this.currentContext = new NamespaceSupport$Context(this);
        }
        if (this.contextPos > 0) {
            this.currentContext.setParent(this.contexts[this.contextPos - 1]);
        }
    }

    public void popContext() {
        this.contexts[this.contextPos].clear();
        --this.contextPos;
        if (this.contextPos < 0) {
            throw new EmptyStackException();
        }
        this.currentContext = this.contexts[this.contextPos];
    }

    public boolean declarePrefix(String string, String string2) {
        if (string.equals("xml") || string.equals("xmlns")) {
            return false;
        }
        this.currentContext.declarePrefix(string, string2);
        return true;
    }

    public String[] processName(String stringArray, String[] stringArray2, boolean bl) {
        if ((stringArray = this.currentContext.processName((String)stringArray, bl)) == null) {
            return null;
        }
        stringArray2[0] = stringArray[0];
        stringArray2[1] = stringArray[1];
        stringArray2[2] = stringArray[2];
        return stringArray2;
    }

    public String getURI(String string) {
        return this.currentContext.getURI(string);
    }

    public Enumeration getPrefixes() {
        return this.currentContext.getPrefixes();
    }

    public String getPrefix(String string) {
        return this.currentContext.getPrefix(string);
    }

    public Enumeration getPrefixes(String string) {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.getPrefixes();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string.equals(this.getURI(string2))) continue;
            vector.addElement(string2);
        }
        return vector.elements();
    }

    public Enumeration getDeclaredPrefixes() {
        return this.currentContext.getDeclaredPrefixes();
    }

    static Enumeration access$000() {
        return EMPTY_ENUMERATION;
    }
}

