/*
 * Decompiled with CFR 0.152.
 */
package org.xml.sax.helpers;

import java.util.Vector;
import org.xml.sax.AttributeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;
import org.xml.sax.helpers.ParserAdapter$AttributeListAdapter;
import org.xml.sax.helpers.ParserFactory;

public class ParserAdapter
implements DocumentHandler,
XMLReader {
    private static final String FEATURES = "http://xml.org/sax/features/";
    private static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
    private static final String NAMESPACE_PREFIXES = "http://xml.org/sax/features/namespace-prefixes";
    private NamespaceSupport nsSupport;
    private ParserAdapter$AttributeListAdapter attAdapter;
    private boolean parsing = false;
    private String[] nameParts = new String[3];
    private Parser parser = null;
    private AttributesImpl atts = null;
    private boolean namespaces = true;
    private boolean prefixes = false;
    Locator locator;
    EntityResolver entityResolver = null;
    DTDHandler dtdHandler = null;
    ContentHandler contentHandler = null;
    ErrorHandler errorHandler = null;

    public ParserAdapter() {
        String string = System.getProperty("org.xml.sax.parser");
        try {
            this.setup(ParserFactory.makeParser());
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SAXException("Cannot find SAX1 driver class " + string, classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SAXException("SAX1 driver class " + string + " found but cannot be loaded", illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new SAXException("SAX1 driver class " + string + " loaded but cannot be instantiated", instantiationException);
        }
        catch (ClassCastException classCastException) {
            throw new SAXException("SAX1 driver class " + string + " does not implement org.xml.sax.Parser");
        }
        catch (NullPointerException nullPointerException) {
            throw new SAXException("System property org.xml.sax.parser not specified");
        }
    }

    public ParserAdapter(Parser parser) {
        this.setup(parser);
    }

    private void setup(Parser parser) {
        if (parser == null) {
            throw new NullPointerException("Parser argument must not be null");
        }
        this.parser = parser;
        this.atts = new AttributesImpl();
        this.nsSupport = new NamespaceSupport();
        this.attAdapter = new ParserAdapter$AttributeListAdapter(this);
    }

    public void setFeature(String string, boolean bl) {
        if (string.equals(NAMESPACES)) {
            this.checkNotParsing("feature", string);
            this.namespaces = bl;
            if (!this.namespaces && !this.prefixes) {
                this.prefixes = true;
                return;
            }
        } else if (string.equals(NAMESPACE_PREFIXES)) {
            this.checkNotParsing("feature", string);
            this.prefixes = bl;
            if (!this.prefixes && !this.namespaces) {
                this.namespaces = true;
                return;
            }
        } else {
            throw new SAXNotRecognizedException("Feature: " + string);
        }
    }

    public boolean getFeature(String string) {
        if (string.equals(NAMESPACES)) {
            return this.namespaces;
        }
        if (string.equals(NAMESPACE_PREFIXES)) {
            return this.prefixes;
        }
        throw new SAXNotRecognizedException("Feature: " + string);
    }

    public void setProperty(String string, Object object) {
        throw new SAXNotRecognizedException("Property: " + string);
    }

    public Object getProperty(String string) {
        throw new SAXNotRecognizedException("Property: " + string);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.dtdHandler = dTDHandler;
    }

    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void parse(String string) {
        this.parse(new InputSource(string));
    }

    public void parse(InputSource inputSource) {
        if (this.parsing) {
            throw new SAXException("Parser is already in use");
        }
        this.setupParser();
        this.parsing = true;
        try {
            this.parser.parse(inputSource);
            inputSource = null;
            this.parsing = false;
        }
        catch (Throwable throwable) {
            inputSource = null;
            this.parsing = false;
            throw throwable;
        }
        this.parsing = false;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        if (this.contentHandler != null) {
            this.contentHandler.setDocumentLocator(locator);
        }
    }

    public void startDocument() {
        if (this.contentHandler != null) {
            this.contentHandler.startDocument();
        }
    }

    public void endDocument() {
        if (this.contentHandler != null) {
            this.contentHandler.endDocument();
        }
    }

    public void startElement(String string, AttributeList attributeList) {
        String string2;
        String string3;
        Vector<SAXException> vector = null;
        if (!this.namespaces) {
            if (this.contentHandler != null) {
                this.attAdapter.setAttributeList(attributeList);
                this.contentHandler.startElement("", "", string.intern(), this.attAdapter);
            }
            return;
        }
        this.nsSupport.pushContext();
        int n2 = attributeList.getLength();
        int n3 = 0;
        while (n3 < n2) {
            block21: {
                block23: {
                    int n4;
                    String string4;
                    block22: {
                        string4 = attributeList.getName(n3);
                        if (!string4.startsWith("xmlns")) break block21;
                        n4 = string4.indexOf(58);
                        if (n4 != -1 || string4.length() != 5) break block22;
                        string3 = "";
                        break block23;
                    }
                    if (n4 != 5) break block21;
                    string3 = string4.substring(n4 + 1);
                }
                string2 = attributeList.getValue(n3);
                if (!this.nsSupport.declarePrefix(string3, string2)) {
                    this.reportError("Illegal Namespace prefix: " + string3);
                } else if (this.contentHandler != null) {
                    this.contentHandler.startPrefixMapping(string3, string2);
                }
            }
            ++n3;
        }
        this.atts.clear();
        int n5 = 0;
        while (n5 < n2) {
            int n6;
            Object object;
            string3 = attributeList.getName(n5);
            String string5 = attributeList.getType(n5);
            string2 = attributeList.getValue(n5);
            if (string3.startsWith("xmlns") && (object = (n6 = string3.indexOf(58)) == -1 && string3.length() == 5 ? "" : (n6 != 5 ? null : string3.substring(n6 + 1))) != null) {
                if (this.prefixes) {
                    this.atts.addAttribute("", "", string3.intern(), string5, string2);
                }
            } else {
                try {
                    object = this.processName(string3, true, true);
                    this.atts.addAttribute(object[0], object[1], object[2], string5, string2);
                }
                catch (SAXException sAXException) {
                    if (vector == null) {
                        vector = new Vector<SAXException>();
                    }
                    vector.addElement(sAXException);
                    String string6 = string3;
                    this.atts.addAttribute("", string6, string6, string5, string2);
                }
            }
            ++n5;
        }
        if (vector != null && this.errorHandler != null) {
            int n7 = 0;
            while (n7 < vector.size()) {
                this.errorHandler.error((SAXParseException)vector.elementAt(n7));
                ++n7;
            }
        }
        if (this.contentHandler != null) {
            String[] stringArray = this.processName(string, false, false);
            this.contentHandler.startElement(stringArray[0], stringArray[1], stringArray[2], this.atts);
        }
    }

    public void endElement(String object) {
        if (!this.namespaces) {
            if (this.contentHandler != null) {
                this.contentHandler.endElement("", "", ((String)object).intern());
            }
            return;
        }
        object = this.processName((String)object, false, false);
        if (this.contentHandler != null) {
            this.contentHandler.endElement(object[0], object[1], object[2]);
            object = this.nsSupport.getDeclaredPrefixes();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                this.contentHandler.endPrefixMapping(string);
            }
        }
        this.nsSupport.popContext();
    }

    public void characters(char[] cArray, int n2, int n3) {
        if (this.contentHandler != null) {
            this.contentHandler.characters(cArray, n2, n3);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n2, int n3) {
        if (this.contentHandler != null) {
            this.contentHandler.ignorableWhitespace(cArray, n2, n3);
        }
    }

    public void processingInstruction(String string, String string2) {
        if (this.contentHandler != null) {
            this.contentHandler.processingInstruction(string, string2);
        }
    }

    private void setupParser() {
        this.nsSupport.reset();
        if (this.entityResolver != null) {
            this.parser.setEntityResolver(this.entityResolver);
        }
        if (this.dtdHandler != null) {
            this.parser.setDTDHandler(this.dtdHandler);
        }
        if (this.errorHandler != null) {
            this.parser.setErrorHandler(this.errorHandler);
        }
        this.parser.setDocumentHandler(this);
        this.locator = null;
    }

    private String[] processName(String string, boolean bl, boolean bl2) {
        String[] stringArray = this.nsSupport.processName(string, this.nameParts, bl);
        if (stringArray == null) {
            if (bl2) {
                throw this.makeException("Undeclared prefix: " + string);
            }
            this.reportError("Undeclared prefix: " + string);
            String[] stringArray2 = new String[3];
            stringArray = stringArray2;
            stringArray[1] = "";
            stringArray2[0] = "";
            stringArray[2] = string.intern();
        }
        return stringArray;
    }

    void reportError(String string) {
        if (this.errorHandler != null) {
            this.errorHandler.error(this.makeException(string));
        }
    }

    private SAXParseException makeException(String string) {
        if (this.locator != null) {
            return new SAXParseException(string, this.locator);
        }
        return new SAXParseException(string, null, null, -1, -1);
    }

    private void checkNotParsing(String string, String string2) {
        if (this.parsing) {
            throw new SAXNotSupportedException("Cannot change " + string + ' ' + string2 + " while parsing");
        }
    }

    static AttributesImpl access$000(ParserAdapter parserAdapter) {
        return parserAdapter.atts;
    }
}

