/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.mxp1;

import java.io.Reader;
import org.xmlpull.mxp1.MXParser;
import org.xmlpull.v1.XmlPullParserException;

public class MXParserCachingStrings
extends MXParser
implements Cloneable {
    protected static final boolean CACHE_STATISTICS = false;
    protected static final boolean TRACE_SIZING = false;
    protected static final int INITIAL_CAPACITY = 13;
    protected int cacheStatCalls;
    protected int cacheStatWalks;
    protected int cacheStatResets;
    protected int cacheStatRehash;
    protected static final int CACHE_LOAD = 77;
    protected int cacheEntriesCount;
    protected int cacheEntriesThreshold;
    protected char[][] keys;
    protected String[] values;

    public Object clone() {
        if (this.reader != null && !(this.reader instanceof Cloneable)) {
            throw new CloneNotSupportedException("reader used in parser must implement Cloneable!");
        }
        Object object = (MXParserCachingStrings)super.clone();
        if (this.reader != null) {
            try {
                Object object2 = this.reader.getClass().getMethod("clone", null).invoke((Object)this.reader, null);
                ((MXParser)object).reader = (Reader)object2;
            }
            catch (Exception exception) {
                object = new CloneNotSupportedException("failed to call clone() on reader " + this.reader + ":" + exception);
                ((Throwable)object).initCause(exception);
                throw object;
            }
        }
        if (this.keys != null) {
            ((MXParserCachingStrings)object).keys = (char[][])this.keys.clone();
        }
        if (this.values != null) {
            ((MXParserCachingStrings)object).values = (String[])this.values.clone();
        }
        if (this.elRawName != null) {
            MXParserCachingStrings mXParserCachingStrings = this;
            ((MXParser)object).elRawName = mXParserCachingStrings.cloneCCArr(mXParserCachingStrings.elRawName);
        }
        if (this.elRawNameEnd != null) {
            ((MXParser)object).elRawNameEnd = (int[])this.elRawNameEnd.clone();
        }
        if (this.elRawNameLine != null) {
            ((MXParser)object).elRawNameLine = (int[])this.elRawNameLine.clone();
        }
        if (this.elName != null) {
            ((MXParser)object).elName = (String[])this.elName.clone();
        }
        if (this.elPrefix != null) {
            ((MXParser)object).elPrefix = (String[])this.elPrefix.clone();
        }
        if (this.elUri != null) {
            ((MXParser)object).elUri = (String[])this.elUri.clone();
        }
        if (this.elNamespaceCount != null) {
            ((MXParser)object).elNamespaceCount = (int[])this.elNamespaceCount.clone();
        }
        if (this.attributeName != null) {
            ((MXParser)object).attributeName = (String[])this.attributeName.clone();
        }
        if (this.attributeNameHash != null) {
            ((MXParser)object).attributeNameHash = (int[])this.attributeNameHash.clone();
        }
        if (this.attributePrefix != null) {
            ((MXParser)object).attributePrefix = (String[])this.attributePrefix.clone();
        }
        if (this.attributeUri != null) {
            ((MXParser)object).attributeUri = (String[])this.attributeUri.clone();
        }
        if (this.attributeValue != null) {
            ((MXParser)object).attributeValue = (String[])this.attributeValue.clone();
        }
        if (this.namespacePrefix != null) {
            ((MXParser)object).namespacePrefix = (String[])this.namespacePrefix.clone();
        }
        if (this.namespacePrefixHash != null) {
            ((MXParser)object).namespacePrefixHash = (int[])this.namespacePrefixHash.clone();
        }
        if (this.namespaceUri != null) {
            ((MXParser)object).namespaceUri = (String[])this.namespaceUri.clone();
        }
        if (this.entityName != null) {
            ((MXParser)object).entityName = (String[])this.entityName.clone();
        }
        if (this.entityNameBuf != null) {
            MXParserCachingStrings mXParserCachingStrings = this;
            ((MXParser)object).entityNameBuf = mXParserCachingStrings.cloneCCArr(mXParserCachingStrings.entityNameBuf);
        }
        if (this.entityNameHash != null) {
            ((MXParser)object).entityNameHash = (int[])this.entityNameHash.clone();
        }
        if (this.entityReplacementBuf != null) {
            MXParserCachingStrings mXParserCachingStrings = this;
            ((MXParser)object).entityReplacementBuf = mXParserCachingStrings.cloneCCArr(mXParserCachingStrings.entityReplacementBuf);
        }
        if (this.entityReplacement != null) {
            ((MXParser)object).entityReplacement = (String[])this.entityReplacement.clone();
        }
        if (this.buf != null) {
            ((MXParser)object).buf = (char[])this.buf.clone();
        }
        if (this.pc != null) {
            ((MXParser)object).pc = (char[])this.pc.clone();
        }
        if (this.charRefOneCharBuf != null) {
            ((MXParser)object).charRefOneCharBuf = (char[])this.charRefOneCharBuf.clone();
        }
        return object;
    }

    private char[][] cloneCCArr(char[][] cArray) {
        cArray = (char[][])cArray.clone();
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (cArray[i2] == null) continue;
            cArray[i2] = (char[])cArray[i2].clone();
        }
        return cArray;
    }

    public MXParserCachingStrings() {
        this.allStringsInterned = true;
        this.initStringCache();
    }

    public void setFeature(String string, boolean bl) {
        if ("http://xmlpull.org/v1/doc/features.html#names-interned".equals(string)) {
            if (this.eventType != 0) {
                throw new XmlPullParserException("interning names feature can only be changed before parsing", this, null);
            }
            this.allStringsInterned = bl;
            if (!bl && this.keys != null) {
                this.resetStringCache();
                return;
            }
        } else {
            super.setFeature(string, bl);
        }
    }

    public boolean getFeature(String string) {
        if ("http://xmlpull.org/v1/doc/features.html#names-interned".equals(string)) {
            return this.allStringsInterned;
        }
        return super.getFeature(string);
    }

    public void finalize() {
    }

    protected String newString(char[] cArray, int n2, int n3) {
        if (this.allStringsInterned) {
            return this.newStringIntern(cArray, n2, n3);
        }
        return super.newString(cArray, n2, n3);
    }

    protected String newStringIntern(char[] object, int n2, int n3) {
        char[] cArray;
        if (this.cacheEntriesCount >= this.cacheEntriesThreshold) {
            this.rehash();
        }
        int n4 = MXParser.fastHash(object, n2, n3) % this.keys.length;
        while ((cArray = this.keys[n4]) != null && !MXParserCachingStrings.keysAreEqual(cArray, 0, cArray.length, object, n2, n3)) {
            n4 = (n4 + 1) % this.keys.length;
        }
        if (cArray != null) {
            return this.values[n4];
        }
        cArray = new char[n3];
        System.arraycopy(object, n2, cArray, 0, n3);
        object = new String(cArray).intern();
        this.keys[n4] = cArray;
        this.values[n4] = object;
        ++this.cacheEntriesCount;
        return object;
    }

    protected void initStringCache() {
        if (this.keys == null) {
            this.cacheEntriesThreshold = 10;
            if (this.cacheEntriesThreshold >= 13) {
                throw new RuntimeException("internal error: threshold must be less than capacity: 13");
            }
            this.keys = new char[13][];
            this.values = new String[13];
            this.cacheEntriesCount = 0;
        }
    }

    protected void resetStringCache() {
        this.initStringCache();
    }

    private void rehash() {
        int n2 = 2 * this.keys.length + 1;
        this.cacheEntriesThreshold = n2 * 77 / 100;
        if (this.cacheEntriesThreshold >= n2) {
            throw new RuntimeException("internal error: threshold must be less than capacity: " + n2);
        }
        char[][] cArrayArray = new char[n2][];
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < this.keys.length; ++i2) {
            char[] cArray;
            char[] cArray2 = this.keys[i2];
            this.keys[i2] = null;
            String string = this.values[i2];
            this.values[i2] = null;
            if (cArray2 == null) continue;
            int n3 = MXParser.fastHash(cArray2, 0, cArray2.length) % n2;
            while ((cArray = cArrayArray[n3]) != null) {
                if (MXParserCachingStrings.keysAreEqual(cArray, 0, cArray.length, cArray2, 0, cArray2.length)) {
                    throw new RuntimeException("internal cache error: duplicated keys: " + new String(cArray) + " and " + new String(cArray2));
                }
                n3 = (n3 + 1) % n2;
            }
            cArrayArray[n3] = cArray2;
            stringArray[n3] = string;
        }
        this.keys = cArrayArray;
        this.values = stringArray;
    }

    private static final boolean keysAreEqual(char[] cArray, int n2, int n3, char[] cArray2, int n4, int n5) {
        if (n3 != n5) {
            return false;
        }
        for (n5 = 0; n5 < n3; ++n5) {
            if (cArray[n2 + n5] == cArray2[n4 + n5]) continue;
            return false;
        }
        return true;
    }
}

