/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class XmlPullParserFactory {
    static final Class referenceContextClass;
    public static final String PROPERTY_NAME = "org.xmlpull.v1.XmlPullParserFactory";
    private static final String RESOURCE_NAME = "/META-INF/services/org.xmlpull.v1.XmlPullParserFactory";
    protected Vector parserClasses;
    protected String classNamesLocation;
    protected Vector serializerClasses;
    public Hashtable features = new Hashtable();

    public void setFeature(String string, boolean bl) {
        this.features.put(string, bl);
    }

    public boolean getFeature(String object) {
        if ((object = (Boolean)this.features.get(object)) != null) {
            return (Boolean)object;
        }
        return false;
    }

    public void setNamespaceAware(boolean bl) {
        this.features.put("http://xmlpull.org/v1/doc/features.html#process-namespaces", bl);
    }

    public boolean isNamespaceAware() {
        return this.getFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces");
    }

    public void setValidating(boolean bl) {
        this.features.put("http://xmlpull.org/v1/doc/features.html#validation", bl);
    }

    public boolean isValidating() {
        return this.getFeature("http://xmlpull.org/v1/doc/features.html#validation");
    }

    public XmlPullParser newPullParser() {
        if (this.parserClasses == null) {
            throw new XmlPullParserException("Factory initialization was incomplete - has not tried " + this.classNamesLocation);
        }
        if (this.parserClasses.size() == 0) {
            throw new XmlPullParserException("No valid parser classes found in " + this.classNamesLocation);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.parserClasses.size(); ++i2) {
            Class clazz = (Class)this.parserClasses.elementAt(i2);
            try {
                XmlPullParser xmlPullParser = (XmlPullParser)clazz.newInstance();
                Enumeration enumeration = this.features.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    Boolean bl = (Boolean)this.features.get(string);
                    if (bl == null || !bl.booleanValue()) continue;
                    xmlPullParser.setFeature(string, true);
                }
                return xmlPullParser;
            }
            catch (Exception exception) {
                stringBuffer.append(clazz.getName() + ": " + exception.toString() + "; ");
                continue;
            }
        }
        throw new XmlPullParserException("could not create parser: " + stringBuffer);
    }

    public XmlSerializer newSerializer() {
        if (this.serializerClasses == null) {
            throw new XmlPullParserException("Factory initialization incomplete - has not tried " + this.classNamesLocation);
        }
        if (this.serializerClasses.size() == 0) {
            throw new XmlPullParserException("No valid serializer classes found in " + this.classNamesLocation);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.serializerClasses.size(); ++i2) {
            Class clazz = (Class)this.serializerClasses.elementAt(i2);
            try {
                XmlSerializer xmlSerializer = (XmlSerializer)clazz.newInstance();
                return xmlSerializer;
            }
            catch (Exception exception) {
                stringBuffer.append(clazz.getName() + ": " + exception.toString() + "; ");
                continue;
            }
        }
        throw new XmlPullParserException("could not create serializer: " + stringBuffer);
    }

    public static XmlPullParserFactory newInstance() {
        return XmlPullParserFactory.newInstance(null, null);
    }

    public static XmlPullParserFactory newInstance(String string, Class object) {
        Serializable serializable;
        Object object2;
        if (object == null) {
            object = referenceContextClass;
        }
        if (string == null || string.length() == 0 || "DEFAULT".equals(string)) {
            try {
                int n2;
                object2 = ((Class)object).getResourceAsStream(RESOURCE_NAME);
                if (object2 == null) {
                    throw new XmlPullParserException("resource not found: /META-INF/services/org.xmlpull.v1.XmlPullParserFactory make sure that parser implementing XmlPull API is available");
                }
                serializable = new StringBuffer();
                while ((n2 = ((InputStream)object2).read()) >= 0) {
                    if (n2 <= 32) continue;
                    ((StringBuffer)serializable).append((char)n2);
                }
                ((InputStream)object2).close();
                string = ((StringBuffer)serializable).toString();
            }
            catch (Exception exception) {
                throw new XmlPullParserException(null, null, exception);
            }
            object = "resource /META-INF/services/org.xmlpull.v1.XmlPullParserFactory that contained '" + string + "'";
        } else {
            object = "parameter classNames to newInstance() that contained '" + string + "'";
        }
        object2 = null;
        serializable = new Vector();
        Vector vector = new Vector();
        int n3 = 0;
        while (n3 < string.length()) {
            int n4 = string.indexOf(44, n3);
            if (n4 == -1) {
                n4 = string.length();
            }
            String string2 = string.substring(n3, n4);
            Class<?> clazz = null;
            Object var8_11 = null;
            try {
                clazz = Class.forName(string2);
                var8_11 = clazz.newInstance();
            }
            catch (Exception exception) {}
            if (clazz != null) {
                boolean bl = false;
                if (var8_11 instanceof XmlPullParser) {
                    ((Vector)serializable).addElement(clazz);
                    bl = true;
                }
                if (var8_11 instanceof XmlSerializer) {
                    vector.addElement(clazz);
                    bl = true;
                }
                if (var8_11 instanceof XmlPullParserFactory) {
                    if (object2 == null) {
                        object2 = var8_11;
                    }
                    bl = true;
                }
                if (!bl) {
                    throw new XmlPullParserException("incompatible class: " + string2);
                }
            }
            n3 = n4 + 1;
        }
        if (object2 == null) {
            object2 = new XmlPullParserFactory();
        }
        ((XmlPullParserFactory)object2).parserClasses = serializable;
        ((XmlPullParserFactory)object2).serializerClasses = vector;
        ((XmlPullParserFactory)object2).classNamesLocation = object;
        return object2;
    }

    static {
        XmlPullParserFactory xmlPullParserFactory = new XmlPullParserFactory();
        referenceContextClass = xmlPullParserFactory.getClass();
    }
}

