/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1.builder;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;
import org.xmlpull.v1.builder.XmlBuilderException;
import org.xmlpull.v1.builder.XmlDocument;
import org.xmlpull.v1.builder.XmlElement;
import org.xmlpull.v1.builder.XmlNamespace;
import org.xmlpull.v1.builder.impl.XmlInfosetBuilderImpl;

public abstract class XmlInfosetBuilder {
    protected XmlPullParserFactory factory;

    public static XmlInfosetBuilder newInstance() {
        XmlInfosetBuilderImpl xmlInfosetBuilderImpl = new XmlInfosetBuilderImpl();
        try {
            xmlInfosetBuilderImpl.factory = XmlPullParserFactory.newInstance(System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
            xmlInfosetBuilderImpl.factory.setNamespaceAware(true);
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new XmlBuilderException("could not create XmlPull factory:" + xmlPullParserException, xmlPullParserException);
        }
        return xmlInfosetBuilderImpl;
    }

    public static XmlInfosetBuilder newInstance(XmlPullParserFactory xmlPullParserFactory) {
        if (xmlPullParserFactory == null) {
            throw new IllegalArgumentException();
        }
        XmlInfosetBuilderImpl xmlInfosetBuilderImpl = new XmlInfosetBuilderImpl();
        new XmlInfosetBuilderImpl().factory = xmlPullParserFactory;
        xmlInfosetBuilderImpl.factory.setNamespaceAware(true);
        return xmlInfosetBuilderImpl;
    }

    public XmlPullParserFactory getFactory() {
        return this.factory;
    }

    public XmlDocument newDocument() {
        return this.newDocument(null, null, null);
    }

    public abstract XmlDocument newDocument(String var1, Boolean var2, String var3);

    public abstract XmlElement newFragment(String var1);

    public abstract XmlElement newFragment(String var1, String var2);

    public abstract XmlElement newFragment(XmlNamespace var1, String var2);

    public abstract XmlNamespace newNamespace(String var1);

    public abstract XmlNamespace newNamespace(String var1, String var2);

    public abstract XmlDocument parse(XmlPullParser var1);

    public abstract Object parseItem(XmlPullParser var1);

    public abstract XmlElement parseStartTag(XmlPullParser var1);

    public XmlDocument parseInputStream(InputStream inputStream) {
        XmlPullParser xmlPullParser;
        try {
            xmlPullParser = this.factory.newPullParser();
            xmlPullParser.setInput(inputStream, null);
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new XmlBuilderException("could not start parsing input stream", xmlPullParserException);
        }
        return this.parse(xmlPullParser);
    }

    public XmlDocument parseInputStream(InputStream inputStream, String string) {
        XmlPullParser xmlPullParser;
        try {
            xmlPullParser = this.factory.newPullParser();
            xmlPullParser.setInput(inputStream, string);
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new XmlBuilderException("could not start parsing input stream (encoding=" + string + ")", xmlPullParserException);
        }
        return this.parse(xmlPullParser);
    }

    public XmlDocument parseReader(Reader reader) {
        XmlPullParser xmlPullParser;
        try {
            xmlPullParser = this.factory.newPullParser();
            xmlPullParser.setInput(reader);
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new XmlBuilderException("could not start parsing input from reader", xmlPullParserException);
        }
        return this.parse(xmlPullParser);
    }

    public abstract XmlDocument parseLocation(String var1);

    public abstract XmlElement parseFragment(XmlPullParser var1);

    public XmlElement parseFragmentFromInputStream(InputStream inputStream) {
        XmlPullParser xmlPullParser;
        try {
            xmlPullParser = this.factory.newPullParser();
            xmlPullParser.setInput(inputStream, null);
            try {
                xmlPullParser.nextTag();
            }
            catch (IOException iOException) {
                throw new XmlBuilderException("IO error when starting to parse input stream", iOException);
            }
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new XmlBuilderException("could not start parsing input stream", xmlPullParserException);
        }
        return this.parseFragment(xmlPullParser);
    }

    public XmlElement parseFragementFromInputStream(InputStream inputStream, String string) {
        XmlPullParser xmlPullParser;
        try {
            xmlPullParser = this.factory.newPullParser();
            xmlPullParser.setInput(inputStream, string);
            try {
                xmlPullParser.nextTag();
            }
            catch (IOException iOException) {
                throw new XmlBuilderException("IO error when starting to parse input stream (encoding=" + string + ")", iOException);
            }
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new XmlBuilderException("could not start parsing input stream (encoding=" + string + ")", xmlPullParserException);
        }
        return this.parseFragment(xmlPullParser);
    }

    public XmlElement parseFragmentFromReader(Reader reader) {
        XmlPullParser xmlPullParser;
        try {
            xmlPullParser = this.factory.newPullParser();
            xmlPullParser.setInput(reader);
            try {
                xmlPullParser.nextTag();
            }
            catch (IOException iOException) {
                throw new XmlBuilderException("IO error when starting to parse from reader", iOException);
            }
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new XmlBuilderException("could not start parsing input from reader", xmlPullParserException);
        }
        return this.parseFragment(xmlPullParser);
    }

    public void skipSubTree(XmlPullParser xmlPullParser) {
        try {
            xmlPullParser.require(2, null, null);
            int n2 = 1;
            while (n2 > 0) {
                int n3 = xmlPullParser.next();
                if (n3 == 3) {
                    --n2;
                    continue;
                }
                if (n3 != 2) continue;
                ++n2;
            }
            return;
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new XmlBuilderException("could not skip subtree", xmlPullParserException);
        }
        catch (IOException iOException) {
            throw new XmlBuilderException("IO error when skipping subtree", iOException);
        }
    }

    public abstract void serializeStartTag(XmlElement var1, XmlSerializer var2);

    public abstract void serializeEndTag(XmlElement var1, XmlSerializer var2);

    public abstract void serialize(Object var1, XmlSerializer var2);

    public abstract void serializeItem(Object var1, XmlSerializer var2);

    public void serializeToOutputStream(Object object, OutputStream outputStream) {
        this.serializeToOutputStream(object, outputStream, "UTF8");
    }

    public void serializeToOutputStream(Object object, OutputStream outputStream, String string) {
        XmlSerializer xmlSerializer;
        try {
            xmlSerializer = this.factory.newSerializer();
            xmlSerializer.setOutput(outputStream, string);
        }
        catch (Exception exception) {
            throw new XmlBuilderException("could not serialize node to output stream (encoding=" + string + ")", exception);
        }
        this.serialize(object, xmlSerializer);
        try {
            xmlSerializer.flush();
            return;
        }
        catch (IOException iOException) {
            throw new XmlBuilderException("could not flush output", iOException);
        }
    }

    public void serializeToWriter(Object object, Writer writer) {
        XmlSerializer xmlSerializer;
        try {
            xmlSerializer = this.factory.newSerializer();
            xmlSerializer.setOutput(writer);
        }
        catch (Exception exception) {
            throw new XmlBuilderException("could not serialize node to writer", exception);
        }
        this.serialize(object, xmlSerializer);
        try {
            xmlSerializer.flush();
            return;
        }
        catch (IOException iOException) {
            throw new XmlBuilderException("could not flush output", iOException);
        }
    }

    public String serializeToString(Object object) {
        StringWriter stringWriter = new StringWriter();
        this.serializeToWriter(object, stringWriter);
        return stringWriter.toString();
    }
}

