/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1.builder.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.xmlpull.v1.builder.Iterable;
import org.xmlpull.v1.builder.XmlAttribute;
import org.xmlpull.v1.builder.XmlBuilderException;
import org.xmlpull.v1.builder.XmlCharacters;
import org.xmlpull.v1.builder.XmlContained;
import org.xmlpull.v1.builder.XmlContainer;
import org.xmlpull.v1.builder.XmlDocument;
import org.xmlpull.v1.builder.XmlElement;
import org.xmlpull.v1.builder.XmlNamespace;
import org.xmlpull.v1.builder.impl.XmlAttributeImpl;
import org.xmlpull.v1.builder.impl.XmlElementImpl$1;
import org.xmlpull.v1.builder.impl.XmlElementImpl$2;
import org.xmlpull.v1.builder.impl.XmlElementImpl$3;
import org.xmlpull.v1.builder.impl.XmlElementImpl$EmptyIterator;
import org.xmlpull.v1.builder.impl.XmlNamespaceImpl;

public class XmlElementImpl
implements XmlElement {
    private XmlContainer parent;
    private XmlNamespace namespace;
    private String name;
    private List attrs;
    private List nsList;
    private List children;
    private static final Iterator EMPTY_ITERATOR = new XmlElementImpl$EmptyIterator(null);
    private static final Iterable EMPTY_ITERABLE = new XmlElementImpl$3();

    public Object clone() {
        XmlElementImpl xmlElementImpl = (XmlElementImpl)super.clone();
        ((XmlElementImpl)super.clone()).parent = null;
        xmlElementImpl.attrs = this.cloneList(xmlElementImpl, this.attrs);
        xmlElementImpl.nsList = this.cloneList(xmlElementImpl, this.nsList);
        xmlElementImpl.children = this.cloneList(xmlElementImpl, this.children);
        if (xmlElementImpl.children != null) {
            for (int i2 = 0; i2 < xmlElementImpl.children.size(); ++i2) {
                Object object = xmlElementImpl.children.get(i2);
                if (!(object instanceof XmlContained) || (object = (XmlContained)object).getParent() != this) continue;
                object.setParent(null);
                object.setParent(xmlElementImpl);
            }
        }
        return xmlElementImpl;
    }

    private List cloneList(XmlElementImpl xmlElementImpl, List list) {
        if (list == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList(list.size());
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Object object;
            Object e2 = list.get(i2);
            if (e2 instanceof XmlNamespace || e2 instanceof String) {
                object = e2;
            } else if (e2 instanceof XmlElement) {
                object = (XmlElement)e2;
                object = object.clone();
            } else if (e2 instanceof XmlAttribute) {
                object = (XmlAttribute)e2;
                object = new XmlAttributeImpl(xmlElementImpl, object.getType(), object.getNamespace(), object.getName(), object.getValue(), object.isSpecified());
            } else if (e2 instanceof Cloneable) {
                try {
                    object = e2.getClass().getMethod("clone", null).invoke(e2, null);
                }
                catch (Exception exception) {
                    throw new CloneNotSupportedException("failed to call clone() on  " + e2 + exception);
                }
            } else {
                throw new CloneNotSupportedException();
            }
            arrayList.add(object);
        }
        return arrayList;
    }

    XmlElementImpl(String string) {
        this.name = string;
    }

    XmlElementImpl(XmlNamespace xmlNamespace, String string) {
        this.namespace = xmlNamespace;
        this.name = string;
    }

    XmlElementImpl(String string, String string2) {
        if (string != null) {
            this.namespace = new XmlNamespaceImpl(null, string);
        }
        this.name = string2;
    }

    public XmlContainer getRoot() {
        XmlElement xmlElement;
        XmlContainer xmlContainer = this;
        while (xmlContainer instanceof XmlElement && (xmlElement = (XmlElement)xmlContainer).getParent() != null) {
            xmlContainer = xmlElement.getParent();
        }
        return xmlContainer;
    }

    public XmlContainer getParent() {
        return this.parent;
    }

    public void setParent(XmlContainer xmlContainer) {
        XmlDocument xmlDocument;
        if (xmlContainer != null && xmlContainer instanceof XmlDocument && (xmlDocument = (XmlDocument)xmlContainer).getDocumentElement() != this) {
            throw new XmlBuilderException("this element must be root document element to have document set as parent but already different element is set as root document element");
        }
        this.parent = xmlContainer;
    }

    public XmlNamespace getNamespace() {
        return this.namespace;
    }

    public String getNamespaceName() {
        if (this.namespace != null) {
            return this.namespace.getNamespaceName();
        }
        return null;
    }

    public void setNamespace(XmlNamespace xmlNamespace) {
        this.namespace = xmlNamespace;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String toString() {
        return "name[" + this.name + "]" + (this.namespace != null ? " namespace[" + this.namespace.getNamespaceName() + "]" : "");
    }

    public String getBaseUri() {
        throw new XmlBuilderException("not implemented");
    }

    public void setBaseUri(String string) {
        throw new XmlBuilderException("not implemented");
    }

    public Iterator attributes() {
        if (this.attrs == null) {
            return EMPTY_ITERATOR;
        }
        return this.attrs.iterator();
    }

    public XmlAttribute addAttribute(XmlAttribute xmlAttribute) {
        if (this.attrs == null) {
            this.ensureAttributeCapacity(5);
        }
        this.attrs.add(xmlAttribute);
        return xmlAttribute;
    }

    public XmlAttribute addAttribute(XmlNamespace xmlNamespace, String string, String string2) {
        return this.addAttribute("CDATA", xmlNamespace, string, string2, false);
    }

    public XmlAttribute addAttribute(String string, String string2) {
        return this.addAttribute("CDATA", null, string, string2, false);
    }

    public XmlAttribute addAttribute(String string, XmlNamespace xmlNamespace, String string2, String string3) {
        return this.addAttribute(string, xmlNamespace, string2, string3, false);
    }

    public XmlAttribute addAttribute(String object, XmlNamespace xmlNamespace, String string, String string2, boolean bl) {
        object = new XmlAttributeImpl(this, (String)object, xmlNamespace, string, string2, bl);
        return this.addAttribute((XmlAttribute)object);
    }

    public XmlAttribute addAttribute(String string, String object, String string2, String string3, String string4, boolean bl) {
        object = this.newNamespace((String)object, string2);
        return this.addAttribute(string, (XmlNamespace)object, string3, string4, bl);
    }

    public void ensureAttributeCapacity(int n2) {
        if (this.attrs == null) {
            this.attrs = new ArrayList(n2);
            return;
        }
        ((ArrayList)this.attrs).ensureCapacity(n2);
    }

    public String getAttributeValue(String object, String string) {
        if ((object = this.findAttribute((String)object, string)) != null) {
            return object.getValue();
        }
        return null;
    }

    public boolean hasAttributes() {
        return this.attrs != null && this.attrs.size() > 0;
    }

    public XmlAttribute attribute(String string) {
        return this.attribute(null, string);
    }

    public XmlAttribute attribute(XmlNamespace xmlNamespace, String string) {
        return this.findAttribute(xmlNamespace != null ? xmlNamespace.getNamespaceName() : null, string);
    }

    public XmlAttribute findAttribute(String string, String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("attribute name ca not ber null");
        }
        if (this.attrs == null) {
            return null;
        }
        int n2 = this.attrs.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            XmlAttribute xmlAttribute = (XmlAttribute)this.attrs.get(i2);
            String string3 = xmlAttribute.getName();
            if (string3 != string2 && !string2.equals(string3)) continue;
            if (string != null) {
                string3 = xmlAttribute.getNamespaceName();
                if (string.equals(string3)) {
                    return xmlAttribute;
                }
                if (string != "" || string3 != null) continue;
                return xmlAttribute;
            }
            if (xmlAttribute.getNamespace() == null) {
                return xmlAttribute;
            }
            if (xmlAttribute.getNamespace().getNamespaceName() != "") continue;
            return xmlAttribute;
        }
        return null;
    }

    public void removeAllAttributes() {
        this.attrs = null;
    }

    public void removeAttribute(XmlAttribute xmlAttribute) {
        if (this.attrs == null) {
            throw new XmlBuilderException("this element has no attributes to remove");
        }
        for (int i2 = 0; i2 < this.attrs.size(); ++i2) {
            if (!this.attrs.get(i2).equals(xmlAttribute)) continue;
            this.attrs.remove(i2);
            return;
        }
    }

    public XmlNamespace declareNamespace(String object, String string) {
        if (object == null) {
            throw new XmlBuilderException("namespace added to element must have not null prefix");
        }
        object = this.newNamespace((String)object, string);
        return this.declareNamespace((XmlNamespace)object);
    }

    public XmlNamespace declareNamespace(XmlNamespace xmlNamespace) {
        if (xmlNamespace.getPrefix() == null) {
            throw new XmlBuilderException("namespace added to element must have not null prefix");
        }
        if (this.nsList == null) {
            this.ensureNamespaceDeclarationsCapacity(5);
        }
        this.nsList.add(xmlNamespace);
        return xmlNamespace;
    }

    public boolean hasNamespaceDeclarations() {
        return this.nsList != null && this.nsList.size() > 0;
    }

    public XmlNamespace lookupNamespaceByPrefix(String string) {
        if (string == null) {
            throw new IllegalArgumentException("namespace prefix can not be null");
        }
        if (this.hasNamespaceDeclarations()) {
            int n2 = this.nsList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                XmlNamespace xmlNamespace = (XmlNamespace)this.nsList.get(i2);
                if (!string.equals(xmlNamespace.getPrefix())) continue;
                return xmlNamespace;
            }
        }
        if (this.parent != null && this.parent instanceof XmlElement) {
            return ((XmlElement)this.parent).lookupNamespaceByPrefix(string);
        }
        return null;
    }

    public XmlNamespace lookupNamespaceByName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("namespace name can not ber null");
        }
        if (this.hasNamespaceDeclarations()) {
            int n2 = this.nsList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                XmlNamespace xmlNamespace = (XmlNamespace)this.nsList.get(i2);
                if (!string.equals(xmlNamespace.getNamespaceName())) continue;
                return xmlNamespace;
            }
        }
        if (this.parent != null && this.parent instanceof XmlElement) {
            return ((XmlElement)this.parent).lookupNamespaceByName(string);
        }
        return null;
    }

    public Iterator namespaces() {
        if (this.nsList == null) {
            return EMPTY_ITERATOR;
        }
        return this.nsList.iterator();
    }

    public XmlNamespace newNamespace(String string) {
        return this.newNamespace(null, string);
    }

    public XmlNamespace newNamespace(String string, String string2) {
        return new XmlNamespaceImpl(string, string2);
    }

    public void ensureNamespaceDeclarationsCapacity(int n2) {
        if (this.nsList == null) {
            this.nsList = new ArrayList(n2);
            return;
        }
        ((ArrayList)this.nsList).ensureCapacity(n2);
    }

    public void removeAllNamespaceDeclarations() {
        this.nsList = null;
    }

    public void addChild(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (this.children == null) {
            this.ensureChildrenCapacity(1);
        }
        this.children.add(object);
    }

    public void addChild(int n2, Object object) {
        if (this.children == null) {
            this.ensureChildrenCapacity(1);
        }
        this.children.add(n2, object);
    }

    private void checkChildParent(Object object) {
        if (object instanceof XmlContainer) {
            if (object instanceof XmlElement) {
                object = (XmlElement)object;
                if ((object = object.getParent()) != null && object != this.parent) {
                    throw new XmlBuilderException("child must have no parent to be added to this node");
                }
                return;
            }
            if (object instanceof XmlDocument) {
                throw new XmlBuilderException("docuemet can not be stored as element child");
            }
        }
    }

    private void setChildParent(Object object) {
        if (object instanceof XmlElement) {
            object = (XmlElement)object;
            object.setParent(this);
        }
    }

    public XmlElement addElement(XmlElement xmlElement) {
        this.checkChildParent(xmlElement);
        this.addChild(xmlElement);
        this.setChildParent(xmlElement);
        return xmlElement;
    }

    public XmlElement addElement(int n2, XmlElement xmlElement) {
        this.checkChildParent(xmlElement);
        this.addChild(n2, xmlElement);
        this.setChildParent(xmlElement);
        return xmlElement;
    }

    public XmlElement addElement(XmlNamespace object, String string) {
        object = this.newElement((XmlNamespace)object, string);
        this.addChild(object);
        this.setChildParent(object);
        return object;
    }

    public XmlElement addElement(String string) {
        return this.addElement(null, string);
    }

    public Iterator children() {
        if (this.children == null) {
            return EMPTY_ITERATOR;
        }
        return this.children.iterator();
    }

    public Iterable requiredElementContent() {
        if (this.children == null) {
            return EMPTY_ITERABLE;
        }
        return new XmlElementImpl$1(this);
    }

    public String requiredTextContent() {
        if (this.children == null) {
            return "";
        }
        if (this.children.size() == 0) {
            return "";
        }
        if (this.children.size() == 1) {
            Object e2 = this.children.get(0);
            if (e2 instanceof String) {
                return e2.toString();
            }
            if (e2 instanceof XmlCharacters) {
                return ((XmlCharacters)e2).getText();
            }
            throw new XmlBuilderException("expected text content and not " + (e2 != null ? e2.getClass() : null) + " with '" + e2 + "'");
        }
        Iterator iterator = this.children();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            Object e3 = iterator.next();
            if (e3 instanceof String) {
                stringBuffer.append(e3.toString());
                continue;
            }
            if (e3 instanceof XmlCharacters) {
                stringBuffer.append(((XmlCharacters)e3).getText());
                continue;
            }
            throw new XmlBuilderException("expected text content and not " + e3.getClass() + " with '" + e3 + "'");
        }
        return stringBuffer.toString();
    }

    public void ensureChildrenCapacity(int n2) {
        if (this.children == null) {
            this.children = new ArrayList(n2);
            return;
        }
        ((ArrayList)this.children).ensureCapacity(n2);
    }

    public XmlElement element(int n2) {
        if (this.children == null) {
            return null;
        }
        int n3 = this.children.size();
        int n4 = 0;
        if (n2 >= 0 && n2 < n3 + 1) {
            for (int i2 = 0; i2 < n3; ++i2) {
                Object e2 = this.children.get(i2);
                if (!(e2 instanceof XmlElement) || ++n4 != n2) continue;
                return (XmlElement)e2;
            }
        } else {
            throw new IndexOutOfBoundsException("position " + n2 + " bigger or equal to " + n3 + " children");
        }
        throw new IndexOutOfBoundsException("position " + n2 + " too big as only " + n4 + " element(s) available");
    }

    public XmlElement requiredElement(XmlNamespace xmlNamespace, String string) {
        XmlElement xmlElement = this.element(xmlNamespace, string);
        if (xmlElement == null) {
            throw new XmlBuilderException("could not find element with name " + string + " in namespace " + (xmlNamespace != null ? xmlNamespace.getNamespaceName() : null));
        }
        return xmlElement;
    }

    public XmlElement element(XmlNamespace xmlNamespace, String string) {
        return this.element(xmlNamespace, string, false);
    }

    public XmlElement element(XmlNamespace xmlNamespace, String string, boolean bl) {
        XmlElement xmlElement = xmlNamespace != null ? this.findElementByName(xmlNamespace.getNamespaceName(), string) : this.findElementByName(string);
        if (xmlElement != null) {
            return xmlElement;
        }
        if (bl) {
            return this.addElement(xmlNamespace, string);
        }
        return null;
    }

    public Iterable elements(XmlNamespace xmlNamespace, String string) {
        return new XmlElementImpl$2(this, xmlNamespace, string);
    }

    public XmlElement findElementByName(String string) {
        if (this.children == null) {
            return null;
        }
        int n2 = this.children.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = this.children.get(i2);
            if (!(object instanceof XmlElement) || !string.equals((object = (XmlElement)object).getName())) continue;
            return object;
        }
        return null;
    }

    public XmlElement findElementByName(String string, String string2, XmlElement xmlElement) {
        throw new UnsupportedOperationException();
    }

    public XmlElement findElementByName(String string, XmlElement xmlElement) {
        throw new UnsupportedOperationException();
    }

    public XmlElement findElementByName(String string, String string2) {
        if (this.children == null) {
            return null;
        }
        int n2 = this.children.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            XmlNamespace xmlNamespace;
            Object object = this.children.get(i2);
            if (!(object instanceof XmlElement) || !((xmlNamespace = (object = (XmlElement)object).getNamespace()) != null ? string2.equals(object.getName()) && string.equals(xmlNamespace.getNamespaceName()) : string2.equals(object.getName()) && string == null)) continue;
            return object;
        }
        return null;
    }

    public boolean hasChild(Object object) {
        if (this.children == null) {
            return false;
        }
        for (int i2 = 0; i2 < this.children.size(); ++i2) {
            if (this.children.get(i2) != object) continue;
            return true;
        }
        return false;
    }

    public boolean hasChildren() {
        return this.children != null && this.children.size() > 0;
    }

    public void insertChild(int n2, Object object) {
        if (this.children == null) {
            this.ensureChildrenCapacity(1);
        }
        this.children.add(n2, object);
    }

    public XmlElement newElement(String string) {
        return this.newElement((XmlNamespace)null, string);
    }

    public XmlElement newElement(String string, String string2) {
        return new XmlElementImpl(string, string2);
    }

    public XmlElement newElement(XmlNamespace xmlNamespace, String string) {
        return new XmlElementImpl(xmlNamespace, string);
    }

    public void replaceChild(Object object, Object object2) {
        if (object == null) {
            throw new IllegalArgumentException("new child to replace can not be null");
        }
        if (object2 == null) {
            throw new IllegalArgumentException("old child to replace can not be null");
        }
        if (!this.hasChildren()) {
            throw new XmlBuilderException("no children available for replacement");
        }
        int n2 = this.children.indexOf(object2);
        if (n2 == -1) {
            throw new XmlBuilderException("could not find child to replace");
        }
        this.children.set(n2, object);
    }

    public void removeAllChildren() {
        this.children = null;
    }

    public void removeChild(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("child to remove can not be null");
        }
        if (!this.hasChildren()) {
            throw new XmlBuilderException("no children to remove");
        }
        int n2 = this.children.indexOf(object);
        if (n2 != -1) {
            this.children.remove(n2);
        }
    }

    public void replaceChildrenWithText(String string) {
        this.removeAllChildren();
        this.addChild(string);
    }

    private static final boolean isWhiteSpace(String string) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (string.charAt(i2) == ' ' || string.charAt(i2) == '\n' || string.charAt(i2) == '\t' || string.charAt(i2) == '\r') continue;
            return false;
        }
        return true;
    }

    static List access$000(XmlElementImpl xmlElementImpl) {
        return xmlElementImpl.children;
    }

    static boolean access$100(String string) {
        return XmlElementImpl.isWhiteSpace(string);
    }

    static Iterator access$300() {
        return EMPTY_ITERATOR;
    }
}

