/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1.builder.impl;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;
import org.xmlpull.v1.builder.XmlAttribute;
import org.xmlpull.v1.builder.XmlBuilderException;
import org.xmlpull.v1.builder.XmlCharacters;
import org.xmlpull.v1.builder.XmlComment;
import org.xmlpull.v1.builder.XmlContainer;
import org.xmlpull.v1.builder.XmlDocument;
import org.xmlpull.v1.builder.XmlElement;
import org.xmlpull.v1.builder.XmlInfosetBuilder;
import org.xmlpull.v1.builder.XmlNamespace;
import org.xmlpull.v1.builder.XmlSerializable;
import org.xmlpull.v1.builder.impl.XmlDocumentImpl;
import org.xmlpull.v1.builder.impl.XmlElementImpl;
import org.xmlpull.v1.builder.impl.XmlNamespaceImpl;

public class XmlInfosetBuilderImpl
extends XmlInfosetBuilder {
    private static final String PROPERTY_XMLDECL_STANDALONE = "http://xmlpull.org/v1/doc/properties.html#xmldecl-standalone";
    private static final String PROPERTY_XMLDECL_VERSION = "http://xmlpull.org/v1/doc/properties.html#xmldecl-version";

    public XmlDocument newDocument(String string, Boolean bl, String string2) {
        return new XmlDocumentImpl(string, bl, string2);
    }

    public XmlElement newFragment(String string) {
        return new XmlElementImpl(null, string);
    }

    public XmlElement newFragment(String string, String string2) {
        return new XmlElementImpl(string, string2);
    }

    public XmlElement newFragment(XmlNamespace xmlNamespace, String string) {
        return new XmlElementImpl(xmlNamespace, string);
    }

    public XmlNamespace newNamespace(String string) {
        return new XmlNamespaceImpl(null, string);
    }

    public XmlNamespace newNamespace(String string, String string2) {
        return new XmlNamespaceImpl(string, string2);
    }

    public XmlDocument parse(XmlPullParser object) {
        XmlDocument xmlDocument = this.parseDocumentStart((XmlPullParser)object);
        object = ((XmlInfosetBuilder)this).parseFragment((XmlPullParser)object);
        xmlDocument.setDocumentElement((XmlElement)object);
        return xmlDocument;
    }

    public Object parseItem(XmlPullParser xmlPullParser) {
        try {
            int n2 = xmlPullParser.getEventType();
            if (n2 == 2) {
                return ((XmlInfosetBuilder)this).parseStartTag(xmlPullParser);
            }
            if (n2 == 4) {
                return xmlPullParser.getText();
            }
            if (n2 == 0) {
                return this.parseDocumentStart(xmlPullParser);
            }
            throw new XmlBuilderException("currently unsupported event type " + XmlPullParser.TYPES[n2] + xmlPullParser.getPositionDescription());
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new XmlBuilderException("could not parse XML item", xmlPullParserException);
        }
    }

    private XmlDocument parseDocumentStart(XmlPullParser object) {
        try {
            if (object.getEventType() != 0) {
                throw new XmlBuilderException("parser must be positioned on beginning of document and not " + object.getPositionDescription());
            }
            object.next();
            String string = (String)object.getProperty(PROPERTY_XMLDECL_VERSION);
            Boolean bl = (Boolean)object.getProperty(PROPERTY_XMLDECL_STANDALONE);
            object = object.getInputEncoding();
            object = new XmlDocumentImpl(string, bl, (String)object);
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new XmlBuilderException("could not parse XML document prolog", xmlPullParserException);
        }
        catch (IOException iOException) {
            throw new XmlBuilderException("could not read XML document prolog", iOException);
        }
        return object;
    }

    public XmlElement parseFragment(XmlPullParser xmlPullParser) {
        try {
            int n2 = xmlPullParser.getDepth();
            int n3 = xmlPullParser.getEventType();
            if (n3 != 2) {
                throw new XmlBuilderException("expected parser to be on start tag and not " + XmlPullParser.TYPES[n3] + xmlPullParser.getPositionDescription());
            }
            XmlElement xmlElement = ((XmlInfosetBuilder)this).parseStartTag(xmlPullParser);
            while (true) {
                if ((n3 = xmlPullParser.next()) == 2) {
                    XmlElement xmlElement2 = ((XmlInfosetBuilder)this).parseStartTag(xmlPullParser);
                    xmlElement.addElement(xmlElement2);
                    xmlElement = xmlElement2;
                    continue;
                }
                if (n3 == 3) {
                    XmlContainer xmlContainer = xmlElement.getParent();
                    if (xmlContainer == null) {
                        if (xmlPullParser.getDepth() != n2) {
                            throw new XmlBuilderException("unbalanced input" + xmlPullParser.getPositionDescription());
                        }
                        return xmlElement;
                    }
                    xmlElement = (XmlElement)xmlContainer;
                    continue;
                }
                if (n3 != 4) continue;
                xmlElement.addChild(xmlPullParser.getText());
            }
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new XmlBuilderException("could not build tree from XML", xmlPullParserException);
        }
        catch (IOException iOException) {
            throw new XmlBuilderException("could not read XML tree content", iOException);
        }
    }

    public XmlElement parseStartTag(XmlPullParser xmlPullParser) {
        try {
            if (xmlPullParser.getEventType() != 2) {
                throw new XmlBuilderException("parser must be on START_TAG and not " + xmlPullParser.getPositionDescription());
            }
            Object object = xmlPullParser.getPrefix();
            object = new XmlNamespaceImpl((String)object, xmlPullParser.getNamespace());
            object = new XmlElementImpl((XmlNamespace)object, xmlPullParser.getName());
            XmlPullParser xmlPullParser2 = xmlPullParser;
            int n2 = xmlPullParser2.getNamespaceCount(xmlPullParser2.getDepth() - 1);
            while (true) {
                XmlPullParser xmlPullParser3 = xmlPullParser;
                if (n2 >= xmlPullParser3.getNamespaceCount(xmlPullParser3.getDepth())) break;
                String string = xmlPullParser.getNamespacePrefix(n2);
                object.declareNamespace(string == null ? "" : string, xmlPullParser.getNamespaceUri(n2));
                ++n2;
            }
            for (n2 = 0; n2 < xmlPullParser.getAttributeCount(); ++n2) {
                object.addAttribute(xmlPullParser.getAttributeType(n2), xmlPullParser.getAttributePrefix(n2), xmlPullParser.getAttributeNamespace(n2), xmlPullParser.getAttributeName(n2), xmlPullParser.getAttributeValue(n2), !xmlPullParser.isAttributeDefault(n2));
            }
            return object;
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new XmlBuilderException("could not parse XML start tag", xmlPullParserException);
        }
    }

    public XmlDocument parseLocation(String string) {
        URL uRL;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new XmlBuilderException("could not parse URL " + string, malformedURLException);
        }
        try {
            return this.parseInputStream(uRL.openStream());
        }
        catch (IOException iOException) {
            throw new XmlBuilderException("could not open connection to URL " + string, iOException);
        }
    }

    public void serialize(Object iterator, XmlSerializer xmlSerializer) {
        if (iterator instanceof Collection) {
            iterator = (Collection)((Object)iterator);
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                ((XmlInfosetBuilder)this).serialize(iterator.next(), xmlSerializer);
            }
            return;
        }
        if (iterator instanceof XmlContainer) {
            this.serializeContainer((XmlContainer)((Object)iterator), xmlSerializer);
            return;
        }
        ((XmlInfosetBuilder)this).serializeItem(iterator, xmlSerializer);
    }

    private void serializeContainer(XmlContainer xmlContainer, XmlSerializer xmlSerializer) {
        if (xmlContainer instanceof XmlSerializable) {
            try {
                ((XmlSerializable)((Object)xmlContainer)).serialize(xmlSerializer);
                return;
            }
            catch (IOException iOException) {
                throw new XmlBuilderException("could not serialize node " + xmlContainer + ": " + iOException, iOException);
            }
        }
        if (xmlContainer instanceof XmlDocument) {
            this.serializeDocument((XmlDocument)xmlContainer, xmlSerializer);
            return;
        }
        if (xmlContainer instanceof XmlElement) {
            this.serializeFragment((XmlElement)xmlContainer, xmlSerializer);
            return;
        }
        throw new IllegalArgumentException("could not serialzie unknown XML container " + xmlContainer.getClass());
    }

    public void serializeItem(Object clazz, XmlSerializer xmlSerializer) {
        block8: {
            try {
                if (clazz instanceof XmlSerializable) {
                    try {
                        ((XmlSerializable)((Object)clazz)).serialize(xmlSerializer);
                        break block8;
                    }
                    catch (IOException iOException) {
                        throw new XmlBuilderException("could not serialize item " + clazz + ": " + iOException, iOException);
                    }
                }
                if (clazz instanceof String) {
                    xmlSerializer.text(((Object)clazz).toString());
                    break block8;
                }
                if (clazz instanceof XmlCharacters) {
                    xmlSerializer.text(((XmlCharacters)((Object)clazz)).getText());
                    break block8;
                }
                if (clazz instanceof XmlComment) {
                    xmlSerializer.comment(((XmlComment)((Object)clazz)).getContent());
                    break block8;
                }
                throw new IllegalArgumentException("could not serialize " + (clazz != null ? clazz.getClass() : clazz));
            }
            catch (IOException iOException) {
                throw new XmlBuilderException("serializing XML start tag failed", iOException);
            }
        }
    }

    public void serializeStartTag(XmlElement xmlElement, XmlSerializer xmlSerializer) {
        try {
            Object object;
            Object object2;
            XmlNamespace xmlNamespace = xmlElement.getNamespace();
            String string = xmlNamespace != null ? xmlNamespace.getPrefix() : "";
            if (string == null) {
                string = "";
            }
            String string2 = null;
            if (xmlElement.hasNamespaceDeclarations()) {
                object2 = xmlElement.namespaces();
                while (object2.hasNext()) {
                    object = (XmlNamespace)object2.next();
                    String string3 = object.getPrefix();
                    if (!string.equals(string3)) {
                        xmlSerializer.setPrefix(string3, object.getNamespaceName());
                        continue;
                    }
                    string2 = object.getNamespaceName();
                }
            }
            if (string2 != null) {
                xmlSerializer.setPrefix(string, string2);
            } else if (xmlNamespace != null) {
                object2 = xmlNamespace.getNamespaceName();
                if (object2 == null) {
                    object2 = "";
                }
                object = null;
                if (((String)object2).length() > 0) {
                    xmlSerializer.getPrefix((String)object2, false);
                }
                object = "";
                if ("" != string && !((String)object).equals(string)) {
                    xmlSerializer.setPrefix(string, (String)object2);
                }
            }
            xmlSerializer.startTag(xmlElement.getNamespaceName(), xmlElement.getName());
            if (xmlElement.hasAttributes()) {
                object2 = xmlElement.attributes();
                while (object2.hasNext()) {
                    object = (XmlAttribute)object2.next();
                    if (object instanceof XmlSerializable) {
                        ((XmlSerializable)object).serialize(xmlSerializer);
                        continue;
                    }
                    xmlSerializer.attribute(object.getNamespaceName(), object.getName(), object.getValue());
                }
            }
            return;
        }
        catch (IOException iOException) {
            throw new XmlBuilderException("serializing XML start tag failed", iOException);
        }
    }

    public void serializeEndTag(XmlElement xmlElement, XmlSerializer xmlSerializer) {
        try {
            xmlSerializer.endTag(xmlElement.getNamespaceName(), xmlElement.getName());
            return;
        }
        catch (IOException iOException) {
            throw new XmlBuilderException("serializing XML end tag failed", iOException);
        }
    }

    private void serializeDocument(XmlDocument xmlDocument, XmlSerializer xmlSerializer) {
        try {
            xmlSerializer.startDocument(xmlDocument.getCharacterEncodingScheme(), xmlDocument.isStandalone());
        }
        catch (IOException iOException) {
            throw new XmlBuilderException("serializing XML document start failed", iOException);
        }
        if (xmlDocument.getDocumentElement() == null) {
            throw new XmlBuilderException("could not serialize document without root element " + xmlDocument + ": ");
        }
        this.serializeFragment(xmlDocument.getDocumentElement(), xmlSerializer);
        try {
            xmlSerializer.endDocument();
            return;
        }
        catch (IOException iOException) {
            throw new XmlBuilderException("serializing XML document end failed", iOException);
        }
    }

    private void serializeFragment(XmlElement xmlElement, XmlSerializer xmlSerializer) {
        ((XmlInfosetBuilder)this).serializeStartTag(xmlElement, xmlSerializer);
        if (xmlElement.hasChildren()) {
            Iterator iterator = xmlElement.children();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                if (e2 instanceof XmlSerializable) {
                    try {
                        ((XmlSerializable)e2).serialize(xmlSerializer);
                        continue;
                    }
                    catch (IOException iOException) {
                        throw new XmlBuilderException("could not serialize item " + e2 + ": " + iOException, iOException);
                    }
                }
                if (e2 instanceof XmlElement) {
                    this.serializeFragment((XmlElement)e2, xmlSerializer);
                    continue;
                }
                ((XmlInfosetBuilder)this).serializeItem(e2, xmlSerializer);
            }
        }
        ((XmlInfosetBuilder)this).serializeEndTag(xmlElement, xmlSerializer);
    }
}

