/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1.sax2;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class Driver
implements Attributes,
Locator,
XMLReader {
    protected static final String DECLARATION_HANDLER_PROPERTY = "http://xml.org/sax/properties/declaration-handler";
    protected static final String LEXICAL_HANDLER_PROPERTY = "http://xml.org/sax/properties/lexical-handler";
    protected static final String NAMESPACES_FEATURE = "http://xml.org/sax/features/namespaces";
    protected static final String NAMESPACE_PREFIXES_FEATURE = "http://xml.org/sax/features/namespace-prefixes";
    protected static final String VALIDATION_FEATURE = "http://xml.org/sax/features/validation";
    protected static final String APACHE_SCHEMA_VALIDATION_FEATURE = "http://apache.org/xml/features/validation/schema";
    protected static final String APACHE_DYNAMIC_VALIDATION_FEATURE = "http://apache.org/xml/features/validation/dynamic";
    protected ContentHandler contentHandler = new DefaultHandler();
    protected ErrorHandler errorHandler = new DefaultHandler();
    protected String systemId;
    protected XmlPullParser pp;

    public Driver() {
        XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance();
        xmlPullParserFactory.setNamespaceAware(true);
        this.pp = xmlPullParserFactory.newPullParser();
    }

    public Driver(XmlPullParser xmlPullParser) {
        this.pp = xmlPullParser;
    }

    public int getLength() {
        return this.pp.getAttributeCount();
    }

    public String getURI(int n2) {
        return this.pp.getAttributeNamespace(n2);
    }

    public String getLocalName(int n2) {
        return this.pp.getAttributeName(n2);
    }

    public String getQName(int n2) {
        String string = this.pp.getAttributePrefix(n2);
        if (string != null) {
            return string + ':' + this.pp.getAttributeName(n2);
        }
        return this.pp.getAttributeName(n2);
    }

    public String getType(int n2) {
        return this.pp.getAttributeType(n2);
    }

    public String getValue(int n2) {
        return this.pp.getAttributeValue(n2);
    }

    public int getIndex(String string, String string2) {
        for (int i2 = 0; i2 < this.pp.getAttributeCount(); ++i2) {
            if (!this.pp.getAttributeNamespace(i2).equals(string) || !this.pp.getAttributeName(i2).equals(string2)) continue;
            return i2;
        }
        return -1;
    }

    public int getIndex(String string) {
        for (int i2 = 0; i2 < this.pp.getAttributeCount(); ++i2) {
            if (!this.pp.getAttributeName(i2).equals(string)) continue;
            return i2;
        }
        return -1;
    }

    public String getType(String string, String string2) {
        for (int i2 = 0; i2 < this.pp.getAttributeCount(); ++i2) {
            if (!this.pp.getAttributeNamespace(i2).equals(string) || !this.pp.getAttributeName(i2).equals(string2)) continue;
            return this.pp.getAttributeType(i2);
        }
        return null;
    }

    public String getType(String string) {
        for (int i2 = 0; i2 < this.pp.getAttributeCount(); ++i2) {
            if (!this.pp.getAttributeName(i2).equals(string)) continue;
            return this.pp.getAttributeType(i2);
        }
        return null;
    }

    public String getValue(String string, String string2) {
        return this.pp.getAttributeValue(string, string2);
    }

    public String getValue(String string) {
        return this.pp.getAttributeValue(null, string);
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public int getLineNumber() {
        return this.pp.getLineNumber();
    }

    public int getColumnNumber() {
        return this.pp.getColumnNumber();
    }

    public boolean getFeature(String string) {
        if (NAMESPACES_FEATURE.equals(string)) {
            return this.pp.getFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces");
        }
        if (NAMESPACE_PREFIXES_FEATURE.equals(string)) {
            return this.pp.getFeature("http://xmlpull.org/v1/doc/features.html#report-namespace-prefixes");
        }
        if (VALIDATION_FEATURE.equals(string)) {
            return this.pp.getFeature("http://xmlpull.org/v1/doc/features.html#validation");
        }
        return this.pp.getFeature(string);
    }

    public void setFeature(String string, boolean bl) {
        block7: {
            try {
                if (NAMESPACES_FEATURE.equals(string)) {
                    this.pp.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", bl);
                    break block7;
                }
                if (NAMESPACE_PREFIXES_FEATURE.equals(string)) {
                    if (this.pp.getFeature("http://xmlpull.org/v1/doc/features.html#report-namespace-prefixes") != bl) {
                        this.pp.setFeature("http://xmlpull.org/v1/doc/features.html#report-namespace-prefixes", bl);
                        break block7;
                    }
                } else {
                    if (VALIDATION_FEATURE.equals(string)) {
                        this.pp.setFeature("http://xmlpull.org/v1/doc/features.html#validation", bl);
                        break block7;
                    }
                    this.pp.setFeature(string, bl);
                }
                return;
            }
            catch (XmlPullParserException xmlPullParserException) {
                throw new SAXNotSupportedException("problem with setting feature " + string + ": " + xmlPullParserException);
            }
        }
    }

    public Object getProperty(String string) {
        if (DECLARATION_HANDLER_PROPERTY.equals(string)) {
            return null;
        }
        if (LEXICAL_HANDLER_PROPERTY.equals(string)) {
            return null;
        }
        return this.pp.getProperty(string);
    }

    public void setProperty(String string, Object object) {
        if (DECLARATION_HANDLER_PROPERTY.equals(string)) {
            throw new SAXNotSupportedException("not supported setting property " + string);
        }
        if (LEXICAL_HANDLER_PROPERTY.equals(string)) {
            throw new SAXNotSupportedException("not supported setting property " + string);
        }
        try {
            this.pp.setProperty(string, object);
            return;
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new SAXNotSupportedException("not supported set property " + string + ": " + xmlPullParserException);
        }
    }

    public void setEntityResolver(EntityResolver entityResolver) {
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void parse(InputSource object) {
        Object object2;
        Object object3;
        block12: {
            this.systemId = ((InputSource)object).getSystemId();
            this.contentHandler.setDocumentLocator(this);
            object3 = ((InputSource)object).getCharacterStream();
            try {
                if (object3 == null) {
                    object3 = ((InputSource)object).getByteStream();
                    object2 = ((InputSource)object).getEncoding();
                    if (object3 == null) {
                        this.systemId = ((InputSource)object).getSystemId();
                        if (this.systemId == null) {
                            object = new SAXParseException("null source systemId", this);
                            this.errorHandler.fatalError((SAXParseException)object);
                            return;
                        }
                        try {
                            object = new URL(this.systemId);
                            object3 = ((URL)object).openStream();
                        }
                        catch (MalformedURLException malformedURLException) {
                            try {
                                object3 = new FileInputStream(this.systemId);
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                SAXParseException sAXParseException = new SAXParseException("could not open file with systemId " + this.systemId, this, fileNotFoundException);
                                this.errorHandler.fatalError(sAXParseException);
                                return;
                            }
                        }
                    }
                    this.pp.setInput((InputStream)object3, (String)object2);
                    break block12;
                }
                this.pp.setInput((Reader)object3);
            }
            catch (XmlPullParserException xmlPullParserException) {
                SAXParseException sAXParseException = new SAXParseException("parsing initialization error: " + xmlPullParserException, this, xmlPullParserException);
                this.errorHandler.fatalError(sAXParseException);
                return;
            }
        }
        try {
            this.contentHandler.startDocument();
            this.pp.next();
            if (this.pp.getEventType() != 2) {
                object3 = new SAXParseException("expected start tag not" + this.pp.getPositionDescription(), this);
                this.errorHandler.fatalError((SAXParseException)object3);
                return;
            }
        }
        catch (XmlPullParserException xmlPullParserException) {
            object2 = new SAXParseException("parsing initialization error: " + xmlPullParserException, this, xmlPullParserException);
            this.errorHandler.fatalError((SAXParseException)object2);
            return;
        }
        Driver driver = this;
        driver.parseSubTree(driver.pp);
        this.contentHandler.endDocument();
    }

    public void parse(String string) {
        this.parse(new InputSource(string));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parseSubTree(XmlPullParser xmlPullParser) {
        this.pp = xmlPullParser;
        boolean bl = xmlPullParser.getFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces");
        try {
            if (xmlPullParser.getEventType() != 2) {
                throw new SAXException("start tag must be read before skiping subtree" + xmlPullParser.getPositionDescription());
            }
            int[] nArray = new int[2];
            StringBuffer stringBuffer = new StringBuffer(16);
            int n2 = xmlPullParser.getDepth() - 1;
            int n3 = 2;
            do {
                switch (n3) {
                    case 2: {
                        if (bl) {
                            n3 = xmlPullParser.getDepth() - 1;
                            int n4 = n2 > n3 ? xmlPullParser.getNamespaceCount(n3) : 0;
                            n3 = xmlPullParser.getNamespaceCount(n3 + 1);
                            while (n4 < n3) {
                                this.contentHandler.startPrefixMapping(xmlPullParser.getNamespacePrefix(n4), xmlPullParser.getNamespaceUri(n4));
                                ++n4;
                            }
                            String string = xmlPullParser.getName();
                            String string2 = xmlPullParser.getPrefix();
                            if (string2 != null) {
                                stringBuffer.setLength(0);
                                stringBuffer.append(string2);
                                stringBuffer.append(':');
                                stringBuffer.append(string);
                            }
                            this.startElement(xmlPullParser.getNamespace(), string, string2 != null ? stringBuffer.toString() : string);
                            break;
                        }
                        this.startElement(xmlPullParser.getNamespace(), xmlPullParser.getName(), xmlPullParser.getName());
                        break;
                    }
                    case 4: {
                        char[] cArray = xmlPullParser.getTextCharacters(nArray);
                        this.contentHandler.characters(cArray, nArray[0], nArray[1]);
                        break;
                    }
                    case 3: {
                        if (bl) {
                            int n5;
                            String string = xmlPullParser.getName();
                            String string3 = xmlPullParser.getPrefix();
                            if (string3 != null) {
                                stringBuffer.setLength(0);
                                stringBuffer.append(string3);
                                stringBuffer.append(':');
                                stringBuffer.append(string);
                            }
                            this.contentHandler.endElement(xmlPullParser.getNamespace(), string, string3 != null ? stringBuffer.toString() : string);
                            int n6 = xmlPullParser.getDepth();
                            if (n2 > n6) {
                                XmlPullParser xmlPullParser2 = xmlPullParser;
                                n5 = xmlPullParser2.getNamespaceCount(xmlPullParser2.getDepth());
                            } else {
                                n5 = 0;
                            }
                            int n7 = n5;
                            XmlPullParser xmlPullParser3 = xmlPullParser;
                            n6 = xmlPullParser3.getNamespaceCount(xmlPullParser3.getDepth() - 1);
                            --n6;
                            while (n6 >= n7) {
                                this.contentHandler.endPrefixMapping(xmlPullParser.getNamespacePrefix(n6));
                                --n6;
                            }
                            break;
                        } else {
                            this.contentHandler.endElement(xmlPullParser.getNamespace(), xmlPullParser.getName(), xmlPullParser.getName());
                            break;
                        }
                    }
                    case 1: {
                        return;
                    }
                }
                n3 = xmlPullParser.next();
            } while (xmlPullParser.getDepth() > n2);
            return;
        }
        catch (XmlPullParserException xmlPullParserException) {
            SAXParseException sAXParseException = new SAXParseException("parsing error: " + xmlPullParserException, this, xmlPullParserException);
            xmlPullParserException.printStackTrace();
            this.errorHandler.fatalError(sAXParseException);
        }
    }

    protected void startElement(String string, String string2, String string3) {
        this.contentHandler.startElement(string, string2, string3, this);
    }
}

