/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1.util;

import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class XmlPullUtil {
    public static final String XSI_NS = "http://www.w3.org/2001/XMLSchema-instance";

    private XmlPullUtil() {
    }

    public static String getAttributeValue(XmlPullParser xmlPullParser, String string) {
        return xmlPullParser.getAttributeValue("", string);
    }

    public static String getPITarget(XmlPullParser xmlPullParser) {
        int n2;
        try {
            n2 = xmlPullParser.getEventType();
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new IllegalStateException("could not determine parser state: " + xmlPullParserException + xmlPullParser.getPositionDescription());
        }
        if (n2 != 8) {
            throw new IllegalStateException("parser must be on processing instruction and not " + XmlPullParser.TYPES[n2] + xmlPullParser.getPositionDescription());
        }
        String string = xmlPullParser.getText();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (!XmlPullUtil.isS(string.charAt(i2))) continue;
            return string.substring(0, i2);
        }
        return string;
    }

    public static String getPIData(XmlPullParser xmlPullParser) {
        int n2;
        try {
            n2 = xmlPullParser.getEventType();
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new IllegalStateException("could not determine parser state: " + xmlPullParserException + xmlPullParser.getPositionDescription());
        }
        if (n2 != 8) {
            throw new IllegalStateException("parser must be on processing instruction and not " + XmlPullParser.TYPES[n2] + xmlPullParser.getPositionDescription());
        }
        String string = xmlPullParser.getText();
        int n3 = -1;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (XmlPullUtil.isS(string.charAt(i2))) {
                n3 = i2;
                continue;
            }
            if (n3 <= 0) continue;
            return string.substring(i2);
        }
        return "";
    }

    private static boolean isS(char c2) {
        return c2 == ' ' || c2 == '\n' || c2 == '\r' || c2 == '\t';
    }

    public static void skipSubTree(XmlPullParser xmlPullParser) {
        xmlPullParser.require(2, null, null);
        int n2 = 1;
        while (n2 > 0) {
            int n3 = xmlPullParser.next();
            if (n3 == 3) {
                --n2;
                continue;
            }
            if (n3 != 2) continue;
            ++n2;
        }
    }

    public static void nextStartTag(XmlPullParser xmlPullParser) {
        if (xmlPullParser.nextTag() != 2) {
            throw new XmlPullParserException("expected START_TAG and not " + xmlPullParser.getPositionDescription());
        }
    }

    public static void nextStartTag(XmlPullParser xmlPullParser, String string) {
        xmlPullParser.nextTag();
        xmlPullParser.require(2, null, string);
    }

    public static void nextStartTag(XmlPullParser xmlPullParser, String string, String string2) {
        xmlPullParser.nextTag();
        xmlPullParser.require(2, string, string2);
    }

    public static void nextEndTag(XmlPullParser xmlPullParser, String string, String string2) {
        xmlPullParser.nextTag();
        xmlPullParser.require(3, string, string2);
    }

    public static String nextText(XmlPullParser xmlPullParser, String string, String string2) {
        if (string2 == null) {
            throw new XmlPullParserException("name for element can not be null");
        }
        xmlPullParser.require(2, string, string2);
        return xmlPullParser.nextText();
    }

    public static String getRequiredAttributeValue(XmlPullParser object, String string, String string2) {
        if ((object = object.getAttributeValue(string, string2)) == null) {
            throw new XmlPullParserException("required attribute " + string2 + " is not present");
        }
        return object;
    }

    public static void nextEndTag(XmlPullParser xmlPullParser) {
        if (xmlPullParser.nextTag() != 3) {
            throw new XmlPullParserException("expected END_TAG and not" + xmlPullParser.getPositionDescription());
        }
    }

    public static boolean matches(XmlPullParser xmlPullParser, int n2, String string, String string2) {
        boolean bl = !(n2 != xmlPullParser.getEventType() || string != null && !string.equals(xmlPullParser.getNamespace()) || string2 != null && !string2.equals(xmlPullParser.getName()));
        return bl;
    }

    public static void writeSimpleElement(XmlSerializer xmlSerializer, String string, String string2, String string3) {
        if (string2 == null) {
            throw new XmlPullParserException("name for element can not be null");
        }
        xmlSerializer.startTag(string, string2);
        if (string3 == null) {
            xmlSerializer.attribute(XSI_NS, "nil", "true");
        } else {
            xmlSerializer.text(string3);
        }
        xmlSerializer.endTag(string, string2);
    }
}

