/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.v1.wrapper.classic;

import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.util.XmlPullUtil;
import org.xmlpull.v1.wrapper.XmlPullParserWrapper;
import org.xmlpull.v1.wrapper.classic.XmlPullParserDelegate;

public class StaticXmlPullParserWrapper
extends XmlPullParserDelegate
implements XmlPullParserWrapper {
    public StaticXmlPullParserWrapper(XmlPullParser xmlPullParser) {
        super(xmlPullParser);
    }

    public String getAttributeValue(String string) {
        return XmlPullUtil.getAttributeValue(this.pp, string);
    }

    public String getRequiredAttributeValue(String string) {
        return XmlPullUtil.getRequiredAttributeValue(this.pp, null, string);
    }

    public String getRequiredAttributeValue(String string, String string2) {
        return XmlPullUtil.getRequiredAttributeValue(this.pp, string, string2);
    }

    public String getRequiredElementText(String string, String string2) {
        if (string2 == null) {
            throw new XmlPullParserException("name for element can not be null");
        }
        String string3 = null;
        this.nextStartTag(string, string2);
        if (this.isNil()) {
            this.nextEndTag(string, string2);
        } else {
            string3 = this.pp.nextText();
        }
        this.pp.require(3, string, string2);
        return string3;
    }

    public boolean isNil() {
        boolean bl = false;
        String string = this.pp.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "nil");
        if ("true".equals(string)) {
            bl = true;
        }
        return bl;
    }

    public String getPITarget() {
        return XmlPullUtil.getPITarget(this.pp);
    }

    public String getPIData() {
        return XmlPullUtil.getPIData(this.pp);
    }

    public boolean matches(int n2, String string, String string2) {
        return XmlPullUtil.matches(this.pp, n2, string, string2);
    }

    public void nextStartTag() {
        if (this.pp.nextTag() != 2) {
            throw new XmlPullParserException("expected START_TAG and not " + this.pp.getPositionDescription());
        }
    }

    public void nextStartTag(String string) {
        this.pp.nextTag();
        this.pp.require(2, null, string);
    }

    public void nextStartTag(String string, String string2) {
        this.pp.nextTag();
        this.pp.require(2, string, string2);
    }

    public void nextEndTag() {
        XmlPullUtil.nextEndTag(this.pp);
    }

    public void nextEndTag(String string) {
        XmlPullUtil.nextEndTag(this.pp, null, string);
    }

    public void nextEndTag(String string, String string2) {
        XmlPullUtil.nextEndTag(this.pp, string, string2);
    }

    public String nextText(String string, String string2) {
        return XmlPullUtil.nextText(this.pp, string, string2);
    }

    public void skipSubTree() {
        XmlPullUtil.skipSubTree(this.pp);
    }

    public double readDouble() {
        double d2;
        String string = this.pp.nextText();
        try {
            d2 = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (string.equals("INF") || string.toLowerCase().equals("infinity")) {
                d2 = Double.POSITIVE_INFINITY;
            }
            if (string.equals("-INF") || string.toLowerCase().equals("-infinity")) {
                d2 = Double.NEGATIVE_INFINITY;
            }
            if (string.equals("NaN")) {
                d2 = Double.NaN;
            }
            throw new XmlPullParserException("can't parse double value '" + string + "'", this, numberFormatException);
        }
        return d2;
    }

    public float readFloat() {
        float f2;
        String string = this.pp.nextText();
        try {
            f2 = Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (string.equals("INF") || string.toLowerCase().equals("infinity")) {
                f2 = Float.POSITIVE_INFINITY;
            }
            if (string.equals("-INF") || string.toLowerCase().equals("-infinity")) {
                f2 = Float.NEGATIVE_INFINITY;
            }
            if (string.equals("NaN")) {
                f2 = Float.NaN;
            }
            throw new XmlPullParserException("can't parse float value '" + string + "'", this, numberFormatException);
        }
        return f2;
    }

    private int parseDigits(String string, int n2, int n3) {
        int n4 = 0;
        if (n3 > 9) {
            try {
                int n5 = n2;
                n4 = Integer.parseInt(string.substring(n5, n5 + n3));
            }
            catch (NumberFormatException numberFormatException) {
                throw new XmlPullParserException(numberFormatException.getMessage());
            }
        } else {
            n3 = n2 + n3;
            while (n2 < n3) {
                char c2;
                if ((c2 = string.charAt(n2++)) >= '0' && c2 <= '9') {
                    n4 = n4 * 10 + (c2 - 48);
                    continue;
                }
                throw new XmlPullParserException("non-digit in number value", this, null);
            }
        }
        return n4;
    }

    private int parseInt(String string) {
        int n2 = 0;
        int n3 = string.length();
        if (n3 == 0) {
            throw new XmlPullParserException("empty number value", this, null);
        }
        boolean bl = false;
        char c2 = string.charAt(0);
        if (c2 == '-') {
            if (n3 > 9) {
                try {
                    return Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new XmlPullParserException(numberFormatException.getMessage(), this, null);
                }
            }
            bl = true;
            ++n2;
        } else if (c2 == '+') {
            ++n2;
        }
        if (n2 >= n3) {
            throw new XmlPullParserException("Invalid number format", this, null);
        }
        int n4 = this.parseDigits(string, n2, n3 - n2);
        if (bl) {
            return -n4;
        }
        return n4;
    }

    public int readInt() {
        try {
            StaticXmlPullParserWrapper staticXmlPullParserWrapper = this;
            int n2 = staticXmlPullParserWrapper.parseInt(staticXmlPullParserWrapper.pp.nextText());
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            throw new XmlPullParserException("can't parse int value", this, numberFormatException);
        }
    }

    public String readString() {
        String string = this.pp.getAttributeValue("http://www.w3.org/2001/XMLSchema", "nil");
        if ("true".equals(string)) {
            this.nextEndTag();
            return null;
        }
        return this.pp.nextText();
    }

    public double readDoubleElement(String string, String string2) {
        this.pp.require(2, string, string2);
        return this.readDouble();
    }

    public float readFloatElement(String string, String string2) {
        this.pp.require(2, string, string2);
        return this.readFloat();
    }

    public int readIntElement(String string, String string2) {
        this.pp.require(2, string, string2);
        return this.readInt();
    }

    public String readStringElemet(String string, String string2) {
        this.pp.require(2, string, string2);
        return this.readString();
    }
}

